package com.devdigital.gallerylib.utils;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.media.MediaPlayer;
import android.net.Uri;
import android.support.v4.content.FileProvider;

import com.devdigital.gallerylib.R;

import java.io.File;

import life.knowledge4.videotrimmer.utils.PathToContentURI;

/**
 * Utility to get Media MetaData
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 07 June 2018
 */
public class MediaUtils {

    /**
     * Get Video duration from file Uri
     *
     * @param context Application Context
     * @param uri Video file path
     * @return return video duration in millisecond
     */
    public static long getVideoDuration(Context context, Uri uri){
        String path = PathToContentURI.getPathFromUri(context, uri);
        return getVideoDuration(context, path);
    }

    /**
     * Get Video duration from file Uri
     *
     * @param context Application Context
     * @param path Video file path
     * @return return video duration in millisecond
     */
    public static long getVideoDuration(Context context, String path){
        File file = new File(path);
        if(file.exists() && file.length()>0) {
            try {
                MediaMetadataRetriever retriever = new MediaMetadataRetriever();
                //use one of overloaded setDataSource() functions to set your data source
                retriever.setDataSource(context, Uri.fromFile(file));
                String time = retriever.extractMetadata(MediaMetadataRetriever.METADATA_KEY_DURATION);
                long timeInMillis = Long.parseLong(time);
                retriever.release();
                return timeInMillis;
            } catch (IllegalArgumentException ex) {
                ex.printStackTrace();

                MediaPlayer mp = MediaPlayer.create(context, Uri.fromFile(file));
                int duration = mp.getDuration();
                mp.release();

                return duration;
            }
        }
        return -1;
    }

    public static void playVideo(Context context, Uri uri) {
        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.setDataAndType(uri, "video/*");
        intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
        context.startActivity(intent);
    }

    public static Bitmap getVideoThumbnail(Context context, Uri uri) {
        return null;
    }


}
