package com.devdigital.gallerylib.utils;

import android.os.Environment;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * File Utility Methods
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 07 June 2018
 */
public class FileUtil {
    /**
     * @return Return Empty file to store camera image.
     * @throws IOException if permission denied of failed to create new file.
     */
    public static File getCameraFile(boolean isImageFIle) {
        try {
            // Create an image file name
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmssSSS", Locale.getDefault()).format(new Date());
            String extension = isImageFIle ? ".jpg" : ".mp4";          // suffix

            String imageFileName = "IMG_" + timeStamp + extension;
            if (!isImageFIle)
                imageFileName = "VID_" + timeStamp + extension;

            File storageDir = new File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DCIM), "Camera");
            if (!storageDir.exists()) storageDir.mkdirs();

            File file = new File(storageDir, imageFileName);
            //Create empty file
            file.createNewFile();

            return file;
        } catch (IOException ex){
            ex.printStackTrace();
        }
        return null;
    }

}
