/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.gallerylib.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import com.devdigital.gallerylib.utils.UriFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ImageResizer {
    private final float mFileSizeLimit;
    private final Context context;

    public ImageResizer(Context context, float fileSizeLimit) {
        this.mFileSizeLimit = fileSizeLimit;
        this.context = context;
    }

    public Uri getResizedImage(Uri imageUri) throws FileNotFoundException {
        String path = UriFileUtils.getPathFromUri(this.context, imageUri);
        File file = new File(path);
        long fileLength = file.length();
        float fileSize = (float)fileLength / 1024.0f;
        if (fileSize <= this.mFileSizeLimit) {
            return imageUri;
        }
        float attempt = 1.0f;
        while ((float)file.length() / 1024.0f > this.mFileSizeLimit) {
            file = ImageResizer.resizeImageSize(file, attempt);
            attempt += 0.25f;
        }
        return Uri.fromFile((File)file);
    }

    private static File resizeImageSize(File file, float attempt) throws FileNotFoundException {
        BitmapFactory.Options bmOptions = new BitmapFactory.Options();
        if (file.length() > 0xA00000L) {
            bmOptions.inSampleSize = 8;
        } else if (file.length() > 0x600000L) {
            bmOptions.inSampleSize = 4;
        } else if (file.length() > 0x200000L) {
            bmOptions.inSampleSize = 2;
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)bmOptions);
        int newWidth = bitmap.getWidth();
        int newHeight = bitmap.getHeight();
        int maxSize = (int)(2400.0f / attempt);
        if (bitmap.getWidth() > maxSize || bitmap.getHeight() > maxSize) {
            if (bitmap.getWidth() > bitmap.getHeight()) {
                newWidth = maxSize;
                newHeight = (int)((double)bitmap.getHeight() * ((double)newWidth / (double)bitmap.getWidth()));
            } else {
                newHeight = maxSize;
                newWidth = (int)((double)bitmap.getWidth() * ((double)newHeight / (double)bitmap.getHeight()));
            }
        }
        Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newWidth, (int)newHeight, (boolean)true);
        FileOutputStream out = new FileOutputStream(file);
        scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
        return file;
    }
}

