package com.devdigital.gallerylib;

import android.app.Activity;
import android.content.Intent;
import android.support.v4.app.Fragment;

import com.devdigital.gallerylib.activities.ImagePickerActivity;

/**
 * Builder class to pick image file from gallery
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 08 June 2018
 */
public class ImagePicker {
    public static final int REQUEST_PICK = 124;

    private ImagePicker(){

    }

    public static class Builder{

        private final Activity activity;
        private Fragment fragment;
        private boolean crop;
        private float cropX=1, cropY=1;
        private boolean cameraOnly;
        private boolean galleryOnly;
        private float maxFileSize = Float.MAX_VALUE;
        private String cameraImagePath;

        public Builder(Activity activity){
            this.activity = activity;
        }

        public Builder(Fragment fragment){
            this.activity = fragment.getActivity();
            this.fragment = fragment;
        }

        public Builder crop(){
            this.crop = true;
            return this;
        }

        public Builder cropSquare(){
            return cropAspectRatio(1,1);
        }

        public Builder cropAspectRatio(float x, float y){
            this.crop = true;
            this.cropX = x;
            this.cropY = y;
            return this;
        }

        public Builder cameraOnly(){
            this.cameraOnly = true;
            this.galleryOnly = false;
            return this;
        }

        public Builder galleryOnly(){
            this.cameraOnly = false;
            this.galleryOnly = true;
            return this;
        }

        public Builder maxFileSize(float sizeInKB){
            this.maxFileSize = sizeInKB;
            return this;
        }

        public Builder cameraImagePath(String cameraImagePath){
            this.cameraImagePath = cameraImagePath;
            return this;
        }

        public void start(int reqCode){
            Intent intent = new Intent(activity, ImagePickerActivity.class);

            intent.putExtra(ImagePickerActivity.EXTRAS_CAMERA_ONLY, cameraOnly);
            intent.putExtra(ImagePickerActivity.EXTRAS_GALLERY_ONLY, galleryOnly);
            intent.putExtra(ImagePickerActivity.EXTRA_MAX_FILE_SIZE, maxFileSize);
            intent.putExtra(ImagePickerActivity.EXTRAS_CROP_IMAGE, crop);
            intent.putExtra(ImagePickerActivity.EXTRAS_CROP_ASPECT_X, cropX);
            intent.putExtra(ImagePickerActivity.EXTRAS_CROP_ASPECT_Y, cropY);
            intent.putExtra(ImagePickerActivity.EXTRAS_CAMERA_IMAGE_FILE_PATH, cameraImagePath);

            if(fragment!=null){
                fragment.startActivityForResult(intent, reqCode);
            }else{
                activity.startActivityForResult(intent, reqCode);
            }
        }

        public void start(){
            start(REQUEST_PICK);
        }
    }

}
