package com.devdigital.gallerylib.utils;

import android.content.Context;
import android.media.MediaMetadataRetriever;
import android.net.Uri;

/**
 * Utility to get Media MetaData
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 07 June 2018
 */
public class MediaUtils {

    /**
     * Get Video duration from file Uri
     *
     * @param context Application Context
     * @param uri Video file uri
     * @return return video duration in millisecond
     */
    public static long getVideoDuration(Context context, Uri uri){
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        //use one of overloaded setDataSource() functions to set your data source
        retriever.setDataSource(context, uri);
        String time = retriever.extractMetadata(MediaMetadataRetriever.METADATA_KEY_DURATION);
        long timeInMillis = Long.parseLong(time );
        retriever.release();
        return timeInMillis;
    }

}
