/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.customtabs.webview.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.devdigital.customtabs.R;
import com.devdigital.customtabs.webview.listener.WebViewListener;

public class CustomWebViewFragment
extends Fragment
implements SwipeRefreshLayout.OnRefreshListener {
    public static final String EXTRA_URL = "android.support.customtabs.extra.url";
    public static final String EXTRA_PROGRESS_TINT = "com.devdigital.customtab.extra.progress_tint";
    private WebView webView;
    private ProgressBar progressBar;
    private SwipeRefreshLayout refreshLayout;

    public static CustomWebViewFragment newInstance(String url) {
        return CustomWebViewFragment.newInstance(url, 0);
    }

    public static CustomWebViewFragment newInstance(String url, int progressTint) {
        CustomWebViewFragment fragment = new CustomWebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(EXTRA_URL, url);
        bundle.putInt(EXTRA_PROGRESS_TINT, progressTint);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void addFragment(FragmentManager manager, int container) {
        manager.beginTransaction().add(container, (Fragment)this).commit();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_webview, container, false);
        this.init(view);
        return view;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void init(View view) {
        this.webView = (WebView)view.findViewById(R.id.webView);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progressbar);
        this.refreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.refreshLayout);
        this.refreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        int color2 = this.getArguments().getInt(EXTRA_PROGRESS_TINT);
        if (color2 == 0) {
            color2 = ContextCompat.getColor((Context)this.getActivity(), (int)R.color.colorProgressBarTint);
        }
        this.progressBar.getIndeterminateDrawable().setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        WebSettings webSetting = this.webView.getSettings();
        webSetting.setJavaScriptEnabled(true);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                CustomWebViewFragment.this.refreshLayout.setRefreshing(false);
                CustomWebViewFragment.this.progressBar.setVisibility(8);
                if (CustomWebViewFragment.this.getActivity() instanceof WebViewListener) {
                    ((WebViewListener)CustomWebViewFragment.this.getActivity()).onPageLoad(view);
                }
            }
        });
        String url = this.getArguments().getString(EXTRA_URL);
        this.loadURL(url);
    }

    private void loadURL(String url) {
        this.webView.loadUrl(url);
    }

    public void onRefresh() {
        this.webView.reload();
    }
}

