/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.customtabs.webview.ui;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.webkit.WebView;
import com.devdigital.customtabs.R;
import com.devdigital.customtabs.webview.listener.WebViewListener;
import com.devdigital.customtabs.webview.ui.CustomWebViewFragment;

public class CustomWebViewActivity
extends AppCompatActivity
implements WebViewListener {
    private Toolbar toolbar;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_custom_webview);
        this.setToolbar();
        this.initUI();
    }

    private void initUI() {
        this.loadURL();
    }

    private void loadURL() {
        Uri uri = this.getIntent().getData();
        int tint = this.getIntent().getIntExtra("com.devdigital.customtab.extra.progress_tint", 0);
        CustomWebViewFragment fragment = CustomWebViewFragment.newInstance(uri.toString(), tint);
        this.getSupportFragmentManager().beginTransaction().add(R.id.webview_container, (Fragment)fragment).commit();
    }

    private void setToolbar() {
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(this.toolbar);
        this.getSupportActionBar().setDisplayShowHomeEnabled(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        Intent intent = this.getIntent();
        Uri uri = intent.getData();
        if (intent.hasExtra("com.devdigital.customtab.extra.toolbar_title")) {
            this.setTootbarTitle(intent.getStringExtra("com.devdigital.customtab.extra.toolbar_title"));
        } else {
            this.toolbar.setTitleTextAppearance((Context)this, R.style.TextAppearance_AppCompat_Subhead);
            this.setTootbarTitle(uri.toString());
        }
        int toolbarBgColor = intent.getIntExtra("com.devdigital.customtab.extra.toolbar_color", this.getAppColor(R.color.colorPrimary));
        this.toolbar.setBackgroundColor(toolbarBgColor);
        int toolbarTextColor = intent.getIntExtra("com.devdigital.customtab.extra.toolbar_title_color", this.getAppColor(R.color.colorToolbarTitleText));
        this.toolbar.setTitleTextColor(toolbarTextColor);
        int toolbarSubtextColor = intent.getIntExtra("com.devdigital.customtab.extra.toolbar_subtitle_color", this.getAppColor(R.color.colorToolbarSubtitleText));
        this.toolbar.setSubtitleTextColor(toolbarSubtextColor);
    }

    public int getAppColor(int colorRes) {
        return ContextCompat.getColor((Context)this, (int)colorRes);
    }

    private void setTootbarTitle(String title) {
        this.getSupportActionBar().setTitle((CharSequence)title);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        super.onOptionsItemSelected(item);
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
            }
        }
        return true;
    }

    public void onBackPressed() {
        this.finish();
        int[] animArray = this.getIntent().getIntArrayExtra("android.support.customtabs.extra.EXIT_ANIMATION_BUNDLE");
        if (animArray != null && animArray.length == 2) {
            this.overridePendingTransition(animArray[0], animArray[1]);
        }
    }

    @Override
    public void onPageLoad(WebView webView) {
        Intent intent = this.getIntent();
        if (!intent.hasExtra("com.devdigital.customtab.extra.toolbar_title")) {
            this.setTootbarTitle(webView.getTitle());
            this.toolbar.setSubtitle((CharSequence)webView.getUrl());
        }
    }
}

