/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.customtabs.webview;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.DrawableRes;
import android.support.v4.app.ActivityOptionsCompat;
import android.support.v4.content.ContextCompat;
import com.devdigital.customtabs.webview.ui.CustomWebViewActivity;

public class WebViewIntent {
    public static final String EXTRA_TOOLBAR_TITLE = "com.devdigital.customtab.extra.toolbar_title";
    public static final String EXTRA_TOOLBAR_COLOR = "com.devdigital.customtab.extra.toolbar_color";
    public static final String EXTRA_TOOLBAR_TITLE_COLOR = "com.devdigital.customtab.extra.toolbar_title_color";
    public static final String EXTRA_TOOLBAR_SUBTITLE_COLOR = "com.devdigital.customtab.extra.toolbar_subtitle_color";
    public static final String EXTRA_TOOLBAR_ICON_TINT = "com.devdigital.customtab.extra.toolbar_icon_tint";
    public static final String EXTRA_TOOLBAR_CLOSE_ICON = "com.devdigital.customtab.extra.toolbar_close_icon";
    public static final String EXTRA_PROGRESS_TINT = "com.devdigital.customtab.extra.progress_tint";
    public static final String EXTRA_EXIT_ANIMATION_BUNDLE = "android.support.customtabs.extra.EXIT_ANIMATION_BUNDLE";

    private WebViewIntent() {
    }

    public static class Builder {
        private Activity activity;
        private final Intent mIntent;
        private Bundle startAnimationBundle;

        public Builder(Activity activity) {
            this.activity = activity;
            this.mIntent = new Intent((Context)activity, CustomWebViewActivity.class);
        }

        public Builder setToolbarTitle(String title) {
            this.mIntent.putExtra(WebViewIntent.EXTRA_TOOLBAR_TITLE, title);
            return this;
        }

        public Builder setToolbarTitle(int resId) {
            this.mIntent.putExtra(WebViewIntent.EXTRA_TOOLBAR_TITLE, this.activity.getString(resId));
            return this;
        }

        public Builder setToolbarColor(int colorRes) {
            this.mIntent.putExtra(WebViewIntent.EXTRA_TOOLBAR_COLOR, this.getColor(colorRes));
            return this;
        }

        public Builder setToolbarTitleColor(int colorRes) {
            this.mIntent.putExtra(WebViewIntent.EXTRA_TOOLBAR_TITLE_COLOR, this.getColor(colorRes));
            return this;
        }

        public Builder setToolbarSubtitleColor(int colorRes) {
            this.mIntent.putExtra(WebViewIntent.EXTRA_TOOLBAR_SUBTITLE_COLOR, this.getColor(colorRes));
            return this;
        }

        public Builder setToolbarIconTint(int colorRes) {
            this.mIntent.putExtra(WebViewIntent.EXTRA_TOOLBAR_ICON_TINT, this.getColor(colorRes));
            return this;
        }

        public Builder setCloseIcon(@DrawableRes int iconResId) {
            this.mIntent.putExtra(WebViewIntent.EXTRA_TOOLBAR_CLOSE_ICON, iconResId);
            return this;
        }

        public Builder setProgressTint(int progressTint) {
            this.mIntent.putExtra(WebViewIntent.EXTRA_PROGRESS_TINT, this.getColor(progressTint));
            return this;
        }

        public Builder setStartAnimations(@AnimRes int enterResId, @AnimRes int exitResId) {
            this.startAnimationBundle = ActivityOptionsCompat.makeCustomAnimation((Context)this.activity, (int)enterResId, (int)exitResId).toBundle();
            return this;
        }

        public Builder setExitAnimations(@AnimRes int enterResId, @AnimRes int exitResId) {
            int[] array = new int[]{enterResId, exitResId};
            this.mIntent.putExtra(WebViewIntent.EXTRA_EXIT_ANIMATION_BUNDLE, array);
            return this;
        }

        public void launchUrl(String url) {
            this.mIntent.setData(Uri.parse((String)url));
            if (Build.VERSION.SDK_INT >= 16) {
                this.activity.startActivity(this.mIntent, this.startAnimationBundle);
            } else {
                this.activity.startActivity(this.mIntent);
            }
        }

        private int getColor(int colorRes) {
            return ContextCompat.getColor((Context)this.activity, (int)colorRes);
        }
    }
}

