package com.devdigital.customtabs.webview.ui;

import android.annotation.SuppressLint;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import com.devdigital.customtabs.R;
import com.devdigital.customtabs.webview.listener.WebViewListener;

public class CustomWebViewFragment extends Fragment implements SwipeRefreshLayout.OnRefreshListener {

    public static final String EXTRA_URL = "android.support.customtabs.extra.url";
    public static final String EXTRA_PROGRESS_TINT ="com.devdigital.customtab.extra.progress_tint";

    private WebView webView;
    private ProgressBar progressBar;
    private SwipeRefreshLayout refreshLayout;


    public static CustomWebViewFragment newInstance(String url) {
        return newInstance(url, 0);
    }

    public static CustomWebViewFragment newInstance(String url, int progressTint) {
        CustomWebViewFragment fragment = new CustomWebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(CustomWebViewFragment.EXTRA_URL, url);
        bundle.putInt(CustomWebViewFragment.EXTRA_PROGRESS_TINT, progressTint);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void addFragment(FragmentManager manager, int container) {
        manager.beginTransaction()
               .add(container, this)
               .commit();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_webview, container, false);
        init(view);
        return view;
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void init(View view) {
        webView = view.findViewById(R.id.webView);
        progressBar = view.findViewById(R.id.progressbar);
        refreshLayout = view.findViewById(R.id.refreshLayout);
        refreshLayout .setOnRefreshListener(this);

        int color = getArguments().getInt(EXTRA_PROGRESS_TINT);
        if(color==0) {
            color = ContextCompat.getColor(getActivity(), R.color.colorProgressBarTint);
        }
        progressBar.getIndeterminateDrawable().setColorFilter(color, PorterDuff.Mode.SRC_IN);

        WebSettings webSetting = webView.getSettings();
        webSetting.setJavaScriptEnabled(true);

        webView.setWebViewClient(new WebViewClient() {
            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                refreshLayout.setRefreshing(false);
                progressBar.setVisibility(View.GONE);
                if(getActivity() instanceof WebViewListener){
                    ((WebViewListener) getActivity()).onPageLoad(view);
                }
            }
        });

        String url = getArguments().getString(EXTRA_URL);
        loadURL(url);
    }

    private void loadURL(String url) {
        webView.loadUrl(url);
    }

    @Override
    public void onRefresh() {
        webView.reload();
    }

}
