package com.devdigital.customtabs.webview.ui;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.webkit.WebView;

import com.devdigital.customtabs.R;
import com.devdigital.customtabs.webview.WebViewIntent;
import com.devdigital.customtabs.webview.listener.WebViewListener;

import static com.devdigital.customtabs.webview.WebViewIntent.EXTRA_EXIT_ANIMATION_BUNDLE;

public class CustomWebViewActivity extends AppCompatActivity implements WebViewListener {

    private Toolbar toolbar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_custom_webview);
        setToolbar();
        initUI();
    }

    private void initUI() {
        loadURL();
    }

    private void loadURL() {
        Uri uri = getIntent().getData();
        int tint = getIntent().getIntExtra(WebViewIntent.EXTRA_PROGRESS_TINT, 0);
        Fragment fragment = CustomWebViewFragment.newInstance(uri.toString(), tint);
        getSupportFragmentManager()
                .beginTransaction()
                .add(R.id.webview_container, fragment)
                .commit();
    }

    private void setToolbar() {
        toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayShowHomeEnabled(true);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        Intent intent = getIntent();
        Uri uri = intent.getData();

        if (intent.hasExtra(WebViewIntent.EXTRA_TOOLBAR_TITLE)) {
            setTootbarTitle(intent.getStringExtra(WebViewIntent.EXTRA_TOOLBAR_TITLE));
        } else {
            toolbar.setTitleTextAppearance(this, R.style.TextAppearance_AppCompat_Subhead);
            setTootbarTitle(uri.toString());
        }

        int toolbarBgColor = intent.getIntExtra(WebViewIntent.EXTRA_TOOLBAR_COLOR, getAppColor(R.color.colorPrimary));
        //Change Toolbar Background Color
        toolbar.setBackgroundColor(toolbarBgColor);

        int toolbarTextColor = intent.getIntExtra(WebViewIntent.EXTRA_TOOLBAR_TITLE_COLOR, getAppColor(R.color.colorToolbarTitleText));
        //Change Toolbar Title Text Color
        toolbar.setTitleTextColor(toolbarTextColor);

        int toolbarSubtextColor = intent.getIntExtra(WebViewIntent.EXTRA_TOOLBAR_SUBTITLE_COLOR, getAppColor(R.color.colorToolbarSubtitleText));
        //Change Toolbar Subtitle Text Color
        toolbar.setSubtitleTextColor(toolbarSubtextColor);

    }

    public int getAppColor(int colorRes){
        return ContextCompat.getColor(this, colorRes);
    }

    private void setTootbarTitle(String title) {
        getSupportActionBar().setTitle(title);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        super.onOptionsItemSelected(item);
        switch (item.getItemId()) {
            case android.R.id.home:
                onBackPressed();
                break;
        }
        return true;
    }

    @Override
    public void onBackPressed() {
        finish();
        int[] animArray = getIntent().getIntArrayExtra(EXTRA_EXIT_ANIMATION_BUNDLE);
        if(animArray!=null && animArray.length==2){
            overridePendingTransition(animArray[0], animArray[1]);
        }
    }

    @Override
    public void onPageLoad(WebView webView) {
        Intent intent = getIntent();
        if (!intent.hasExtra(WebViewIntent.EXTRA_TOOLBAR_TITLE)) {
            setTootbarTitle(webView.getTitle());
            toolbar.setSubtitle(webView.getUrl());
        }
    }

}
