package com.devdigital.customtabs.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

/**
 * Package Utility
 *
 * @author Dhaval Patel
 * @version 1.0
 * @since 09 August 2018
 */
public class PackageUtil {
    public static final String CHROME_PACKAGE_NAME = "com.android.chrome";

    public static boolean isPackageExisted(Context context, String packageName) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo info = pm.getPackageInfo(packageName, PackageManager.GET_META_DATA);
        } catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return true;
    }

}
