/*
 * Decompiled with CFR 0.152.
 */
package com.devdigital.customtabs;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.net.Uri;
import android.support.annotation.AnimRes;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.customtabs.CustomTabsIntent;
import android.support.v4.content.ContextCompat;
import com.devdigital.customtabs.R;
import java.util.HashMap;
import java.util.Map;

public class CustomTabsManager {
    private final Context context;
    @ColorRes
    private int toolbarColor;
    @DrawableRes
    private int closeIcon;
    private String url;
    @AnimRes
    private int startAnimEnter;
    @AnimRes
    private int startAnimExit;
    @AnimRes
    private int exitAnimEnter;
    @AnimRes
    private int exitAnimExit;
    private Map<String, PendingIntent> menuItemMap;
    private Map<Integer, Object[]> actionButtonMap;
    private int closeIconColor;

    public CustomTabsManager(Context context, String url) {
        this.context = context;
        this.url = url;
        this.menuItemMap = new HashMap<String, PendingIntent>();
        this.actionButtonMap = new HashMap<Integer, Object[]>();
    }

    public void setToolbarColor(int toolbarColor) {
        this.toolbarColor = toolbarColor;
    }

    public void setCloseIcon(int closeIcon) {
        this.closeIcon = closeIcon;
    }

    public void setCloseIconColor(int closeIconColor) {
        this.closeIconColor = closeIconColor;
    }

    public void setStartAnimations(int startAnimEnter, int startAnimExit) {
        this.startAnimEnter = startAnimEnter;
        this.startAnimExit = startAnimExit;
    }

    public void setExitAnimations(int exitAnimEnter, int exitAnimExit) {
        this.exitAnimEnter = exitAnimEnter;
        this.exitAnimExit = exitAnimExit;
    }

    public void addMenuItem(String title, Class cls, String action) {
        this.menuItemMap.put(title, this.getPendingIntent(cls, action));
    }

    public void addActionButton(int icon, String description, Class cls, String action) {
        Object[] objects = new Object[]{description, this.getPendingIntent(cls, action)};
        this.actionButtonMap.put(icon, objects);
    }

    public void launchUrl() {
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
        if (this.toolbarColor == 0) {
            this.toolbarColor = R.color.colorPrimary;
        }
        builder.setToolbarColor(ContextCompat.getColor((Context)this.context, (int)this.toolbarColor));
        builder.setShowTitle(true);
        if (this.closeIcon != 0) {
            builder.setCloseButtonIcon(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.closeIcon));
        } else if (this.closeIconColor != 0) {
            Bitmap icon = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.ic_arrow_back_black_24dp);
            Bitmap bitmap1 = CustomTabsManager.tintImage(icon, ContextCompat.getColor((Context)this.context, (int)this.closeIconColor));
            builder.setCloseButtonIcon(bitmap1);
        }
        if (this.startAnimEnter != 0 && this.startAnimExit != 0) {
            builder.setStartAnimations(this.context, this.startAnimEnter, this.startAnimExit);
        }
        if (this.exitAnimEnter != 0 && this.exitAnimExit != 0) {
            builder.setExitAnimations(this.context, this.exitAnimEnter, this.exitAnimExit);
        }
        builder.addDefaultShareMenuItem();
        for (Integer iconResId : this.actionButtonMap.keySet()) {
            Bitmap icon = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)iconResId);
            Object[] objects = this.actionButtonMap.get(iconResId);
            builder.setActionButton(icon, (String)objects[0], (PendingIntent)objects[1], true);
        }
        for (String title : this.menuItemMap.keySet()) {
            builder.addMenuItem(title, this.menuItemMap.get(title));
        }
        CustomTabsIntent customTabsIntent = builder.build();
        customTabsIntent.launchUrl(this.context, Uri.parse((String)this.url));
    }

    private PendingIntent getPendingIntent(Class cls, String action) {
        Intent actionIntent = new Intent(this.context, cls);
        actionIntent.setAction(action);
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)actionIntent, (int)0);
    }

    public static Bitmap tintImage(Bitmap bitmap, int color2) {
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_IN));
        Bitmap bitmapResult = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmapResult);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return bitmapResult;
    }
}

