/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.unified;

import androidx.annotation.OptIn;
import androidx.media3.common.MediaItem;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.SimpleBasePlayer;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.source.MediaSource;
import com.devbrackets.android.exomedia.AudioPlayer;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u0017\u0018\u0000 12\u00020\u0001:\u00011B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0014\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0014J\f\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0014J\f\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0014J\f\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0014J\u0014\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0014\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0014\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010!\u001a\u00020\"H\u0014J\u0014\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010$\u001a\u00020%H\u0014J*\u0010&\u001a\u0006\u0012\u0002\b\u00030\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0014J$\u0010-\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u001cH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u00062"}, d2={"Lcom/devbrackets/android/exomedia/unified/AudioPlayerWrapper;", "Landroidx/media3/common/SimpleBasePlayer;", "audioPlayer", "Lcom/devbrackets/android/exomedia/AudioPlayer;", "playerConfig", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "<init>", "(Lcom/devbrackets/android/exomedia/AudioPlayer;Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "getAudioPlayer", "()Lcom/devbrackets/android/exomedia/AudioPlayer;", "getPlayerConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "latestPlayWhenReady", "", "getLatestPlayWhenReady", "()Z", "setLatestPlayWhenReady", "(Z)V", "getState", "Landroidx/media3/common/SimpleBasePlayer$State;", "handleSetPlayWhenReady", "Lcom/google/common/util/concurrent/ListenableFuture;", "playWhenReady", "handlePrepare", "handleStop", "handleRelease", "handleSetRepeatMode", "repeatMode", "", "handleSetPlaybackParameters", "playbackParameters", "Landroidx/media3/common/PlaybackParameters;", "handleSetTrackSelectionParameters", "trackSelectionParameters", "Landroidx/media3/common/TrackSelectionParameters;", "handleSetVolume", "volume", "", "handleSetMediaItems", "mediaItems", "", "Landroidx/media3/common/MediaItem;", "startIndex", "startPositionMs", "", "handleSeek", "mediaItemIndex", "positionMs", "seekCommand", "Companion", "library_release"})
@OptIn(markerClass={UnstableApi.class})
@SourceDebugExtension(value={"SMAP\nAudioPlayerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioPlayerWrapper.kt\ncom/devbrackets/android/exomedia/unified/AudioPlayerWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1863#2,2:134\n*S KotlinDebug\n*F\n+ 1 AudioPlayerWrapper.kt\ncom/devbrackets/android/exomedia/unified/AudioPlayerWrapper\n*L\n53#1:134,2\n*E\n"})
public class AudioPlayerWrapper
extends SimpleBasePlayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioPlayer audioPlayer;
    @NotNull
    private final PlayerConfig playerConfig;
    private boolean latestPlayWhenReady;
    @NotNull
    private static final List<Integer> SUPPORTED_AUDIO_COMMANDS;

    public AudioPlayerWrapper(@NotNull AudioPlayer audioPlayer, @NotNull PlayerConfig playerConfig) {
        Intrinsics.checkNotNullParameter((Object)audioPlayer, (String)"audioPlayer");
        Intrinsics.checkNotNullParameter((Object)playerConfig, (String)"playerConfig");
        super(playerConfig.getHandler().getLooper());
        this.audioPlayer = audioPlayer;
        this.playerConfig = playerConfig;
    }

    public /* synthetic */ AudioPlayerWrapper(AudioPlayer audioPlayer, PlayerConfig playerConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            playerConfig = audioPlayer.getPlayerConfig();
        }
        this(audioPlayer, playerConfig);
    }

    @NotNull
    public final AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    @NotNull
    protected final PlayerConfig getPlayerConfig() {
        return this.playerConfig;
    }

    protected final boolean getLatestPlayWhenReady() {
        return this.latestPlayWhenReady;
    }

    protected final void setLatestPlayWhenReady(boolean bl) {
        this.latestPlayWhenReady = bl;
    }

    @NotNull
    protected SimpleBasePlayer.State getState() {
        Player.Commands.Builder builder;
        Player.Commands.Builder $this$getState_u24lambda_u241 = builder = new Player.Commands.Builder();
        boolean bl = false;
        Iterable $this$forEach$iv = SUPPORTED_AUDIO_COMMANDS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl2 = false;
            $this$getState_u24lambda_u241.add(it);
        }
        Player.Commands commands = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)commands, (String)"build(...)");
        Player.Commands allowedCommands = commands;
        SimpleBasePlayer.State state = new SimpleBasePlayer.State.Builder().setAvailableCommands(allowedCommands).setPlayWhenReady(this.latestPlayWhenReady, 1).build();
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"build(...)");
        return state;
    }

    @NotNull
    protected ListenableFuture<?> handleSetPlayWhenReady(boolean playWhenReady) {
        this.latestPlayWhenReady = playWhenReady;
        boolean bl = playWhenReady;
        if (bl) {
            this.audioPlayer.start();
        } else if (!bl) {
            this.audioPlayer.pause();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture(...)");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handlePrepare() {
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture(...)");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleStop() {
        this.latestPlayWhenReady = false;
        this.audioPlayer.stop();
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture(...)");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleRelease() {
        this.audioPlayer.release();
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture(...)");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSetRepeatMode(int repeatMode) {
        this.audioPlayer.setRepeatMode(repeatMode);
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture(...)");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSetPlaybackParameters(@NotNull PlaybackParameters playbackParameters) {
        Intrinsics.checkNotNullParameter((Object)playbackParameters, (String)"playbackParameters");
        this.audioPlayer.setPlaybackSpeed(playbackParameters.speed);
        this.audioPlayer.setPlaybackPitch(playbackParameters.pitch);
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture(...)");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSetTrackSelectionParameters(@NotNull TrackSelectionParameters trackSelectionParameters) {
        Intrinsics.checkNotNullParameter((Object)trackSelectionParameters, (String)"trackSelectionParameters");
        this.audioPlayer.setTrackSelectionParameters(trackSelectionParameters);
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture(...)");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSetVolume(float volume) {
        this.audioPlayer.setVolume(volume);
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture(...)");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSetMediaItems(@NotNull List<MediaItem> mediaItems, int startIndex, long startPositionMs) {
        MediaSource mediaSource;
        Intrinsics.checkNotNullParameter(mediaItems, (String)"mediaItems");
        MediaItem mediaItem = (MediaItem)CollectionsKt.firstOrNull(mediaItems);
        if (mediaItem != null) {
            MediaItem it = mediaItem;
            boolean bl = false;
            mediaSource = this.playerConfig.getMediaSourceFactory().createMediaSource(it);
        } else {
            mediaSource = null;
        }
        MediaSource mediaSource2 = mediaSource;
        this.audioPlayer.setMedia(mediaSource2);
        if (startPositionMs > 0L) {
            this.audioPlayer.seekTo(startPositionMs);
        }
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture(...)");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSeek(int mediaItemIndex, long positionMs, int seekCommand) {
        this.audioPlayer.seekTo(positionMs);
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture(...)");
        return listenableFuture;
    }

    @NotNull
    public static final List<Integer> getSUPPORTED_AUDIO_COMMANDS() {
        return Companion.getSUPPORTED_AUDIO_COMMANDS();
    }

    static {
        Object[] objectArray = new Integer[]{1, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 18, 31, 21, 22, 28, 29, 30};
        SUPPORTED_AUDIO_COMMANDS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/devbrackets/android/exomedia/unified/AudioPlayerWrapper$Companion;", "", "<init>", "()V", "SUPPORTED_AUDIO_COMMANDS", "", "", "getSUPPORTED_AUDIO_COMMANDS$annotations", "getSUPPORTED_AUDIO_COMMANDS", "()Ljava/util/List;", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Integer> getSUPPORTED_AUDIO_COMMANDS() {
            return SUPPORTED_AUDIO_COMMANDS;
        }

        @JvmStatic
        public static /* synthetic */ void getSUPPORTED_AUDIO_COMMANDS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

