/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.fallback;

import android.content.Context;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.OptIn;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.UnstableApi;
import com.devbrackets.android.exomedia.core.state.PlaybackState;
import com.devbrackets.android.exomedia.fallback.FallbackMediaPlayer;
import com.devbrackets.android.exomedia.fallback.FallbackTimeline;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 y2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u00072\u00020\b:\u0001yB\u000f\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010O\u001a\u00020P2\b\b\u0001\u0010Q\u001a\u00020\u001dH\u0016J\b\u0010R\u001a\u00020PH\u0016J\b\u0010S\u001a\u00020PH\u0016J\b\u0010T\u001a\u00020PH\u0016J\b\u0010U\u001a\u00020\u0014H\u0016J\b\u0010V\u001a\u00020PH\u0016J\b\u0010W\u001a\u00020PH\u0016J\u0010\u0010X\u001a\u00020P2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020P2\u0006\u0010\\\u001a\u00020\u001fH\u0016J\u0012\u0010]\u001a\u00020P2\b\u0010^\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010_\u001a\u00020P2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0018\u0010`\u001a\u00020P2\u0006\u0010a\u001a\u00020\u000e2\u0006\u0010b\u001a\u00020\u001fH\u0016J\u0010\u0010c\u001a\u00020P2\u0006\u0010a\u001a\u00020\u000eH\u0016J\u0010\u0010d\u001a\u00020P2\u0006\u0010a\u001a\u00020\u000eH\u0016J\"\u0010e\u001a\u00020\u00142\b\u0010a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010f\u001a\u00020\u001f2\u0006\u0010g\u001a\u00020\u001fH\u0016J\u0010\u0010h\u001a\u00020P2\u0006\u0010a\u001a\u00020\u000eH\u0016J \u0010i\u001a\u00020\u00142\u0006\u0010a\u001a\u00020\u000e2\u0006\u0010f\u001a\u00020\u001f2\u0006\u0010g\u001a\u00020\u001fH\u0016J \u0010j\u001a\u00020P2\u0006\u0010a\u001a\u00020\u000e2\u0006\u0010k\u001a\u00020\u001f2\u0006\u0010l\u001a\u00020\u001fH\u0016J\b\u0010m\u001a\u00020.H\u0003J\u0010\u0010n\u001a\u00020P2\u0006\u0010o\u001a\u00020CH\u0002J\b\u0010p\u001a\u00020PH\u0002J\u0018\u0010q\u001a\u00020P2\u0006\u0010r\u001a\u00020!2\u0006\u0010s\u001a\u00020!H\u0002J\u0016\u0010t\u001a\u00020P2\f\u0010u\u001a\b\u0012\u0004\u0012\u00020P0vH\u0002J\u0010\u0010w\u001a\u00020P2\u0006\u0010x\u001a\u00020\u001fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00020!8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020!2\u0006\u0010'\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00103R\u0014\u00106\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0016R\u0014\u00108\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0014\u0010;\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010:R$\u0010=\u001a\u00020!2\u0006\u0010'\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010*\"\u0004\b?\u0010,R$\u0010@\u001a\u00020!2\u0006\u0010'\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010*\"\u0004\bB\u0010,R\u001e\u0010D\u001a\u00020C2\u0006\u0010'\u001a\u00020C@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0014\u0010G\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0016R(\u0010J\u001a\u0004\u0018\u00010I2\b\u0010'\u001a\u0004\u0018\u00010I@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010N\u00a8\u0006z"}, d2={"Lcom/devbrackets/android/exomedia/fallback/FallbackMediaPlayerImpl;", "Lcom/devbrackets/android/exomedia/fallback/FallbackMediaPlayer;", "Landroid/media/MediaPlayer$OnBufferingUpdateListener;", "Landroid/media/MediaPlayer$OnErrorListener;", "Landroid/media/MediaPlayer$OnPreparedListener;", "Landroid/media/MediaPlayer$OnCompletionListener;", "Landroid/media/MediaPlayer$OnSeekCompleteListener;", "Landroid/media/MediaPlayer$OnInfoListener;", "Landroid/media/MediaPlayer$OnVideoSizeChangedListener;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "mediaPlayer", "Landroid/media/MediaPlayer;", "getMediaPlayer", "()Landroid/media/MediaPlayer;", "mediaPlayer$delegate", "Lkotlin/Lazy;", "playWhenReady", "", "getPlayWhenReady", "()Z", "setPlayWhenReady", "(Z)V", "mediaUri", "Landroid/net/Uri;", "prepared", "requestedSeek", "", "currentBufferPercent", "", "requestedVolume", "", "listener", "Lcom/devbrackets/android/exomedia/fallback/FallbackMediaPlayer$Listener;", "headers", "", "", "value", "volume", "getVolume", "()F", "setVolume", "(F)V", "timeline", "Landroidx/media3/common/Timeline;", "getTimeline", "()Landroidx/media3/common/Timeline;", "duration", "getDuration", "()J", "currentPosition", "getCurrentPosition", "playing", "getPlaying", "bufferedPercent", "getBufferedPercent", "()I", "audioSessionId", "getAudioSessionId", "playbackSpeed", "getPlaybackSpeed", "setPlaybackSpeed", "playbackPitch", "getPlaybackPitch", "setPlaybackPitch", "Lcom/devbrackets/android/exomedia/core/state/PlaybackState;", "playbackState", "getPlaybackState", "()Lcom/devbrackets/android/exomedia/core/state/PlaybackState;", "mediaAccessible", "getMediaAccessible", "Landroid/view/Surface;", "surface", "getSurface", "()Landroid/view/Surface;", "setSurface", "(Landroid/view/Surface;)V", "seekTo", "", "positionMs", "start", "pause", "stop", "restart", "reset", "release", "setAudioAttributes", "attributes", "Landroidx/media3/common/AudioAttributes;", "setWakeLevel", "levelAndFlags", "setMedia", "uri", "setListener", "onBufferingUpdate", "mp", "percent", "onCompletion", "onSeekComplete", "onError", "what", "extra", "onPrepared", "onInfo", "onVideoSizeChanged", "width", "height", "buildTimeline", "updatePlaybackState", "state", "reportTimelineChanged", "updatePlaybackParams", "speed", "pitch", "tryWhenAccessible", "action", "Lkotlin/Function0;", "handleMediaInfo", "mediaInfo", "Companion", "library_release"})
public final class FallbackMediaPlayerImpl
implements FallbackMediaPlayer,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnVideoSizeChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy mediaPlayer$delegate;
    private boolean playWhenReady;
    @Nullable
    private Uri mediaUri;
    private boolean prepared;
    private long requestedSeek;
    private int currentBufferPercent;
    @FloatRange(from=0.0, to=1.0)
    private float requestedVolume;
    @Nullable
    private FallbackMediaPlayer.Listener listener;
    @Nullable
    private Map<String, String> headers;
    @NotNull
    private PlaybackState playbackState;
    @Nullable
    private Surface surface;
    @NotNull
    private static final String TAG = "FallbackMediaPlayerImpl";
    @NotNull
    private static final Set<PlaybackState> accessibleStates;

    public FallbackMediaPlayerImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.mediaPlayer$delegate = LazyKt.lazy(() -> FallbackMediaPlayerImpl.mediaPlayer_delegate$lambda$1(this));
        this.requestedVolume = 1.0f;
        this.playbackState = PlaybackState.IDLE;
    }

    private final MediaPlayer getMediaPlayer() {
        Lazy lazy = this.mediaPlayer$delegate;
        return (MediaPlayer)lazy.getValue();
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.playWhenReady;
    }

    @Override
    public void setPlayWhenReady(boolean bl) {
        this.playWhenReady = bl;
    }

    @Override
    public float getVolume() {
        return this.requestedVolume;
    }

    @Override
    public void setVolume(float value) {
        this.requestedVolume = value;
        this.getMediaPlayer().setVolume(value, value);
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        return this.buildTimeline();
    }

    @Override
    public long getDuration() {
        return !this.prepared || !this.getMediaAccessible() ? 0L : (long)this.getMediaPlayer().getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return !this.prepared || !this.getMediaAccessible() ? 0L : (long)this.getMediaPlayer().getCurrentPosition();
    }

    @Override
    public boolean getPlaying() {
        return this.getMediaAccessible() && this.getMediaPlayer().isPlaying();
    }

    @Override
    public int getBufferedPercent() {
        return this.currentBufferPercent;
    }

    @Override
    public int getAudioSessionId() {
        return this.getMediaPlayer().getAudioSessionId();
    }

    @Override
    public float getPlaybackSpeed() {
        return Build.VERSION.SDK_INT >= 23 ? this.getMediaPlayer().getPlaybackParams().getSpeed() : 1.0f;
    }

    @Override
    public void setPlaybackSpeed(float value) {
        this.updatePlaybackParams(value, this.getPlaybackPitch());
    }

    @Override
    public float getPlaybackPitch() {
        return Build.VERSION.SDK_INT >= 23 ? this.getMediaPlayer().getPlaybackParams().getPitch() : 1.0f;
    }

    @Override
    public void setPlaybackPitch(float value) {
        this.updatePlaybackParams(this.getPlaybackSpeed(), value);
    }

    @Override
    @NotNull
    public PlaybackState getPlaybackState() {
        return this.playbackState;
    }

    private final boolean getMediaAccessible() {
        return accessibleStates.contains((Object)this.getPlaybackState());
    }

    @Override
    @Nullable
    public Surface getSurface() {
        return this.surface;
    }

    @Override
    public void setSurface(@Nullable Surface value) {
        this.surface = value;
        this.getMediaPlayer().setSurface(this.getSurface());
    }

    @Override
    public void seekTo(@IntRange(from=0L) long positionMs) {
        if (!this.getMediaAccessible()) {
            this.requestedSeek = positionMs;
            return;
        }
        this.updatePlaybackState(PlaybackState.SEEKING);
        this.getMediaPlayer().seekTo((int)positionMs);
        this.requestedSeek = 0L;
    }

    @Override
    public void start() {
        if (this.getMediaAccessible()) {
            this.getMediaPlayer().start();
            this.updatePlaybackState(PlaybackState.PLAYING);
        }
        this.setPlayWhenReady(true);
    }

    @Override
    public void pause() {
        if (this.getMediaAccessible() && this.getMediaPlayer().isPlaying()) {
            this.getMediaPlayer().pause();
            this.updatePlaybackState(PlaybackState.PAUSED);
        }
        this.setPlayWhenReady(false);
    }

    @Override
    public void stop() {
        this.tryWhenAccessible((Function0<Unit>)((Function0)() -> FallbackMediaPlayerImpl.stop$lambda$2(this)));
        this.prepared = false;
        this.mediaUri = null;
        this.setPlayWhenReady(false);
        this.updatePlaybackState(PlaybackState.STOPPED);
    }

    @Override
    public boolean restart() {
        if (!this.prepared || !this.getMediaAccessible() && this.getPlaybackState() != PlaybackState.COMPLETED) {
            return false;
        }
        this.seekTo(0L);
        this.start();
        return true;
    }

    @Override
    public void reset() {
        this.getMediaPlayer().reset();
        this.prepared = false;
        this.mediaUri = null;
        this.setPlayWhenReady(false);
        this.updatePlaybackState(PlaybackState.IDLE);
    }

    @Override
    public void release() {
        this.tryWhenAccessible((Function0<Unit>)((Function0)() -> FallbackMediaPlayerImpl.release$lambda$3(this)));
        this.prepared = false;
        this.setPlayWhenReady(false);
        this.updatePlaybackState(PlaybackState.RELEASED);
    }

    @Override
    public void setAudioAttributes(@NotNull AudioAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.getMediaPlayer().setAudioAttributes(attributes.getAudioAttributesV21().audioAttributes);
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.getMediaPlayer().setWakeMode(this.context, levelAndFlags);
    }

    @Override
    public void setMedia(@Nullable Uri uri) {
        block4: {
            this.mediaUri = uri;
            this.prepared = false;
            if (uri == null) {
                return;
            }
            this.currentBufferPercent = 0;
            try {
                this.getMediaPlayer().reset();
                this.getMediaPlayer().setDataSource(this.context.getApplicationContext(), uri, this.headers);
                this.getMediaPlayer().prepareAsync();
                this.updatePlaybackState(PlaybackState.PREPARING);
            }
            catch (IOException ex) {
                Log.w((String)TAG, (String)("Unable to open content: " + uri), (Throwable)ex);
                this.updatePlaybackState(PlaybackState.ERROR);
                FallbackMediaPlayer.Listener listener2 = this.listener;
                if (listener2 == null) break block4;
                listener2.onError(this, 1, 0);
            }
            catch (IllegalArgumentException ex) {
                Log.w((String)TAG, (String)("Unable to open content: " + uri), (Throwable)ex);
                this.updatePlaybackState(PlaybackState.ERROR);
                FallbackMediaPlayer.Listener listener3 = this.listener;
                if (listener3 == null) break block4;
                listener3.onError(this, 1, 0);
            }
        }
    }

    @Override
    public void setListener(@Nullable FallbackMediaPlayer.Listener listener2) {
        this.listener = listener2;
    }

    public void onBufferingUpdate(@NotNull MediaPlayer mp, int percent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
            this.currentBufferPercent = percent;
            FallbackMediaPlayer.Listener listener2 = this.listener;
            if (listener2 == null) break block0;
            listener2.onBufferUpdate(this, percent);
        }
    }

    public void onCompletion(@NotNull MediaPlayer mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        this.updatePlaybackState(PlaybackState.COMPLETED);
    }

    public void onSeekComplete(@NotNull MediaPlayer mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        FallbackMediaPlayer.Listener listener2 = this.listener;
        if (listener2 != null) {
            listener2.onSeekComplete(this);
        }
        if (this.getPlayWhenReady()) {
            this.start();
        } else if (this.prepared) {
            this.updatePlaybackState(PlaybackState.PAUSED);
        }
    }

    public boolean onError(@Nullable MediaPlayer mp, int what, int extra) {
        this.updatePlaybackState(PlaybackState.ERROR);
        FallbackMediaPlayer.Listener listener2 = this.listener;
        return listener2 != null ? listener2.onError(this, what, extra) : false;
    }

    public void onPrepared(@NotNull MediaPlayer mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        this.prepared = true;
        this.updatePlaybackState(PlaybackState.READY);
        FallbackMediaPlayer.Listener listener2 = this.listener;
        if (listener2 != null) {
            listener2.onVideoSizeChanged(this, mp.getVideoWidth(), mp.getVideoHeight());
        }
        if (this.requestedSeek != 0L) {
            this.seekTo(this.requestedSeek);
        } else if (this.getPlayWhenReady()) {
            this.start();
        }
    }

    public boolean onInfo(@NotNull MediaPlayer mp, int what, int extra) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        this.handleMediaInfo(what);
        return false;
    }

    public void onVideoSizeChanged(@NotNull MediaPlayer mp, int width, int height) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
            FallbackMediaPlayer.Listener listener2 = this.listener;
            if (listener2 == null) break block0;
            listener2.onVideoSizeChanged(this, mp.getVideoWidth(), mp.getVideoHeight());
        }
    }

    @OptIn(markerClass={UnstableApi.class})
    private final Timeline buildTimeline() {
        Uri uri = this.mediaUri;
        if (uri != null && (this.getMediaAccessible() || this.getPlaybackState() == PlaybackState.COMPLETED)) {
            return new FallbackTimeline(uri, this.getDuration() * 1000L);
        }
        Timeline timeline = Timeline.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)timeline, (String)"EMPTY");
        return timeline;
    }

    private final void updatePlaybackState(PlaybackState state) {
        if (state == this.getPlaybackState()) {
            return;
        }
        this.playbackState = state;
        FallbackMediaPlayer.Listener listener2 = this.listener;
        if (listener2 != null) {
            listener2.onPlaybackStateChange(state);
        }
        this.reportTimelineChanged();
    }

    private final void reportTimelineChanged() {
        block0: {
            FallbackMediaPlayer.Listener listener2 = this.listener;
            if (listener2 == null) break block0;
            listener2.onTimelineChanged(this.buildTimeline());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePlaybackParams(float speed, float pitch) {
        void $this$updatePlaybackParams_u24lambda_u244;
        PlaybackParams playbackParams;
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        PlaybackParams playbackParams2 = playbackParams = new PlaybackParams();
        MediaPlayer mediaPlayer = this.getMediaPlayer();
        boolean bl = false;
        $this$updatePlaybackParams_u24lambda_u244.setSpeed(speed);
        $this$updatePlaybackParams_u24lambda_u244.setPitch(pitch);
        mediaPlayer.setPlaybackParams(playbackParams);
    }

    private final void tryWhenAccessible(Function0<Unit> action) {
        if (!this.getMediaAccessible()) {
            return;
        }
        try {
            action.invoke();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"error calling action()", (Throwable)e);
        }
    }

    private final void handleMediaInfo(int mediaInfo) {
        if (mediaInfo == 701) {
            this.updatePlaybackState(PlaybackState.BUFFERING);
            return;
        }
        if (mediaInfo != 702) {
            return;
        }
        if (this.getPlaying()) {
            this.updatePlaybackState(PlaybackState.PLAYING);
            return;
        }
        if (this.getPlayWhenReady()) {
            this.start();
            return;
        }
        this.updatePlaybackState(PlaybackState.PAUSED);
    }

    private static final MediaPlayer mediaPlayer_delegate$lambda$1(FallbackMediaPlayerImpl this$0) {
        MediaPlayer mediaPlayer;
        MediaPlayer $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240 = mediaPlayer = new MediaPlayer();
        boolean bl = false;
        $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240.setOnInfoListener((MediaPlayer.OnInfoListener)this$0);
        $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240.setOnErrorListener((MediaPlayer.OnErrorListener)this$0);
        $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240.setOnPreparedListener((MediaPlayer.OnPreparedListener)this$0);
        $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240.setOnCompletionListener((MediaPlayer.OnCompletionListener)this$0);
        $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this$0);
        $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this$0);
        $this$mediaPlayer_delegate_u24lambda_u241_u24lambda_u240.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this$0);
        return mediaPlayer;
    }

    private static final Unit stop$lambda$2(FallbackMediaPlayerImpl this$0) {
        this$0.getMediaPlayer().stop();
        return Unit.INSTANCE;
    }

    private static final Unit release$lambda$3(FallbackMediaPlayerImpl this$0) {
        this$0.getMediaPlayer().reset();
        this$0.getMediaPlayer().release();
        return Unit.INSTANCE;
    }

    static {
        PlaybackState[] playbackStateArray = new PlaybackState[]{PlaybackState.BUFFERING, PlaybackState.SEEKING, PlaybackState.READY, PlaybackState.PLAYING, PlaybackState.PAUSED};
        accessibleStates = SetsKt.setOf((Object[])playbackStateArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/devbrackets/android/exomedia/fallback/FallbackMediaPlayerImpl$Companion;", "", "<init>", "()V", "TAG", "", "accessibleStates", "", "Lcom/devbrackets/android/exomedia/core/state/PlaybackState;", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

