/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video;

import android.net.Uri;
import android.view.Surface;
import androidx.annotation.IntRange;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.VideoSize;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.TrackGroupArray;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.audio.MediaItem;
import com.devbrackets.android.exomedia.core.listener.CaptionListener;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.listener.VideoSizeListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.video.VideoPlayerApi;
import com.devbrackets.android.exomedia.core.video.surface.SurfaceEnvelope;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayerImpl;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004\u0080\u0001\u0081\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010S\u001a\u00020T2\b\u0010U\u001a\u0004\u0018\u00010VH\u0016J\b\u0010W\u001a\u00020TH\u0016J\b\u0010X\u001a\u00020\u0015H\u0016J\b\u0010Y\u001a\u00020TH\u0016J\u0012\u0010Z\u001a\u00020T2\b\b\u0001\u0010[\u001a\u000200H\u0016J\u0010\u0010\\\u001a\u00020T2\u0006\u0010]\u001a\u000206H\u0016J\b\u0010^\u001a\u00020TH\u0016J\b\u0010_\u001a\u00020TH\u0016J\b\u0010`\u001a\u00020TH\u0016J\u0010\u0010`\u001a\u00020T2\u0006\u0010a\u001a\u00020\u0015H\u0016J\b\u0010b\u001a\u00020\u0015H\u0016J\u0010\u0010c\u001a\u00020T2\u0006\u0010d\u001a\u00020eH\u0016J\u0012\u0010f\u001a\u00020T2\b\u0010g\u001a\u0004\u0018\u00010hH\u0016J \u0010i\u001a\u00020T2\u0006\u0010j\u001a\u00020E2\u0006\u0010k\u001a\u0002062\u0006\u0010l\u001a\u000206H\u0016J\u0018\u0010m\u001a\u0002062\u0006\u0010j\u001a\u00020E2\u0006\u0010k\u001a\u000206H\u0016J\u0010\u0010n\u001a\u00020T2\u0006\u0010j\u001a\u00020EH\u0016J\u0018\u0010o\u001a\u00020T2\u0006\u0010j\u001a\u00020E2\u0006\u0010p\u001a\u00020\u0015H\u0016J\u0010\u0010q\u001a\u00020\u00152\u0006\u0010j\u001a\u00020EH\u0016J\u0010\u0010r\u001a\u00020\u00152\u0006\u0010s\u001a\u00020%H\u0016J\u0010\u0010t\u001a\u00020\u00152\u0006\u0010u\u001a\u00020%H\u0016J\u0010\u0010v\u001a\u00020T2\u0006\u0010w\u001a\u00020xH\u0016J\u0010\u0010y\u001a\u00020T2\u0006\u0010z\u001a\u000206H\u0016J\u0010\u0010{\u001a\u00020T2\b\u0010\u0004\u001a\u0004\u0018\u00010|J\u0006\u0010}\u001a\u00020TJ\u0010\u0010~\u001a\u00020T2\u0006\u0010\u007f\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u00060!R\u00020\u0000X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R$\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020%8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0017R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00102R\u0014\u00105\u001a\u0002068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0016\u00109\u001a\u0004\u0018\u00010:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0014\u0010=\u001a\u00020>8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0014\u0010A\u001a\u0002068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u00108R\"\u0010C\u001a\u0010\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020F\u0018\u00010D8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0014\u0010I\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010(R\u0014\u0010K\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010(R(\u0010N\u001a\u0004\u0018\u00010M2\b\u0010$\u001a\u0004\u0018\u00010M8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010R\u00a8\u0006\u0082\u0001"}, d2={"Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer;", "Lcom/devbrackets/android/exomedia/core/video/VideoPlayerApi;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "surface", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;", "<init>", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;)V", "corePlayer", "Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl;", "getCorePlayer", "()Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl;", "corePlayer$delegate", "Lkotlin/Lazy;", "mux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "getMux", "()Lcom/devbrackets/android/exomedia/core/ListenerMux;", "setMux", "(Lcom/devbrackets/android/exomedia/core/ListenerMux;)V", "playRequested", "", "getPlayRequested", "()Z", "setPlayRequested", "(Z)V", "internalListeners", "Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$InternalListeners;", "getInternalListeners", "()Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$InternalListeners;", "setInternalListeners", "(Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$InternalListeners;)V", "surfaceCallback", "Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$SurfaceCallback;", "getSurfaceCallback", "()Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$SurfaceCallback;", "value", "", "volume", "getVolume", "()F", "setVolume", "(F)V", "playerConfig", "getPlayerConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "isPlaying", "duration", "", "getDuration", "()J", "currentPosition", "getCurrentPosition", "bufferedPercent", "", "getBufferedPercent", "()I", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "timeline", "Landroidx/media3/common/Timeline;", "getTimeline", "()Landroidx/media3/common/Timeline;", "audioSessionId", "getAudioSessionId", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Landroidx/media3/exoplayer/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "playbackSpeed", "getPlaybackSpeed", "playbackPitch", "getPlaybackPitch", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "drmSessionManagerProvider", "getDrmSessionManagerProvider", "()Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;)V", "setMedia", "", "mediaItem", "Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "reset", "restart", "release", "seekTo", "milliseconds", "setWakeLevel", "levelAndFlags", "start", "pause", "stop", "clearSurface", "trackSelectionAvailable", "setTrackSelectionParameters", "parameters", "Landroidx/media3/common/TrackSelectionParameters;", "setCaptionListener", "listener", "Lcom/devbrackets/android/exomedia/core/listener/CaptionListener;", "setSelectedTrack", "type", "groupIndex", "trackIndex", "getSelectedTrackIndex", "clearSelectedTracks", "setRendererEnabled", "enabled", "isRendererEnabled", "setPlaybackSpeed", "speed", "setPlaybackPitch", "pitch", "setAudioAttributes", "attributes", "Landroidx/media3/common/AudioAttributes;", "setRepeatMode", "repeatMode", "onSurfaceReady", "Landroid/view/Surface;", "onSurfaceDestroyed", "setListenerMux", "listenerMux", "InternalListeners", "SurfaceCallback", "library_release"})
public final class ExoVideoPlayer
implements VideoPlayerApi {
    @NotNull
    private final PlayerConfig config;
    @NotNull
    private final SurfaceEnvelope surface;
    @NotNull
    private final Lazy corePlayer$delegate;
    @Nullable
    private ListenerMux mux;
    private boolean playRequested;
    @NotNull
    private InternalListeners internalListeners;
    @NotNull
    private final SurfaceCallback surfaceCallback;

    public ExoVideoPlayer(@NotNull PlayerConfig config, @NotNull SurfaceEnvelope surface) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.config = config;
        this.surface = surface;
        this.corePlayer$delegate = LazyKt.lazy(() -> ExoVideoPlayer.corePlayer_delegate$lambda$1(this));
        this.internalListeners = new InternalListeners();
        this.surfaceCallback = new SurfaceCallback();
        this.surface.addCallback(this.surfaceCallback);
        this.surface.setVideoSize(0, 0);
    }

    @NotNull
    public final ExoMediaPlayerImpl getCorePlayer() {
        Lazy lazy = this.corePlayer$delegate;
        return (ExoMediaPlayerImpl)lazy.getValue();
    }

    @Nullable
    public final ListenerMux getMux() {
        return this.mux;
    }

    public final void setMux(@Nullable ListenerMux listenerMux) {
        this.mux = listenerMux;
    }

    protected final boolean getPlayRequested() {
        return this.playRequested;
    }

    protected final void setPlayRequested(boolean bl) {
        this.playRequested = bl;
    }

    @NotNull
    protected final InternalListeners getInternalListeners() {
        return this.internalListeners;
    }

    protected final void setInternalListeners(@NotNull InternalListeners internalListeners) {
        Intrinsics.checkNotNullParameter((Object)internalListeners, (String)"<set-?>");
        this.internalListeners = internalListeners;
    }

    @NotNull
    protected final SurfaceCallback getSurfaceCallback() {
        return this.surfaceCallback;
    }

    @Override
    public float getVolume() {
        return this.getCorePlayer().getVolume();
    }

    @Override
    public void setVolume(float value) {
        this.getCorePlayer().setVolume(value);
    }

    @Override
    @NotNull
    public PlayerConfig getPlayerConfig() {
        return this.config;
    }

    @Override
    public boolean isPlaying() {
        return this.getCorePlayer().getPlayWhenReady();
    }

    @Override
    public long getDuration() {
        ListenerMux listenerMux = this.mux;
        Intrinsics.checkNotNull((Object)listenerMux);
        return !listenerMux.isPrepared() ? 0L : this.getCorePlayer().getDuration();
    }

    @Override
    public long getCurrentPosition() {
        ListenerMux listenerMux = this.mux;
        Intrinsics.checkNotNull((Object)listenerMux);
        return !listenerMux.isPrepared() ? 0L : this.getCorePlayer().getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.getCorePlayer().getBufferedPercent();
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return this.getCorePlayer().getWindowInfo();
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        return this.getCorePlayer().getTimeline();
    }

    @Override
    public int getAudioSessionId() {
        return this.getCorePlayer().getAudioSessionId();
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return this.getCorePlayer().getAvailableTracks();
    }

    @Override
    public float getPlaybackSpeed() {
        return this.getCorePlayer().getPlaybackSpeed();
    }

    @Override
    public float getPlaybackPitch() {
        return this.getCorePlayer().getPlaybackPitch();
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return this.getCorePlayer().getDrmSessionManagerProvider();
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider value) {
        this.getCorePlayer().setDrmSessionManagerProvider(value);
    }

    @Override
    public void setMedia(@Nullable MediaItem mediaItem) {
        ListenerMux listenerMux = this.mux;
        if (listenerMux != null) {
            listenerMux.setNotifiedPrepared(false);
        }
        this.getCorePlayer().seekTo(0L);
        MediaItem mediaItem2 = mediaItem;
        if (mediaItem2 != null && (mediaItem2 = mediaItem2.getMediaSource()) != null) {
            MediaItem it = mediaItem2;
            boolean bl = false;
            this.getCorePlayer().setMediaSource((MediaSource)it);
            ListenerMux listenerMux2 = this.mux;
            if (listenerMux2 != null) {
                listenerMux2.setNotifiedCompleted(false);
            }
            this.getCorePlayer().prepare();
            return;
        }
        MediaItem mediaItem3 = mediaItem;
        if (mediaItem3 != null && (mediaItem3 = mediaItem3.getUri()) != null) {
            MediaItem it = mediaItem3;
            boolean bl = false;
            this.getCorePlayer().setMediaUri((Uri)it);
            ListenerMux listenerMux3 = this.mux;
            if (listenerMux3 != null) {
                listenerMux3.setNotifiedCompleted(false);
            }
            this.getCorePlayer().prepare();
            return;
        }
        this.getCorePlayer().setMediaSource(null);
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean restart() {
        block2: {
            if (!this.getCorePlayer().restart()) {
                return false;
            }
            ListenerMux listenerMux = this.mux;
            if (listenerMux != null) {
                listenerMux.setNotifiedPrepared(false);
            }
            ListenerMux listenerMux2 = this.mux;
            if (listenerMux2 == null) break block2;
            listenerMux2.setNotifiedCompleted(false);
        }
        return true;
    }

    @Override
    public void release() {
        this.getCorePlayer().release();
        this.playRequested = false;
        this.surface.removeCallback(this.surfaceCallback);
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.getCorePlayer().seekTo(milliseconds);
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.getCorePlayer().setWakeLevel(levelAndFlags);
    }

    @Override
    public void start() {
        this.getCorePlayer().setPlayWhenReady(true);
        ListenerMux listenerMux = this.mux;
        if (listenerMux != null) {
            listenerMux.setNotifiedCompleted(false);
        }
        this.playRequested = true;
    }

    @Override
    public void pause() {
        this.getCorePlayer().setPlayWhenReady(false);
        this.playRequested = false;
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    @Override
    public void stop(boolean clearSurface) {
        block1: {
            this.getCorePlayer().stop();
            this.playRequested = false;
            if (!clearSurface) break block1;
            ListenerMux listenerMux = this.mux;
            if (listenerMux != null) {
                listenerMux.clearSurfaceWhenReady(this.surface);
            }
        }
    }

    @Override
    public boolean trackSelectionAvailable() {
        return true;
    }

    @Override
    public void setTrackSelectionParameters(@NotNull TrackSelectionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.getCorePlayer().setTrackSelectionParameters(parameters);
    }

    @Override
    public void setCaptionListener(@Nullable CaptionListener listener2) {
        this.getCorePlayer().setCaptionListener(listener2);
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getCorePlayer().setSelectedTrack(type, groupIndex, trackIndex);
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.getCorePlayer().getSelectedTrackIndex(type, groupIndex);
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getCorePlayer().clearSelectedTracks(type);
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getCorePlayer().setRendererEnabled(type, enabled);
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.getCorePlayer().isRendererEnabled(type);
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        this.getCorePlayer().setPlaybackSpeed(speed);
        return true;
    }

    @Override
    public boolean setPlaybackPitch(float pitch) {
        this.getCorePlayer().setPlaybackPitch(pitch);
        return true;
    }

    @Override
    public void setAudioAttributes(@NotNull AudioAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.getCorePlayer().setAudioAttributes(attributes);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.getCorePlayer().setRepeatMode(repeatMode);
    }

    public final void onSurfaceReady(@Nullable Surface surface) {
        this.getCorePlayer().setSurface(surface);
        if (this.playRequested && surface != null) {
            this.getCorePlayer().setPlayWhenReady(true);
        }
    }

    public final void onSurfaceDestroyed() {
        this.getCorePlayer().clearSurface();
    }

    @Override
    public void setListenerMux(@NotNull ListenerMux listenerMux) {
        Intrinsics.checkNotNullParameter((Object)listenerMux, (String)"listenerMux");
        ListenerMux listenerMux2 = this.mux;
        if (listenerMux2 != null) {
            ListenerMux oldListenerMux = listenerMux2;
            boolean bl = false;
            this.getCorePlayer().removeListener(oldListenerMux);
            this.getCorePlayer().removeAnalyticsListener(oldListenerMux);
        }
        this.mux = listenerMux;
        this.getCorePlayer().addListener(listenerMux);
        this.getCorePlayer().addAnalyticsListener(listenerMux);
    }

    private static final ExoMediaPlayerImpl corePlayer_delegate$lambda$1(ExoVideoPlayer this$0) {
        ExoMediaPlayerImpl exoMediaPlayerImpl;
        ExoMediaPlayerImpl $this$corePlayer_delegate_u24lambda_u241_u24lambda_u240 = exoMediaPlayerImpl = new ExoMediaPlayerImpl(this$0.config);
        boolean bl = false;
        $this$corePlayer_delegate_u24lambda_u241_u24lambda_u240.setMetadataListener(this$0.internalListeners);
        $this$corePlayer_delegate_u24lambda_u241_u24lambda_u240.setBufferUpdateListener(this$0.internalListeners);
        $this$corePlayer_delegate_u24lambda_u241_u24lambda_u240.setVideoSizeListener(this$0.internalListeners);
        return exoMediaPlayerImpl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u00072\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$InternalListeners;", "Lcom/devbrackets/android/exomedia/core/listener/MetadataListener;", "Lcom/devbrackets/android/exomedia/listener/OnBufferUpdateListener;", "Lcom/devbrackets/android/exomedia/core/listener/VideoSizeListener;", "<init>", "(Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer;)V", "onMetadata", "", "metadata", "Landroidx/media3/common/Metadata;", "onBufferingUpdate", "percent", "", "onVideoSizeChanged", "videoSize", "Landroidx/media3/common/VideoSize;", "library_release"})
    protected final class InternalListeners
    implements MetadataListener,
    OnBufferUpdateListener,
    VideoSizeListener {
        @Override
        public void onMetadata(@NotNull androidx.media3.common.Metadata metadata) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                ListenerMux listenerMux = ExoVideoPlayer.this.getMux();
                if (listenerMux == null) break block0;
                listenerMux.onMetadata(metadata);
            }
        }

        @Override
        public void onBufferingUpdate(@IntRange(from=0L, to=100L) int percent) {
            block0: {
                ListenerMux listenerMux = ExoVideoPlayer.this.getMux();
                if (listenerMux == null) break block0;
                listenerMux.onBufferingUpdate(percent);
            }
        }

        @Override
        public void onVideoSizeChanged(@NotNull VideoSize videoSize) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)videoSize, (String)"videoSize");
                ListenerMux listenerMux = ExoVideoPlayer.this.getMux();
                if (listenerMux == null) break block0;
                listenerMux.onVideoSizeChanged(videoSize.width, videoSize.height, videoSize.unappliedRotationDegrees, videoSize.pixelWidthHeightRatio);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer$SurfaceCallback;", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope$Callback;", "<init>", "(Lcom/devbrackets/android/exomedia/core/video/ExoVideoPlayer;)V", "onSurfaceAvailable", "", "envelope", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;", "onSurfaceDestroyed", "onSurfaceSizeChanged", "width", "", "height", "library_release"})
    protected final class SurfaceCallback
    implements SurfaceEnvelope.Callback {
        @Override
        public void onSurfaceAvailable(@NotNull SurfaceEnvelope envelope) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
            ExoVideoPlayer.this.onSurfaceReady(envelope.getSurface());
        }

        @Override
        public void onSurfaceDestroyed(@NotNull SurfaceEnvelope envelope) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
            ExoVideoPlayer.this.onSurfaceDestroyed();
            envelope.release();
        }

        @Override
        public void onSurfaceSizeChanged(@NotNull SurfaceEnvelope envelope, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
        }
    }
}

