/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget.controls;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsSeekListener;
import com.devbrackets.android.exomedia.ui.widget.VideoView;
import com.devbrackets.android.exomedia.ui.widget.controls.DefaultVideoControls;
import java.util.LinkedList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002+,B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u00020\u001a2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020\u001aH\u0014J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\b\u0010(\u001a\u00020\u001aH\u0014J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010*\u001a\u00020\u001aH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006-"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsMobile;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "container", "Landroid/view/ViewGroup;", "extraViews", "", "Landroid/view/View;", "getExtraViews", "()Ljava/util/List;", "extraViewsContainer", "Landroid/widget/LinearLayout;", "layoutResource", "getLayoutResource", "()I", "addExtraView", "", "view", "animateVisibility", "toVisible", "", "hideDelayed", "delay", "", "onLoadEnded", "state", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$LoadState;", "onLoadStarted", "registerListeners", "removeExtraView", "retrieveViews", "setup", "show", "SeekBarChanged", "TouchListener", "library_release"})
public final class VideoControlsMobile
extends DefaultVideoControls {
    private LinearLayout extraViewsContainer;
    private ViewGroup container;

    @Override
    protected int getLayoutResource() {
        return R.layout.exomedia_controls_mobile;
    }

    @Override
    @NotNull
    public List<View> getExtraViews() {
        int childCount;
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
            linearLayout = null;
        }
        if ((childCount = linearLayout.getChildCount()) <= 0) {
            return super.getExtraViews();
        }
        LinkedList<View> children = new LinkedList<View>();
        for (int i = 0; i < childCount; ++i) {
            LinearLayout linearLayout2 = this.extraViewsContainer;
            if (linearLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
                linearLayout2 = null;
            }
            children.add(linearLayout2.getChildAt(i));
        }
        return children;
    }

    public VideoControlsMobile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public VideoControlsMobile(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
    }

    public VideoControlsMobile(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
    }

    public VideoControlsMobile(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void setup(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.setup(context);
        this.setOnTouchListener(new TouchListener(context));
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.getSeekBar().setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)new SeekBarChanged());
    }

    @Override
    protected void retrieveViews() {
        super.retrieveViews();
        View view = this.findViewById(R.id.exomedia_controls_extra_container);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.extraViewsContainer = (LinearLayout)view;
        View view2 = this.findViewById(R.id.exomedia_controls_container);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.container = (ViewGroup)view2;
    }

    @Override
    public void addExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
            linearLayout = null;
        }
        linearLayout.addView(view);
    }

    @Override
    public void removeExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
            linearLayout = null;
        }
        linearLayout.removeView(view);
    }

    @Override
    public void show() {
        super.show();
        VideoView videoView = this.getVideoView();
        boolean bl = videoView != null ? videoView.isPlaying() : false;
        if (bl) {
            this.hide(true);
        }
    }

    @Override
    public void hideDelayed(long delay) {
        if (delay < 0L || this.getCurrentLoadState() != null) {
            return;
        }
        if (!this.getUserInteracting()) {
            this.getVisibilityHandler().postDelayed(() -> VideoControlsMobile.hideDelayed$lambda$0(this), delay);
        }
    }

    @Override
    protected void animateVisibility(boolean toVisible) {
        if (this.isVisible() == toVisible) {
            return;
        }
        float endAlpha = toVisible ? 1.0f : 0.0f;
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
            viewGroup = null;
        }
        viewGroup.animate().alpha(endAlpha).start();
        this.setVisible(toVisible);
        this.onVisibilityChanged();
    }

    @Override
    public void onLoadStarted(@NotNull DefaultVideoControls.LoadState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.getLoadingProgressBar().setVisibility(0);
        this.getPlayPauseButton().setVisibility(4);
        if (state == DefaultVideoControls.LoadState.PREPARING) {
            this.getSeekBar().setVisibility(4);
            this.getCurrentTimeTextView().setVisibility(4);
            this.getTimeSeparatorView().setVisibility(4);
            this.getEndTimeTextView().setVisibility(4);
            this.getPreviousButton().setVisibility(4);
            this.getNextButton().setVisibility(4);
            LinearLayout linearLayout = this.extraViewsContainer;
            if (linearLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
                linearLayout = null;
            }
            linearLayout.setVisibility(4);
        }
        this.show();
    }

    @Override
    public void onLoadEnded(@Nullable DefaultVideoControls.LoadState state) {
        this.setCurrentLoadState(null);
        this.getLoadingProgressBar().setVisibility(8);
        this.getSeekBar().setVisibility(0);
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
            viewGroup = null;
        }
        viewGroup.setVisibility(0);
        this.getCurrentTimeTextView().setVisibility(0);
        this.getTimeSeparatorView().setVisibility(0);
        this.getEndTimeTextView().setVisibility(0);
        this.getPlayPauseButton().setVisibility(0);
        this.getPlayPauseButton().setEnabled(true);
        this.getPreviousButton().setVisibility(0);
        this.getPreviousButton().setEnabled(this.getEnabledViews().get(R.id.exomedia_controls_previous_btn, true));
        this.getNextButton().setVisibility(0);
        this.getNextButton().setEnabled(this.getEnabledViews().get(R.id.exomedia_controls_next_btn, true));
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
            linearLayout = null;
        }
        linearLayout.setVisibility(0);
        VideoView videoView = this.getVideoView();
        this.updatePlaybackState(videoView != null ? videoView.isPlaying() : false);
    }

    private static final void hideDelayed$lambda$0(VideoControlsMobile this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.animateVisibility(false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsMobile$SeekBarChanged;", "Landroid/widget/SeekBar$OnSeekBarChangeListener;", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsMobile;)V", "seekToTime", "", "onProgressChanged", "", "seekBar", "Landroid/widget/SeekBar;", "progress", "", "fromUser", "", "onStartTrackingTouch", "onStopTrackingTouch", "library_release"})
    private final class SeekBarChanged
    implements SeekBar.OnSeekBarChangeListener {
        private long seekToTime;

        public void onProgressChanged(@NotNull SeekBar seekBar, int progress, boolean fromUser) {
            Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
            if (!fromUser) {
                return;
            }
            this.seekToTime = progress;
            VideoControlsMobile.this.updatePositionText(this.seekToTime);
        }

        public void onStartTrackingTouch(@NotNull SeekBar seekBar) {
            Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
            VideoControlsMobile.this.setUserInteracting(true);
            VideoControlsSeekListener videoControlsSeekListener = VideoControlsMobile.this.getSeekListener();
            if (!(videoControlsSeekListener != null ? videoControlsSeekListener.onSeekStarted() : false)) {
                VideoControlsMobile.this.getInternalListener().onSeekStarted();
            }
        }

        public void onStopTrackingTouch(@NotNull SeekBar seekBar) {
            Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
            VideoControlsMobile.this.setUserInteracting(false);
            VideoControlsSeekListener videoControlsSeekListener = VideoControlsMobile.this.getSeekListener();
            if (!(videoControlsSeekListener != null ? videoControlsSeekListener.onSeekEnded(this.seekToTime) : false)) {
                VideoControlsMobile.this.getInternalListener().onSeekEnded(this.seekToTime);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsMobile$TouchListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "Landroid/view/View$OnTouchListener;", "context", "Landroid/content/Context;", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsMobile;Landroid/content/Context;)V", "gestureDetector", "Landroid/view/GestureDetector;", "getGestureDetector", "()Landroid/view/GestureDetector;", "gestureDetector$delegate", "Lkotlin/Lazy;", "onSingleTapConfirmed", "", "event", "Landroid/view/MotionEvent;", "onTouch", "view", "Landroid/view/View;", "library_release"})
    private final class TouchListener
    extends GestureDetector.SimpleOnGestureListener
    implements View.OnTouchListener {
        @NotNull
        private final Lazy gestureDetector$delegate;

        public TouchListener(Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.gestureDetector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GestureDetector>(context, this){
                final /* synthetic */ Context $context;
                final /* synthetic */ TouchListener this$0;
                {
                    this.$context = $context;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final GestureDetector invoke() {
                    return new GestureDetector(this.$context, (GestureDetector.OnGestureListener)this.this$0);
                }
            }));
        }

        private final GestureDetector getGestureDetector() {
            Lazy lazy = this.gestureDetector$delegate;
            return (GestureDetector)lazy.getValue();
        }

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouch(@NotNull View view, @NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.getGestureDetector().onTouchEvent(event);
            return true;
        }

        public boolean onSingleTapConfirmed(@NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (VideoControlsMobile.this.isVisible()) {
                VideoControlsMobile.this.hide(false);
            } else {
                VideoControlsMobile.this.show();
            }
            return true;
        }
    }
}

