/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.TrackGroupArray;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.audio.AudioPlayerApi;
import com.devbrackets.android.exomedia.core.audio.ExoAudioPlayer;
import com.devbrackets.android.exomedia.core.audio.MediaItem;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.state.PlaybackState;
import com.devbrackets.android.exomedia.core.state.PlaybackStateListener;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.listener.OnSeekCompletionListener;
import com.devbrackets.android.exomedia.listener.OnTimelineChangedListener;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayer;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfigBuilder;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \u008b\u00012\u00020\u0001:\u0004\u008b\u0001\u008c\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\u0011\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0012H\u0096\u0001J\u0006\u0010P\u001a\u00020QJ\u0019\u0010R\u001a\u00020\r2\u0006\u0010O\u001a\u00020\u00122\u0006\u0010S\u001a\u00020\rH\u0096\u0001J\u0011\u0010T\u001a\u00020'2\u0006\u0010O\u001a\u00020\u0012H\u0096\u0001J\b\u0010U\u001a\u00020NH\u0002J\u000e\u0010V\u001a\u00020N2\u0006\u0010$\u001a\u00020\u001bJ\t\u0010W\u001a\u00020NH\u0096\u0001J\t\u0010X\u001a\u00020NH\u0096\u0001J\b\u0010Y\u001a\u00020NH\u0016J\t\u0010Z\u001a\u00020'H\u0096\u0001J\u0013\u0010[\u001a\u00020N2\b\b\u0001\u0010\\\u001a\u00020\u001bH\u0096\u0001J\u0010\u0010]\u001a\u00020N2\b\u0010^\u001a\u0004\u0018\u00010_J\u0011\u0010`\u001a\u00020N2\u0006\u0010a\u001a\u00020bH\u0096\u0001J\u0011\u0010c\u001a\u00020N2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u0010\u0010d\u001a\u00020N2\b\u0010e\u001a\u0004\u0018\u00010fJ\u0010\u0010d\u001a\u00020N2\b\u0010g\u001a\u0004\u0018\u00010hJ\u0012\u0010d\u001a\u00020N2\b\u0010/\u001a\u0004\u0018\u00010.H\u0016J\u0010\u0010i\u001a\u00020N2\b\u0010^\u001a\u0004\u0018\u00010jJ\u0010\u0010k\u001a\u00020N2\b\u0010^\u001a\u0004\u0018\u00010lJ\u0010\u0010m\u001a\u00020N2\b\u0010^\u001a\u0004\u0018\u00010nJ\u0010\u0010o\u001a\u00020N2\b\u0010^\u001a\u0004\u0018\u00010pJ\u0010\u0010q\u001a\u00020N2\b\u0010^\u001a\u0004\u0018\u00010rJ\u0010\u0010s\u001a\u00020N2\b\u0010^\u001a\u0004\u0018\u00010tJ\u0010\u0010u\u001a\u00020N2\b\u0010^\u001a\u0004\u0018\u00010vJ\u0011\u0010w\u001a\u00020'2\u0006\u0010x\u001a\u000209H\u0096\u0001J\u0011\u0010y\u001a\u00020'2\u0006\u0010z\u001a\u000209H\u0096\u0001J\u0010\u0010{\u001a\u00020N2\b\u0010^\u001a\u0004\u0018\u00010|J\u0019\u0010}\u001a\u00020N2\u0006\u0010O\u001a\u00020\u00122\u0006\u0010~\u001a\u00020'H\u0096\u0001J\u0012\u0010\u007f\u001a\u00020N2\u0007\u0010\u0080\u0001\u001a\u00020\rH\u0096\u0001J#\u0010\u0081\u0001\u001a\u00020N2\u0006\u0010O\u001a\u00020\u00122\u0006\u0010S\u001a\u00020\r2\u0007\u0010\u0082\u0001\u001a\u00020\rH\u0096\u0001J\u0014\u0010\u0083\u0001\u001a\u00020N2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0096\u0001J\u0013\u0010\u0086\u0001\u001a\u00020N2\u0007\u0010\u0087\u0001\u001a\u00020\rH\u0096\u0001J\n\u0010\u0088\u0001\u001a\u00020NH\u0096\u0001J\n\u0010\u0089\u0001\u001a\u00020NH\u0096\u0001J\n\u0010\u008a\u0001\u001a\u00020'H\u0096\u0001R\u0014\u0010\b\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\r8WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u001b8WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0012\u0010&\u001a\u00020'X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010(R\u0014\u0010)\u001a\u00020*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R(\u0010/\u001a\u0004\u0018\u00010.2\b\u0010-\u001a\u0004\u0018\u00010.@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001d\"\u0004\b6\u00107R\u0012\u00108\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0012\u0010<\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b=\u0010;R\u0012\u0010>\u001a\u00020\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0012\u0010A\u001a\u00020BX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u001a\u0010E\u001a\u0002098WX\u0096\u000f\u00a2\u0006\f\u001a\u0004\bF\u0010;\"\u0004\bG\u0010HR\u0014\u0010I\u001a\u0004\u0018\u00010JX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006\u008d\u0001"}, d2={"Lcom/devbrackets/android/exomedia/AudioPlayer;", "Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "audioPlayerImpl", "(Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;)V", "getAudioPlayerImpl", "()Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "audioSessionId", "", "getAudioSessionId", "()I", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Landroidx/media3/exoplayer/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "bufferPercentage", "getBufferPercentage", "bufferedPercent", "getBufferedPercent", "currentPosition", "", "getCurrentPosition", "()J", "drmSessionManagerProvider", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "getDrmSessionManagerProvider", "()Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;)V", "duration", "getDuration", "isPlaying", "", "()Z", "listenerMux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "getListenerMux", "()Lcom/devbrackets/android/exomedia/core/ListenerMux;", "<set-?>", "Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "mediaItem", "getMediaItem", "()Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "setMediaItem", "(Lcom/devbrackets/android/exomedia/core/audio/MediaItem;)V", "overriddenDuration", "getOverriddenDuration", "setOverriddenDuration", "(J)V", "playbackPitch", "", "getPlaybackPitch", "()F", "playbackSpeed", "getPlaybackSpeed", "playerConfig", "getPlayerConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "timeline", "Landroidx/media3/common/Timeline;", "getTimeline", "()Landroidx/media3/common/Timeline;", "volume", "getVolume", "setVolume", "(F)V", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "clearSelectedTracks", "", "type", "getPlaybackState", "Lcom/devbrackets/android/exomedia/core/state/PlaybackState;", "getSelectedTrackIndex", "groupIndex", "isRendererEnabled", "onPlaybackEnded", "overrideDuration", "pause", "release", "reset", "restart", "seekTo", "milliseconds", "setAnalyticsListener", "listener", "Landroidx/media3/exoplayer/analytics/AnalyticsListener;", "setAudioAttributes", "attributes", "Landroidx/media3/common/AudioAttributes;", "setListenerMux", "setMedia", "uri", "Landroid/net/Uri;", "mediaSource", "Landroidx/media3/exoplayer/source/MediaSource;", "setMetadataListener", "Lcom/devbrackets/android/exomedia/core/listener/MetadataListener;", "setOnBufferUpdateListener", "Lcom/devbrackets/android/exomedia/listener/OnBufferUpdateListener;", "setOnCompletionListener", "Lcom/devbrackets/android/exomedia/listener/OnCompletionListener;", "setOnErrorListener", "Lcom/devbrackets/android/exomedia/listener/OnErrorListener;", "setOnPreparedListener", "Lcom/devbrackets/android/exomedia/listener/OnPreparedListener;", "setOnSeekCompletionListener", "Lcom/devbrackets/android/exomedia/listener/OnSeekCompletionListener;", "setOnTimelineChangedListener", "Lcom/devbrackets/android/exomedia/listener/OnTimelineChangedListener;", "setPlaybackPitch", "pitch", "setPlaybackSpeed", "speed", "setPlaybackStateListener", "Lcom/devbrackets/android/exomedia/core/state/PlaybackStateListener;", "setRendererEnabled", "enabled", "setRepeatMode", "repeatMode", "setSelectedTrack", "trackIndex", "setTrackSelectionParameters", "parameters", "Landroidx/media3/common/TrackSelectionParameters;", "setWakeLevel", "levelAndFlags", "start", "stop", "trackSelectionAvailable", "Companion", "MuxNotifier", "library_release"})
public class AudioPlayer
implements AudioPlayerApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioPlayerApi audioPlayerImpl;
    @NotNull
    private final ListenerMux listenerMux;
    private long overriddenDuration;
    @Nullable
    private MediaItem mediaItem;

    public AudioPlayer(@NotNull AudioPlayerApi audioPlayerImpl) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerImpl, (String)"audioPlayerImpl");
        this.audioPlayerImpl = audioPlayerImpl;
        this.listenerMux = new ListenerMux(new MuxNotifier(), null, 2, null);
        this.overriddenDuration = -1L;
        this.audioPlayerImpl.setListenerMux(this.listenerMux);
    }

    @NotNull
    protected final AudioPlayerApi getAudioPlayerImpl() {
        return this.audioPlayerImpl;
    }

    @Override
    public int getAudioSessionId() {
        return this.audioPlayerImpl.getAudioSessionId();
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return this.audioPlayerImpl.getAvailableTracks();
    }

    @Override
    @IntRange(from=0L, to=100L)
    public int getBufferedPercent() {
        return this.audioPlayerImpl.getBufferedPercent();
    }

    @Override
    @IntRange(from=0L)
    public long getCurrentPosition() {
        return this.audioPlayerImpl.getCurrentPosition();
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return this.audioPlayerImpl.getDrmSessionManagerProvider();
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
        this.audioPlayerImpl.setDrmSessionManagerProvider(drmSessionManagerProvider);
    }

    @Override
    public boolean isPlaying() {
        return this.audioPlayerImpl.isPlaying();
    }

    @Override
    public float getPlaybackPitch() {
        return this.audioPlayerImpl.getPlaybackPitch();
    }

    @Override
    public float getPlaybackSpeed() {
        return this.audioPlayerImpl.getPlaybackSpeed();
    }

    @Override
    @NotNull
    public PlayerConfig getPlayerConfig() {
        return this.audioPlayerImpl.getPlayerConfig();
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        return this.audioPlayerImpl.getTimeline();
    }

    @Override
    @FloatRange(from=0.0, to=1.0)
    public float getVolume() {
        return this.audioPlayerImpl.getVolume();
    }

    @Override
    public void setVolume(float f) {
        this.audioPlayerImpl.setVolume(f);
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return this.audioPlayerImpl.getWindowInfo();
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.audioPlayerImpl.clearSelectedTracks(type);
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.audioPlayerImpl.getSelectedTrackIndex(type, groupIndex);
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.audioPlayerImpl.isRendererEnabled(type);
    }

    @Override
    public void pause() {
        this.audioPlayerImpl.pause();
    }

    @Override
    public void release() {
        this.audioPlayerImpl.release();
    }

    @Override
    public boolean restart() {
        return this.audioPlayerImpl.restart();
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.audioPlayerImpl.seekTo(milliseconds);
    }

    @Override
    public void setAudioAttributes(@NotNull AudioAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.audioPlayerImpl.setAudioAttributes(attributes);
    }

    @Override
    public void setListenerMux(@NotNull ListenerMux listenerMux2) {
        Intrinsics.checkNotNullParameter((Object)listenerMux2, (String)"listenerMux");
        this.audioPlayerImpl.setListenerMux(listenerMux2);
    }

    @Override
    public boolean setPlaybackPitch(float pitch) {
        return this.audioPlayerImpl.setPlaybackPitch(pitch);
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        return this.audioPlayerImpl.setPlaybackSpeed(speed);
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.audioPlayerImpl.setRendererEnabled(type, enabled);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.audioPlayerImpl.setRepeatMode(repeatMode);
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.audioPlayerImpl.setSelectedTrack(type, groupIndex, trackIndex);
    }

    @Override
    public void setTrackSelectionParameters(@NotNull TrackSelectionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.audioPlayerImpl.setTrackSelectionParameters(parameters);
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.audioPlayerImpl.setWakeLevel(levelAndFlags);
    }

    @Override
    public void start() {
        this.audioPlayerImpl.start();
    }

    @Override
    public void stop() {
        this.audioPlayerImpl.stop();
    }

    @Override
    public boolean trackSelectionAvailable() {
        return this.audioPlayerImpl.trackSelectionAvailable();
    }

    @NotNull
    protected final ListenerMux getListenerMux() {
        return this.listenerMux;
    }

    protected final long getOverriddenDuration() {
        return this.overriddenDuration;
    }

    protected final void setOverriddenDuration(long l) {
        this.overriddenDuration = l;
    }

    public AudioPlayer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(new PlayerConfigBuilder(context).build());
    }

    public AudioPlayer(@NotNull PlayerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(Companion.getPlayerImplementation(config));
    }

    @Override
    public long getDuration() {
        return this.overriddenDuration >= 0L ? this.overriddenDuration : this.audioPlayerImpl.getDuration();
    }

    public final int getBufferPercentage() {
        return this.audioPlayerImpl.getBufferedPercent();
    }

    @Nullable
    public final MediaItem getMediaItem() {
        return this.mediaItem;
    }

    protected final void setMediaItem(@Nullable MediaItem mediaItem) {
        this.mediaItem = mediaItem;
    }

    public final void setMedia(@Nullable Uri uri) {
        MediaItem mediaItem;
        Uri uri2 = uri;
        if (uri2 != null) {
            Uri it = uri2;
            boolean bl = false;
            mediaItem = new MediaItem(it, null);
        } else {
            mediaItem = null;
        }
        MediaItem mediaItem2 = mediaItem;
        this.setMedia(mediaItem2);
    }

    public final void setMedia(@Nullable MediaSource mediaSource) {
        MediaItem mediaItem;
        MediaSource mediaSource2 = mediaSource;
        if (mediaSource2 != null) {
            MediaSource it = mediaSource2;
            boolean bl = false;
            mediaItem = new MediaItem(null, it);
        } else {
            mediaItem = null;
        }
        MediaItem mediaItem2 = mediaItem;
        this.setMedia(mediaItem2);
    }

    @Override
    public void setMedia(@Nullable MediaItem mediaItem) {
        this.audioPlayerImpl.setMedia(mediaItem);
        this.mediaItem = mediaItem;
        this.overrideDuration(-1L);
    }

    @Override
    public void reset() {
        this.stop();
        this.setMedia((MediaItem)null);
        this.audioPlayerImpl.reset();
    }

    public final void overrideDuration(long duration) {
        this.overriddenDuration = duration;
    }

    public final void setOnPreparedListener(@Nullable OnPreparedListener listener2) {
        this.listenerMux.setOnPreparedListener(listener2);
    }

    public final void setOnCompletionListener(@Nullable OnCompletionListener listener2) {
        this.listenerMux.setOnCompletionListener(listener2);
    }

    public final void setOnBufferUpdateListener(@Nullable OnBufferUpdateListener listener2) {
        this.listenerMux.setOnBufferUpdateListener(listener2);
    }

    public final void setOnSeekCompletionListener(@Nullable OnSeekCompletionListener listener2) {
        this.listenerMux.setOnSeekCompletionListener(listener2);
    }

    public final void setOnTimelineChangedListener(@Nullable OnTimelineChangedListener listener2) {
        this.listenerMux.setOnTimelineChangedListener(listener2);
    }

    public final void setOnErrorListener(@Nullable OnErrorListener listener2) {
        this.listenerMux.setOnErrorListener(listener2);
    }

    public final void setMetadataListener(@Nullable MetadataListener listener2) {
        this.listenerMux.setMetadataListener(listener2);
    }

    public final void setAnalyticsListener(@Nullable AnalyticsListener listener2) {
        this.listenerMux.setAnalyticsListener(listener2);
    }

    public final void setPlaybackStateListener(@Nullable PlaybackStateListener listener2) {
        this.listenerMux.setPlaybackStateListener(listener2);
    }

    @NotNull
    public final PlaybackState getPlaybackState() {
        return this.listenerMux.getPlaybackState();
    }

    private final void onPlaybackEnded() {
        this.pause();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/devbrackets/android/exomedia/AudioPlayer$Companion;", "", "()V", "getPlayerImplementation", "Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AudioPlayerApi getPlayerImplementation(@NotNull PlayerConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return config.getFallbackManager().useFallback() ? config.getFallbackManager().getFallbackAudioPlayer(config) : (AudioPlayerApi)new ExoAudioPlayer(config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tH\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/devbrackets/android/exomedia/AudioPlayer$MuxNotifier;", "Lcom/devbrackets/android/exomedia/core/ListenerMux$Notifier;", "(Lcom/devbrackets/android/exomedia/AudioPlayer;)V", "onExoPlayerError", "", "exoMediaPlayer", "Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayer;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onMediaPlaybackEnded", "library_release"})
    private final class MuxNotifier
    extends ListenerMux.Notifier {
        @Override
        public void onExoPlayerError(@NotNull ExoMediaPlayer exoMediaPlayer, @Nullable Exception e) {
            Intrinsics.checkNotNullParameter((Object)exoMediaPlayer, (String)"exoMediaPlayer");
            AudioPlayer.this.stop();
            exoMediaPlayer.forcePrepare();
        }

        @Override
        public void onMediaPlaybackEnded() {
            AudioPlayer.this.onPlaybackEnded();
        }
    }
}

