/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget.controls;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import androidx.media3.common.Timeline;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.core.state.PlaybackState;
import com.devbrackets.android.exomedia.listener.OnTimelineChangedListener;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsButtonListener;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsSeekListener;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsVisibilityListener;
import com.devbrackets.android.exomedia.ui.widget.VideoView;
import com.devbrackets.android.exomedia.ui.widget.controls.VideoControls;
import com.devbrackets.android.exomedia.util.LongExtensionsKt;
import com.devbrackets.android.exomedia.util.Repeater;
import com.devbrackets.android.exomedia.util.ResourceExtensionsKt;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\r\n\u0002\b\u0011\b&\u0018\u0000 \u00dd\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\b\u00dd\u0001\u00de\u0001\u00df\u0001\u00e0\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB'\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u0099\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009b\u0001\u001a\u000202H\u0016J\u0013\u0010\u009c\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009d\u0001\u001a\u00020BH$J\b\u0010\u009e\u0001\u001a\u00030\u009a\u0001J\u0013\u0010\u009e\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009f\u0001\u001a\u00020BH\u0004J\b\u0010\u00a0\u0001\u001a\u00030\u009a\u0001J\u0013\u0010\u00a0\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00a1\u0001\u001a\u000206H\u0016J\u0014\u0010\u00a2\u0001\u001a\u00030\u009a\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0016J\n\u0010\u00a3\u0001\u001a\u00030\u009a\u0001H\u0014J\u0014\u0010\u00a4\u0001\u001a\u00030\u009a\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0016J\n\u0010\u00a5\u0001\u001a\u00030\u009a\u0001H\u0014J\u0015\u0010\u00a6\u0001\u001a\u00030\u009a\u00012\t\u0010\u00a7\u0001\u001a\u0004\u0018\u00010\u0016H\u0016J\u0013\u0010\u00a8\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00a7\u0001\u001a\u00020\u0016H\u0016J\n\u0010\u00a9\u0001\u001a\u00030\u009a\u0001H\u0004J\n\u0010\u00aa\u0001\u001a\u00030\u009a\u0001H\u0004J\n\u0010\u00ab\u0001\u001a\u00030\u009a\u0001H\u0004J\n\u0010\u00ac\u0001\u001a\u00030\u009a\u0001H\u0004J\u0014\u0010\u00ad\u0001\u001a\u00030\u009a\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00ae\u0001H\u0016J\n\u0010\u00af\u0001\u001a\u00030\u009a\u0001H\u0004J\u0014\u0010\u00b0\u0001\u001a\u00030\u009a\u00012\b\u0010\u00b1\u0001\u001a\u00030\u00b2\u0001H\u0016J\u0013\u0010\u00b3\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00b4\u0001\u001a\u00020\"H\u0004J\n\u0010\u00b5\u0001\u001a\u00030\u009a\u0001H\u0004J\n\u0010\u00b6\u0001\u001a\u00030\u009a\u0001H\u0014J\u0013\u0010\u00b7\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009b\u0001\u001a\u000202H\u0016J\n\u0010\u00b8\u0001\u001a\u00030\u009a\u0001H\u0014J\u0014\u0010\u00b9\u0001\u001a\u00030\u009a\u00012\b\u0010\u00ba\u0001\u001a\u00030\u00ae\u0001H\u0014J\n\u0010\u00bb\u0001\u001a\u00030\u009a\u0001H\u0014J\u0013\u0010\u00bc\u0001\u001a\u00030\u009a\u00012\t\u0010\u00bd\u0001\u001a\u0004\u0018\u00010\u0010J\u0011\u0010\u00be\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00bf\u0001\u001a\u000206J\u0015\u0010\u00c0\u0001\u001a\u00030\u009a\u00012\t\b\u0001\u0010\u00c1\u0001\u001a\u000206H\u0016J\u0013\u0010\u00c2\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c3\u0001\u001a\u00020BH\u0016J\u0013\u0010\u00c4\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c5\u0001\u001a\u00020BH\u0016J\u0011\u0010\u00c6\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c3\u0001\u001a\u00020BJ\u0011\u0010\u00c7\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c5\u0001\u001a\u00020BJ\u0015\u0010\u00c8\u0001\u001a\u00030\u009a\u00012\t\b\u0001\u0010\u00c9\u0001\u001a\u000206H\u0016J\u0011\u0010\u00ca\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c3\u0001\u001a\u00020BJ\u0011\u0010\u00cb\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c5\u0001\u001a\u00020BJ\u0013\u0010\u00cc\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c3\u0001\u001a\u00020BH\u0016J\u0013\u0010\u00cd\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c5\u0001\u001a\u00020BH\u0016J\u0014\u0010\u00ce\u0001\u001a\u00030\u009a\u00012\n\u0010\u00cf\u0001\u001a\u0005\u0018\u00010\u00d0\u0001J\u0014\u0010\u00d1\u0001\u001a\u00030\u009a\u00012\n\u0010\u00d2\u0001\u001a\u0005\u0018\u00010\u00d0\u0001J\u0012\u0010\u00d3\u0001\u001a\u00030\u009a\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\n\u0010\u00d4\u0001\u001a\u00030\u009a\u0001H\u0016J\n\u0010\u00d5\u0001\u001a\u00030\u009a\u0001H\u0014J\u0015\u0010\u00d5\u0001\u001a\u00030\u009a\u00012\t\b\u0001\u0010\u00d6\u0001\u001a\u00020\u000bH\u0014J\u0013\u0010\u00d7\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c1\u0001\u001a\u000206H\u0004J\u001c\u0010\u00d7\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c1\u0001\u001a\u0002062\u0007\u0010\u00b4\u0001\u001a\u00020\"H\u0004J\u0011\u0010\u00d8\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00d9\u0001\u001a\u00020BJ\u0013\u0010\u00da\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c9\u0001\u001a\u000206H\u0004J\u001c\u0010\u00da\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c9\u0001\u001a\u0002062\u0007\u0010\u00b4\u0001\u001a\u00020\"H\u0004J\n\u0010\u00db\u0001\u001a\u00030\u009a\u0001H\u0004J+\u0010\u00db\u0001\u001a\u00030\u009a\u00012\t\b\u0001\u0010\u00c9\u0001\u001a\u0002062\t\b\u0001\u0010\u00c1\u0001\u001a\u0002062\t\b\u0001\u0010\u00dc\u0001\u001a\u00020\u000bH\u0014R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u001cX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001e\"\u0004\b/\u0010 R\u001a\u00100\u001a\b\u0012\u0004\u0012\u000202018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001a\u00105\u001a\u000206X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001e\u0010;\u001a\u00060<R\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u00020BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010C\"\u0004\bD\u0010ER\u0012\u0010F\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010GR\u000e\u0010H\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010I\u001a\u00020\u000b8eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u001a\u0010L\u001a\u00020MX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u001a\u0010R\u001a\u00020SX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u001a\u0010X\u001a\u00020YX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R\u001a\u0010^\u001a\u00020YX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010[\"\u0004\b`\u0010]R\u001a\u0010a\u001a\u00020SX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010U\"\u0004\bc\u0010WR\u001a\u0010d\u001a\u00020SX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010U\"\u0004\bf\u0010WR\u001a\u0010g\u001a\u00020hX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR\u001a\u0010m\u001a\u00020nX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010p\"\u0004\bq\u0010rR\u001c\u0010s\u001a\u0004\u0018\u00010tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bu\u0010v\"\u0004\bw\u0010xR\u001a\u0010y\u001a\u00020\u001cX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bz\u0010\u001e\"\u0004\b{\u0010 R\u001b\u0010|\u001a\u000202X\u0084.\u00a2\u0006\u000f\n\u0000\u001a\u0004\b}\u0010~\"\u0005\b\u007f\u0010\u0080\u0001R\u001d\u0010\u0081\u0001\u001a\u00020\u001cX\u0084.\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0082\u0001\u0010\u001e\"\u0005\b\u0083\u0001\u0010 R\u001d\u0010\u0084\u0001\u001a\u00020BX\u0084\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0085\u0001\u0010C\"\u0005\b\u0086\u0001\u0010ER\"\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u0001X\u0084\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0089\u0001\u0010\u008a\u0001\"\u0006\b\u008b\u0001\u0010\u008c\u0001R \u0010\u008d\u0001\u001a\u00030\u008e\u0001X\u0084\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008f\u0001\u0010\u0090\u0001\"\u0006\b\u0091\u0001\u0010\u0092\u0001R\"\u0010\u0093\u0001\u001a\u0005\u0018\u00010\u0094\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0095\u0001\u0010\u0096\u0001\"\u0006\b\u0097\u0001\u0010\u0098\u0001\u00a8\u0006\u00e1\u0001"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;", "Landroid/widget/RelativeLayout;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControls;", "Lcom/devbrackets/android/exomedia/listener/OnTimelineChangedListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "buttonsListener", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;", "getButtonsListener", "()Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;", "setButtonsListener", "(Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;)V", "currentLoadState", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$LoadState;", "getCurrentLoadState", "()Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$LoadState;", "setCurrentLoadState", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$LoadState;)V", "currentTimeTextView", "Landroid/widget/TextView;", "getCurrentTimeTextView", "()Landroid/widget/TextView;", "setCurrentTimeTextView", "(Landroid/widget/TextView;)V", "currentTimelineStyle", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$TimelineStyle;", "getCurrentTimelineStyle", "()Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$TimelineStyle;", "setCurrentTimelineStyle", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$TimelineStyle;)V", "enabledViews", "Landroid/util/SparseBooleanArray;", "getEnabledViews", "()Landroid/util/SparseBooleanArray;", "setEnabledViews", "(Landroid/util/SparseBooleanArray;)V", "endTimeTextView", "getEndTimeTextView", "setEndTimeTextView", "extraViews", "", "Landroid/view/View;", "getExtraViews", "()Ljava/util/List;", "hideDelay", "", "getHideDelay", "()J", "setHideDelay", "(J)V", "internalListener", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;", "getInternalListener", "()Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;", "setInternalListener", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;)V", "isVisible", "", "()Z", "setVisible", "(Z)V", "knownDuration", "Ljava/lang/Long;", "lastUpdatedPosition", "layoutResource", "getLayoutResource", "()I", "loadingProgressBar", "Landroid/widget/ProgressBar;", "getLoadingProgressBar", "()Landroid/widget/ProgressBar;", "setLoadingProgressBar", "(Landroid/widget/ProgressBar;)V", "nextButton", "Landroid/widget/ImageButton;", "getNextButton", "()Landroid/widget/ImageButton;", "setNextButton", "(Landroid/widget/ImageButton;)V", "pauseDrawable", "Landroid/graphics/drawable/Drawable;", "getPauseDrawable", "()Landroid/graphics/drawable/Drawable;", "setPauseDrawable", "(Landroid/graphics/drawable/Drawable;)V", "playDrawable", "getPlayDrawable", "setPlayDrawable", "playPauseButton", "getPlayPauseButton", "setPlayPauseButton", "previousButton", "getPreviousButton", "setPreviousButton", "progressPollRepeater", "Lcom/devbrackets/android/exomedia/util/Repeater;", "getProgressPollRepeater", "()Lcom/devbrackets/android/exomedia/util/Repeater;", "setProgressPollRepeater", "(Lcom/devbrackets/android/exomedia/util/Repeater;)V", "seekBar", "Landroid/widget/SeekBar;", "getSeekBar", "()Landroid/widget/SeekBar;", "setSeekBar", "(Landroid/widget/SeekBar;)V", "seekListener", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;", "getSeekListener", "()Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;", "setSeekListener", "(Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;)V", "subTitleTextView", "getSubTitleTextView", "setSubTitleTextView", "timeSeparatorView", "getTimeSeparatorView", "()Landroid/view/View;", "setTimeSeparatorView", "(Landroid/view/View;)V", "titleTextView", "getTitleTextView", "setTitleTextView", "userInteracting", "getUserInteracting", "setUserInteracting", "videoView", "Lcom/devbrackets/android/exomedia/ui/widget/VideoView;", "getVideoView", "()Lcom/devbrackets/android/exomedia/ui/widget/VideoView;", "setVideoView", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView;)V", "visibilityHandler", "Landroid/os/Handler;", "getVisibilityHandler", "()Landroid/os/Handler;", "setVisibilityHandler", "(Landroid/os/Handler;)V", "visibilityListener", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsVisibilityListener;", "getVisibilityListener", "()Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsVisibilityListener;", "setVisibilityListener", "(Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsVisibilityListener;)V", "addExtraView", "", "view", "animateVisibility", "toVisible", "hide", "delayed", "hideDelayed", "delay", "onAttachedToView", "onAttachedToWindow", "onDetachedFromView", "onDetachedFromWindow", "onLoadEnded", "state", "onLoadStarted", "onNextClick", "onPauseClick", "onPlayClick", "onPlayPauseClick", "onPlaybackStateChange", "Lcom/devbrackets/android/exomedia/core/state/PlaybackState;", "onPreviousClick", "onTimelineChanged", "timeline", "Landroidx/media3/common/Timeline;", "onTimelineStyleUpdated", "style", "onVisibilityChanged", "registerListeners", "removeExtraView", "reportLoadEnded", "reportLoadStarted", "playbackState", "retrieveViews", "setButtonListener", "callback", "setDefaultHideDelay", "delayMs", "setDuration", "duration", "setFastForwardButtonEnabled", "enabled", "setFastForwardButtonRemoved", "removed", "setNextButtonEnabled", "setNextButtonRemoved", "setPosition", "position", "setPreviousButtonEnabled", "setPreviousButtonRemoved", "setRewindButtonEnabled", "setRewindButtonRemoved", "setSubTitle", "subTitle", "", "setTitle", "title", "setup", "show", "updateButtonDrawables", "tintList", "updateDurationText", "updatePlaybackState", "isPlaying", "updatePositionText", "updateProgress", "bufferPercent", "Companion", "InternalListener", "LoadState", "TimelineStyle", "library_release"})
public abstract class DefaultVideoControls
extends RelativeLayout
implements VideoControls,
OnTimelineChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected TextView currentTimeTextView;
    protected TextView endTimeTextView;
    protected View timeSeparatorView;
    protected TextView titleTextView;
    protected TextView subTitleTextView;
    protected ImageButton playPauseButton;
    protected ImageButton previousButton;
    protected ImageButton nextButton;
    protected ProgressBar loadingProgressBar;
    protected SeekBar seekBar;
    protected Drawable playDrawable;
    protected Drawable pauseDrawable;
    @NotNull
    private Handler visibilityHandler;
    @NotNull
    private Repeater progressPollRepeater;
    @Nullable
    private VideoView videoView;
    @Nullable
    private VideoControlsSeekListener seekListener;
    @Nullable
    private VideoControlsButtonListener buttonsListener;
    @Nullable
    private VideoControlsVisibilityListener visibilityListener;
    @NotNull
    private InternalListener internalListener;
    @NotNull
    private SparseBooleanArray enabledViews;
    private long hideDelay;
    @Nullable
    private LoadState currentLoadState;
    @NotNull
    private TimelineStyle currentTimelineStyle;
    private boolean isVisible;
    private boolean userInteracting;
    private long lastUpdatedPosition;
    @Nullable
    private Long knownDuration;
    private static final long DEFAULT_CONTROL_HIDE_DELAY = 2500L;

    @NotNull
    protected final TextView getCurrentTimeTextView() {
        TextView textView = this.currentTimeTextView;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentTimeTextView");
        return null;
    }

    protected final void setCurrentTimeTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.currentTimeTextView = textView;
    }

    @NotNull
    protected final TextView getEndTimeTextView() {
        TextView textView = this.endTimeTextView;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"endTimeTextView");
        return null;
    }

    protected final void setEndTimeTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.endTimeTextView = textView;
    }

    @NotNull
    protected final View getTimeSeparatorView() {
        View view = this.timeSeparatorView;
        if (view != null) {
            return view;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"timeSeparatorView");
        return null;
    }

    protected final void setTimeSeparatorView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.timeSeparatorView = view;
    }

    @NotNull
    protected final TextView getTitleTextView() {
        TextView textView = this.titleTextView;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"titleTextView");
        return null;
    }

    protected final void setTitleTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.titleTextView = textView;
    }

    @NotNull
    protected final TextView getSubTitleTextView() {
        TextView textView = this.subTitleTextView;
        if (textView != null) {
            return textView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"subTitleTextView");
        return null;
    }

    protected final void setSubTitleTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.subTitleTextView = textView;
    }

    @NotNull
    protected final ImageButton getPlayPauseButton() {
        ImageButton imageButton = this.playPauseButton;
        if (imageButton != null) {
            return imageButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"playPauseButton");
        return null;
    }

    protected final void setPlayPauseButton(@NotNull ImageButton imageButton) {
        Intrinsics.checkNotNullParameter((Object)imageButton, (String)"<set-?>");
        this.playPauseButton = imageButton;
    }

    @NotNull
    protected final ImageButton getPreviousButton() {
        ImageButton imageButton = this.previousButton;
        if (imageButton != null) {
            return imageButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"previousButton");
        return null;
    }

    protected final void setPreviousButton(@NotNull ImageButton imageButton) {
        Intrinsics.checkNotNullParameter((Object)imageButton, (String)"<set-?>");
        this.previousButton = imageButton;
    }

    @NotNull
    protected final ImageButton getNextButton() {
        ImageButton imageButton = this.nextButton;
        if (imageButton != null) {
            return imageButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"nextButton");
        return null;
    }

    protected final void setNextButton(@NotNull ImageButton imageButton) {
        Intrinsics.checkNotNullParameter((Object)imageButton, (String)"<set-?>");
        this.nextButton = imageButton;
    }

    @NotNull
    protected final ProgressBar getLoadingProgressBar() {
        ProgressBar progressBar = this.loadingProgressBar;
        if (progressBar != null) {
            return progressBar;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"loadingProgressBar");
        return null;
    }

    protected final void setLoadingProgressBar(@NotNull ProgressBar progressBar) {
        Intrinsics.checkNotNullParameter((Object)progressBar, (String)"<set-?>");
        this.loadingProgressBar = progressBar;
    }

    @NotNull
    protected final SeekBar getSeekBar() {
        SeekBar seekBar = this.seekBar;
        if (seekBar != null) {
            return seekBar;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"seekBar");
        return null;
    }

    protected final void setSeekBar(@NotNull SeekBar seekBar) {
        Intrinsics.checkNotNullParameter((Object)seekBar, (String)"<set-?>");
        this.seekBar = seekBar;
    }

    @NotNull
    protected final Drawable getPlayDrawable() {
        Drawable drawable2 = this.playDrawable;
        if (drawable2 != null) {
            return drawable2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"playDrawable");
        return null;
    }

    protected final void setPlayDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"<set-?>");
        this.playDrawable = drawable2;
    }

    @NotNull
    protected final Drawable getPauseDrawable() {
        Drawable drawable2 = this.pauseDrawable;
        if (drawable2 != null) {
            return drawable2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pauseDrawable");
        return null;
    }

    protected final void setPauseDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"<set-?>");
        this.pauseDrawable = drawable2;
    }

    @NotNull
    protected final Handler getVisibilityHandler() {
        return this.visibilityHandler;
    }

    protected final void setVisibilityHandler(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"<set-?>");
        this.visibilityHandler = handler;
    }

    @NotNull
    protected final Repeater getProgressPollRepeater() {
        return this.progressPollRepeater;
    }

    protected final void setProgressPollRepeater(@NotNull Repeater repeater) {
        Intrinsics.checkNotNullParameter((Object)repeater, (String)"<set-?>");
        this.progressPollRepeater = repeater;
    }

    @Nullable
    protected final VideoView getVideoView() {
        return this.videoView;
    }

    protected final void setVideoView(@Nullable VideoView videoView) {
        this.videoView = videoView;
    }

    @Nullable
    public final VideoControlsSeekListener getSeekListener() {
        return this.seekListener;
    }

    public final void setSeekListener(@Nullable VideoControlsSeekListener videoControlsSeekListener) {
        this.seekListener = videoControlsSeekListener;
    }

    @Nullable
    public final VideoControlsButtonListener getButtonsListener() {
        return this.buttonsListener;
    }

    public final void setButtonsListener(@Nullable VideoControlsButtonListener videoControlsButtonListener) {
        this.buttonsListener = videoControlsButtonListener;
    }

    @Nullable
    public final VideoControlsVisibilityListener getVisibilityListener() {
        return this.visibilityListener;
    }

    public final void setVisibilityListener(@Nullable VideoControlsVisibilityListener videoControlsVisibilityListener) {
        this.visibilityListener = videoControlsVisibilityListener;
    }

    @NotNull
    protected final InternalListener getInternalListener() {
        return this.internalListener;
    }

    protected final void setInternalListener(@NotNull InternalListener internalListener) {
        Intrinsics.checkNotNullParameter((Object)internalListener, (String)"<set-?>");
        this.internalListener = internalListener;
    }

    @NotNull
    protected final SparseBooleanArray getEnabledViews() {
        return this.enabledViews;
    }

    protected final void setEnabledViews(@NotNull SparseBooleanArray sparseBooleanArray) {
        Intrinsics.checkNotNullParameter((Object)sparseBooleanArray, (String)"<set-?>");
        this.enabledViews = sparseBooleanArray;
    }

    protected final long getHideDelay() {
        return this.hideDelay;
    }

    protected final void setHideDelay(long l) {
        this.hideDelay = l;
    }

    @Nullable
    protected final LoadState getCurrentLoadState() {
        return this.currentLoadState;
    }

    protected final void setCurrentLoadState(@Nullable LoadState loadState) {
        this.currentLoadState = loadState;
    }

    @NotNull
    protected final TimelineStyle getCurrentTimelineStyle() {
        return this.currentTimelineStyle;
    }

    protected final void setCurrentTimelineStyle(@NotNull TimelineStyle timelineStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)timelineStyle), (String)"<set-?>");
        this.currentTimelineStyle = timelineStyle;
    }

    protected final boolean isVisible() {
        return this.isVisible;
    }

    protected final void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    protected final boolean getUserInteracting() {
        return this.userInteracting;
    }

    protected final void setUserInteracting(boolean bl) {
        this.userInteracting = bl;
    }

    @LayoutRes
    protected abstract int getLayoutResource();

    @NotNull
    public List<View> getExtraViews() {
        return new LinkedList();
    }

    protected abstract void animateVisibility(boolean var1);

    public DefaultVideoControls(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.visibilityHandler = new Handler(Looper.getMainLooper());
        this.progressPollRepeater = new Repeater(0L, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DefaultVideoControls this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.updateProgress();
            }
        }, 3, null);
        this.internalListener = new InternalListener();
        this.enabledViews = new SparseBooleanArray();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.currentTimelineStyle = TimelineStyle.UNKNOWN;
        this.isVisible = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.setup(context2);
    }

    public DefaultVideoControls(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.visibilityHandler = new Handler(Looper.getMainLooper());
        this.progressPollRepeater = new Repeater(0L, null, (Function0)new /* invalid duplicate definition of identical inner class */, 3, null);
        this.internalListener = new InternalListener();
        this.enabledViews = new SparseBooleanArray();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.currentTimelineStyle = TimelineStyle.UNKNOWN;
        this.isVisible = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.setup(context2);
    }

    public DefaultVideoControls(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.visibilityHandler = new Handler(Looper.getMainLooper());
        this.progressPollRepeater = new Repeater(0L, null, (Function0)new /* invalid duplicate definition of identical inner class */, 3, null);
        this.internalListener = new InternalListener();
        this.enabledViews = new SparseBooleanArray();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.currentTimelineStyle = TimelineStyle.UNKNOWN;
        this.isVisible = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.setup(context2);
    }

    public DefaultVideoControls(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.visibilityHandler = new Handler(Looper.getMainLooper());
        this.progressPollRepeater = new Repeater(0L, null, (Function0)new /* invalid duplicate definition of identical inner class */, 3, null);
        this.internalListener = new InternalListener();
        this.enabledViews = new SparseBooleanArray();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.currentTimelineStyle = TimelineStyle.UNKNOWN;
        this.isVisible = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.setup(context2);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        VideoView videoView = this.videoView;
        boolean bl = videoView != null ? videoView.isPlaying() : false;
        if (bl) {
            this.updatePlaybackState(true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.progressPollRepeater.stop();
    }

    @Override
    public void onAttachedToView(@NotNull VideoView videoView) {
        Intrinsics.checkNotNullParameter((Object)videoView, (String)"videoView");
        videoView.addView((View)this);
        videoView.setOnTimelineChangedListener(this);
        this.videoView = videoView;
    }

    @Override
    public void onDetachedFromView(@NotNull VideoView videoView) {
        Intrinsics.checkNotNullParameter((Object)videoView, (String)"videoView");
        videoView.removeView((View)this);
        videoView.setOnTimelineChangedListener(null);
        this.videoView = null;
    }

    public final void setButtonListener(@Nullable VideoControlsButtonListener callback) {
        this.buttonsListener = callback;
    }

    @Override
    public void onPlaybackStateChange(@NotNull PlaybackState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.reportLoadStarted(state);
                break;
            }
            case 3: {
                this.reportLoadStarted(state);
                break;
            }
            case 4: {
                this.reportLoadStarted(state);
                break;
            }
            case 5: {
                this.updatePlaybackState(false);
                break;
            }
            case 6: {
                this.updatePlaybackState(true);
                break;
            }
            case 7: {
                this.updatePlaybackState(false);
                break;
            }
            case 8: {
                this.updatePlaybackState(false);
                break;
            }
            case 9: {
                this.updatePlaybackState(false);
                break;
            }
            case 10: {
                this.updatePlaybackState(false);
                break;
            }
            case 11: {
                this.updatePlaybackState(false);
            }
        }
    }

    @Override
    public void onTimelineChanged(@NotNull Timeline timeline) {
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
        if (timeline.isEmpty()) {
            this.onTimelineStyleUpdated(TimelineStyle.UNKNOWN);
            return;
        }
        Timeline.Window window2 = new Timeline.Window();
        timeline.getWindow(timeline.getWindowCount() - 1, window2);
        if (window2.isPlaceholder) {
            this.onTimelineStyleUpdated(TimelineStyle.UNKNOWN);
            return;
        }
        if (!window2.isLive()) {
            this.onTimelineStyleUpdated(TimelineStyle.ON_DEMAND);
            return;
        }
        timeline.getWindow(0, window2);
        if (window2.isPlaceholder) {
            this.onTimelineStyleUpdated(TimelineStyle.UNKNOWN);
            return;
        }
        boolean rollingStart = window2.isDynamic || window2.isLive();
        TimelineStyle style = rollingStart ? TimelineStyle.LIVE : TimelineStyle.EVENT;
        this.onTimelineStyleUpdated(style);
    }

    protected final void onTimelineStyleUpdated(@NotNull TimelineStyle style) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        if (style == this.currentTimelineStyle) {
            return;
        }
        VideoView videoView = this.videoView;
        if (videoView != null) {
            VideoView it = videoView;
            boolean bl = false;
            this.updatePositionText(it.getCurrentPosition(), style);
            this.updateDurationText(it.getDuration(), style);
        }
        this.currentTimelineStyle = style;
    }

    public final void updatePlaybackState(boolean isPlaying) {
        this.getPlayPauseButton().setImageDrawable(isPlaying ? this.getPauseDrawable() : this.getPlayDrawable());
        this.progressPollRepeater.start();
        this.reportLoadEnded();
        if (isPlaying) {
            this.hideDelayed();
        } else {
            this.show();
        }
    }

    protected void reportLoadStarted(@NotNull PlaybackState playbackState) {
        block6: {
            int currentPriority;
            LoadState newState;
            LoadState loadState;
            Intrinsics.checkNotNullParameter((Object)((Object)playbackState), (String)"playbackState");
            switch (WhenMappings.$EnumSwitchMapping$0[playbackState.ordinal()]) {
                case 2: {
                    loadState = LoadState.PREPARING;
                    break;
                }
                case 3: {
                    loadState = LoadState.BUFFERING;
                    break;
                }
                case 4: {
                    loadState = LoadState.SEEKING;
                    break;
                }
                default: {
                    loadState = null;
                }
            }
            LoadState loadState2 = newState = loadState;
            int newPriority = loadState2 != null ? loadState2.ordinal() : 99;
            LoadState loadState3 = this.currentLoadState;
            int n = currentPriority = loadState3 != null ? loadState3.ordinal() : 100;
            if (newPriority >= currentPriority) {
                return;
            }
            LoadState loadState4 = newState;
            if (loadState4 == null) break block6;
            LoadState it = loadState4;
            boolean bl = false;
            this.currentLoadState = it;
            this.onLoadStarted(it);
        }
    }

    protected void reportLoadEnded() {
        LoadState loadState = this.currentLoadState;
        if (loadState != null) {
            LoadState it = loadState;
            boolean bl = false;
            this.onLoadEnded(it);
        }
        this.currentLoadState = null;
    }

    public void onLoadStarted(@NotNull LoadState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
    }

    public void onLoadEnded(@Nullable LoadState state) {
    }

    public void setPosition(@IntRange(from=0L) long position) {
        this.getSeekBar().setProgress((int)position);
        this.updatePositionText(position);
    }

    public void setDuration(@IntRange(from=0L) long duration) {
        if (duration != (long)this.getSeekBar().getMax()) {
            this.getSeekBar().setMax((int)duration);
            this.updateDurationText(duration);
        }
    }

    protected final void updatePositionText(long position) {
        this.updatePositionText(position, this.currentTimelineStyle);
    }

    protected final void updatePositionText(long position, @NotNull TimelineStyle style) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        if (style == this.currentTimelineStyle && Math.abs(position - this.lastUpdatedPosition) < 1000L && this.lastUpdatedPosition != 0L) {
            return;
        }
        this.lastUpdatedPosition = position;
        switch (WhenMappings.$EnumSwitchMapping$1[style.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.getCurrentTimeTextView().setText((CharSequence)LongExtensionsKt.millisToFormattedDuration(position));
                break;
            }
            case 4: {
                this.getCurrentTimeTextView().setText((CharSequence)LongExtensionsKt.millisToFormattedDuration(position));
            }
        }
    }

    protected final void updateDurationText(long duration) {
        this.updateDurationText(duration, this.currentTimelineStyle);
    }

    protected final void updateDurationText(long duration, @NotNull TimelineStyle style) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        if (style == this.currentTimelineStyle) {
            Long l = this.knownDuration;
            long l2 = duration;
            if (l != null && l == l2) {
                return;
            }
        }
        this.knownDuration = duration;
        switch (WhenMappings.$EnumSwitchMapping$1[style.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.getEndTimeTextView().setText((CharSequence)LongExtensionsKt.millisToFormattedDuration(duration));
                break;
            }
            case 4: {
                this.getEndTimeTextView().setText((CharSequence)this.getContext().getString(R.string.exomedia_controls_live));
            }
        }
    }

    public final void setTitle(@Nullable CharSequence title) {
        this.getTitleTextView().setText(title);
    }

    public final void setSubTitle(@Nullable CharSequence subTitle) {
        this.getSubTitleTextView().setText(subTitle);
    }

    public final void setPreviousButtonEnabled(boolean enabled) {
        this.getPreviousButton().setEnabled(enabled);
        this.enabledViews.put(R.id.exomedia_controls_previous_btn, enabled);
    }

    public final void setNextButtonEnabled(boolean enabled) {
        this.getNextButton().setEnabled(enabled);
        this.enabledViews.put(R.id.exomedia_controls_next_btn, enabled);
    }

    public void setRewindButtonEnabled(boolean enabled) {
    }

    public void setFastForwardButtonEnabled(boolean enabled) {
    }

    public final void setPreviousButtonRemoved(boolean removed) {
        this.getPreviousButton().setVisibility(removed ? 8 : 0);
    }

    public final void setNextButtonRemoved(boolean removed) {
        this.getNextButton().setVisibility(removed ? 8 : 0);
    }

    public void setRewindButtonRemoved(boolean removed) {
    }

    public void setFastForwardButtonRemoved(boolean removed) {
    }

    public void addExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    public void removeExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    public void show() {
        this.visibilityHandler.removeCallbacksAndMessages(null);
        this.clearAnimation();
        this.animateVisibility(true);
    }

    protected final void hide(boolean delayed) {
        if (delayed) {
            this.hideDelayed();
        } else {
            this.hide();
        }
    }

    public final void hide() {
        if (this.currentLoadState != null) {
            return;
        }
        this.visibilityHandler.removeCallbacksAndMessages(null);
        this.clearAnimation();
        this.animateVisibility(false);
    }

    public final void setDefaultHideDelay(long delayMs) {
        if (delayMs < 0L) {
            return;
        }
        this.hideDelay = delayMs;
    }

    public final void hideDelayed() {
        this.hideDelayed(this.hideDelay);
    }

    public void hideDelayed(long delay) {
        if (delay < 0L || this.currentLoadState != null) {
            return;
        }
        this.visibilityHandler.postDelayed(() -> DefaultVideoControls.hideDelayed$lambda$3(this), delay);
    }

    protected void registerListeners() {
        this.getPlayPauseButton().setOnClickListener(arg_0 -> DefaultVideoControls.registerListeners$lambda$4(this, arg_0));
        this.getPreviousButton().setOnClickListener(arg_0 -> DefaultVideoControls.registerListeners$lambda$5(this, arg_0));
        this.getNextButton().setOnClickListener(arg_0 -> DefaultVideoControls.registerListeners$lambda$6(this, arg_0));
    }

    protected void updateButtonDrawables() {
        this.updateButtonDrawables(R.color.exomedia_controls_button_foreground);
    }

    protected void updateButtonDrawables(@ColorRes int tintList) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.setPlayDrawable(ResourceExtensionsKt.tintListCompat(context, R.drawable.exomedia_ic_play_arrow_white, tintList));
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.setPauseDrawable(ResourceExtensionsKt.tintListCompat(context2, R.drawable.exomedia_ic_pause_white, tintList));
        this.getPlayPauseButton().setImageDrawable(this.getPlayDrawable());
        Context context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
        Drawable previousDrawable = ResourceExtensionsKt.tintListCompat(context3, R.drawable.exomedia_ic_skip_previous_white, tintList);
        this.getPreviousButton().setImageDrawable(previousDrawable);
        Context context4 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"context");
        Drawable nextDrawable = ResourceExtensionsKt.tintListCompat(context4, R.drawable.exomedia_ic_skip_next_white, tintList);
        this.getNextButton().setImageDrawable(nextDrawable);
    }

    protected final void onPlayPauseClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onPlayPauseClicked() : false)) {
            this.internalListener.onPlayPauseClicked();
        }
    }

    protected final void onPlayClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onPlayClicked() : false)) {
            this.internalListener.onPlayClicked();
        }
    }

    protected final void onPauseClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onPauseClicked() : false)) {
            this.internalListener.onPauseClicked();
        }
    }

    protected final void onPreviousClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onPreviousClicked() : false)) {
            this.internalListener.onPreviousClicked();
        }
    }

    protected final void onNextClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (!(videoControlsButtonListener != null ? videoControlsButtonListener.onNextClicked() : false)) {
            this.internalListener.onNextClicked();
        }
    }

    protected void setup(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        View.inflate((Context)context, (int)this.getLayoutResource(), (ViewGroup)((ViewGroup)this));
        this.retrieveViews();
        this.registerListeners();
        this.updateButtonDrawables();
    }

    protected void retrieveViews() {
        View view = this.findViewById(R.id.exomedia_controls_current_time);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.exomedia_controls_current_time)");
        this.setCurrentTimeTextView((TextView)view);
        View view2 = this.findViewById(R.id.exomedia_controls_end_time);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.exomedia_controls_end_time)");
        this.setEndTimeTextView((TextView)view2);
        View view3 = this.findViewById(R.id.exomedia_controls_time_separator);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.exomed\u2026_controls_time_separator)");
        this.setTimeSeparatorView(view3);
        View view4 = this.findViewById(R.id.exomedia_controls_title);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.exomedia_controls_title)");
        this.setTitleTextView((TextView)view4);
        View view5 = this.findViewById(R.id.exomedia_controls_sub_title);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(R.id.exomedia_controls_sub_title)");
        this.setSubTitleTextView((TextView)view5);
        View view6 = this.findViewById(R.id.exomedia_controls_play_pause_btn);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(R.id.exomed\u2026_controls_play_pause_btn)");
        this.setPlayPauseButton((ImageButton)view6);
        View view7 = this.findViewById(R.id.exomedia_controls_previous_btn);
        Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"findViewById(R.id.exomedia_controls_previous_btn)");
        this.setPreviousButton((ImageButton)view7);
        View view8 = this.findViewById(R.id.exomedia_controls_next_btn);
        Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"findViewById(R.id.exomedia_controls_next_btn)");
        this.setNextButton((ImageButton)view8);
        View view9 = this.findViewById(R.id.exomedia_controls_video_loading);
        Intrinsics.checkNotNullExpressionValue((Object)view9, (String)"findViewById(R.id.exomedia_controls_video_loading)");
        this.setLoadingProgressBar((ProgressBar)view9);
        View view10 = this.findViewById(R.id.exomedia_controls_video_seek);
        Intrinsics.checkNotNullExpressionValue((Object)view10, (String)"findViewById(R.id.exomedia_controls_video_seek)");
        this.setSeekBar((SeekBar)view10);
    }

    protected final void onVisibilityChanged() {
        block1: {
            block0: {
                if (!this.isVisible) break block0;
                VideoControlsVisibilityListener videoControlsVisibilityListener = this.visibilityListener;
                if (videoControlsVisibilityListener == null) break block1;
                videoControlsVisibilityListener.onControlsShown();
                break block1;
            }
            VideoControlsVisibilityListener videoControlsVisibilityListener = this.visibilityListener;
            if (videoControlsVisibilityListener == null) break block1;
            videoControlsVisibilityListener.onControlsHidden();
        }
    }

    protected final void updateProgress() {
        block2: {
            VideoView it;
            block4: {
                block3: {
                    VideoView videoView = this.videoView;
                    if (videoView == null) break block2;
                    it = videoView;
                    boolean bl = false;
                    if (this.knownDuration == null) break block3;
                    Long l = this.knownDuration;
                    if (l != null && it.getDuration() == l.longValue()) break block4;
                }
                this.setDuration(it.getDuration());
            }
            this.updateProgress(it.getCurrentPosition(), it.getDuration(), it.getBufferPercentage());
        }
    }

    protected void updateProgress(@IntRange(from=0L) long position, @IntRange(from=0L) long duration, @IntRange(from=0L, to=100L) int bufferPercent) {
        if (!this.userInteracting) {
            this.getSeekBar().setSecondaryProgress((int)((float)this.getSeekBar().getMax() * ((float)bufferPercent / (float)100)));
            this.getSeekBar().setProgress((int)position);
            this.updatePositionText(position);
        }
    }

    private static final void hideDelayed$lambda$3(DefaultVideoControls this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.hide();
    }

    private static final void registerListeners$lambda$4(DefaultVideoControls this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onPlayPauseClick();
    }

    private static final void registerListeners$lambda$5(DefaultVideoControls this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onPreviousClick();
    }

    private static final void registerListeners$lambda$6(DefaultVideoControls this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onNextClick();
    }

    public static final long getDEFAULT_CONTROL_HIDE_DELAY() {
        return Companion.getDEFAULT_CONTROL_HIDE_DELAY();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$Companion;", "", "()V", "DEFAULT_CONTROL_HIDE_DELAY", "", "getDEFAULT_CONTROL_HIDE_DELAY$annotations", "getDEFAULT_CONTROL_HIDE_DELAY", "()J", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDEFAULT_CONTROL_HIDE_DELAY() {
            return DEFAULT_CONTROL_HIDE_DELAY;
        }

        @JvmStatic
        public static /* synthetic */ void getDEFAULT_CONTROL_HIDE_DELAY$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0002\b\u0094\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;)V", "pausedForSeek", "", "onFastForwardClicked", "onNextClicked", "onPauseClicked", "onPlayClicked", "onPlayPauseClicked", "onPreviousClicked", "onRewindClicked", "onSeekEnded", "seekTime", "", "onSeekStarted", "library_release"})
    protected class InternalListener
    implements VideoControlsSeekListener,
    VideoControlsButtonListener {
        private boolean pausedForSeek;

        @Override
        public boolean onPlayPauseClicked() {
            boolean bl;
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            if (videoView != null) {
                VideoView it = videoView;
                boolean bl2 = false;
                if (it.isPlaying()) {
                    VideoView.pause$default(it, false, 1, null);
                } else {
                    it.start();
                }
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean onPlayClicked() {
            boolean bl;
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            if (videoView != null) {
                VideoView it = videoView;
                boolean bl2 = false;
                if (!it.isPlaying()) {
                    it.start();
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean onPauseClicked() {
            boolean bl;
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            if (videoView != null) {
                VideoView it = videoView;
                boolean bl2 = false;
                if (it.isPlaying()) {
                    VideoView.pause$default(it, false, 1, null);
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean onPreviousClicked() {
            return false;
        }

        @Override
        public boolean onNextClicked() {
            return false;
        }

        @Override
        public boolean onRewindClicked() {
            return false;
        }

        @Override
        public boolean onFastForwardClicked() {
            return false;
        }

        @Override
        public boolean onSeekStarted() {
            if (DefaultVideoControls.this.getVideoView() == null) {
                return false;
            }
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            boolean bl = videoView != null ? videoView.isPlaying() : false;
            if (bl) {
                this.pausedForSeek = true;
                VideoView videoView2 = DefaultVideoControls.this.getVideoView();
                if (videoView2 != null) {
                    videoView2.pause(true);
                }
            }
            DefaultVideoControls.this.show();
            return true;
        }

        @Override
        public boolean onSeekEnded(long seekTime) {
            if (DefaultVideoControls.this.getVideoView() == null) {
                return false;
            }
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            if (videoView != null) {
                videoView.seekTo(seekTime);
            }
            if (this.pausedForSeek) {
                this.pausedForSeek = false;
                VideoView videoView2 = DefaultVideoControls.this.getVideoView();
                if (videoView2 != null) {
                    videoView2.start();
                }
                DefaultVideoControls.this.hideDelayed();
            }
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$LoadState;", "", "(Ljava/lang/String;I)V", "PREPARING", "BUFFERING", "SEEKING", "library_release"})
    public static final class LoadState
    extends Enum<LoadState> {
        public static final /* enum */ LoadState PREPARING = new LoadState();
        public static final /* enum */ LoadState BUFFERING = new LoadState();
        public static final /* enum */ LoadState SEEKING = new LoadState();
        private static final /* synthetic */ LoadState[] $VALUES;

        public static LoadState[] values() {
            return (LoadState[])$VALUES.clone();
        }

        public static LoadState valueOf(String value) {
            return Enum.valueOf(LoadState.class, value);
        }

        static {
            $VALUES = loadStateArray = new LoadState[]{LoadState.PREPARING, LoadState.BUFFERING, LoadState.SEEKING};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0084\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$TimelineStyle;", "", "(Ljava/lang/String;I)V", "UNKNOWN", "LIVE", "EVENT", "ON_DEMAND", "library_release"})
    protected static final class TimelineStyle
    extends Enum<TimelineStyle> {
        public static final /* enum */ TimelineStyle UNKNOWN = new TimelineStyle();
        public static final /* enum */ TimelineStyle LIVE = new TimelineStyle();
        public static final /* enum */ TimelineStyle EVENT = new TimelineStyle();
        public static final /* enum */ TimelineStyle ON_DEMAND = new TimelineStyle();
        private static final /* synthetic */ TimelineStyle[] $VALUES;

        public static TimelineStyle[] values() {
            return (TimelineStyle[])$VALUES.clone();
        }

        public static TimelineStyle valueOf(String value) {
            return Enum.valueOf(TimelineStyle.class, value);
        }

        static {
            $VALUES = timelineStyleArray = new TimelineStyle[]{TimelineStyle.UNKNOWN, TimelineStyle.LIVE, TimelineStyle.EVENT, TimelineStyle.ON_DEMAND};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PlaybackState.values().length];
            try {
                nArray[PlaybackState.IDLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.PREPARING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.BUFFERING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.SEEKING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.READY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.PLAYING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.PAUSED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.COMPLETED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.STOPPED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.RELEASED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaybackState.ERROR.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TimelineStyle.values().length];
            try {
                nArray[TimelineStyle.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimelineStyle.ON_DEMAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimelineStyle.EVENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimelineStyle.LIVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

