/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.IntRange;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.ui.animation.BottomViewHideShowAnimation;
import com.devbrackets.android.exomedia.ui.widget.VideoControls;
import com.devbrackets.android.exomedia.util.ResourceUtil;
import com.devbrackets.android.exomedia.util.TimeFormatUtil;

@TargetApi(value=21)
public class VideoControlsLeanback
extends VideoControls {
    protected static final int FAST_FORWARD_REWIND_AMOUNT = 10000;
    protected ProgressBar progressBar;
    protected ImageView rippleIndicator;
    protected ViewGroup controlsParent;
    protected ImageButton fastForwardButton;
    protected ImageButton rewindButton;
    protected View currentFocus;
    protected ButtonFocusChangeListener buttonFocusChangeListener = new ButtonFocusChangeListener();

    public VideoControlsLeanback(Context context) {
        super(context);
    }

    public VideoControlsLeanback(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VideoControlsLeanback(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public VideoControlsLeanback(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void setup(Context context) {
        super.setup(context);
        this.internalListener = new LeanbackInternalListener();
        this.registerForInput();
        this.setFocusable(true);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.playPauseButton.requestFocus();
        this.currentFocus = this.playPauseButton;
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.exomedia_default_controls_leanback;
    }

    @Override
    public void setPosition(long position) {
        this.currentTimeTextView.setText((CharSequence)TimeFormatUtil.formatMs(position));
        this.progressBar.setProgress((int)position);
    }

    @Override
    public void setDuration(long duration) {
        if (duration != (long)this.progressBar.getMax()) {
            this.endTimeTextView.setText((CharSequence)TimeFormatUtil.formatMs(duration));
            this.progressBar.setMax((int)duration);
        }
    }

    @Override
    public void updateProgress(@IntRange(from=0L) long position, @IntRange(from=0L) long duration, @IntRange(from=0L, to=100L) int bufferPercent) {
        this.progressBar.setSecondaryProgress((int)((float)this.progressBar.getMax() * ((float)bufferPercent / 100.0f)));
        this.progressBar.setProgress((int)position);
        this.currentTimeTextView.setText((CharSequence)TimeFormatUtil.formatMs(position));
    }

    @Override
    public void setRewindDrawable(Drawable drawable2) {
        if (this.rewindButton != null) {
            this.rewindButton.setImageDrawable(drawable2);
        }
    }

    @Override
    public void setFastForwardDrawable(Drawable drawable2) {
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setImageDrawable(drawable2);
        }
    }

    @Override
    public void setRewindButtonEnabled(boolean enabled) {
        if (this.rewindButton != null) {
            this.rewindButton.setEnabled(enabled);
            this.enabledViews.put(R.id.exomedia_controls_rewind_btn, enabled);
        }
    }

    @Override
    public void setFastForwardButtonEnabled(boolean enabled) {
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setEnabled(enabled);
            this.enabledViews.put(R.id.exomedia_controls_fast_forward_btn, enabled);
        }
    }

    @Override
    public void setRewindButtonRemoved(boolean removed) {
        if (this.rewindButton != null) {
            this.rewindButton.setVisibility(removed ? 8 : 0);
        }
    }

    @Override
    public void setFastForwardButtonRemoved(boolean removed) {
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setVisibility(removed ? 8 : 0);
        }
    }

    @Override
    protected void retrieveViews() {
        super.retrieveViews();
        this.progressBar = (ProgressBar)this.findViewById(R.id.exomedia_controls_video_progress);
        this.rewindButton = (ImageButton)this.findViewById(R.id.exomedia_controls_rewind_btn);
        this.fastForwardButton = (ImageButton)this.findViewById(R.id.exomedia_controls_fast_forward_btn);
        this.rippleIndicator = (ImageView)this.findViewById(R.id.exomedia_controls_leanback_ripple);
        this.controlsParent = (ViewGroup)this.findViewById(R.id.exomedia_controls_parent);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.rewindButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoControlsLeanback.this.onRewindClick();
            }
        });
        this.fastForwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoControlsLeanback.this.onFastForwardClick();
            }
        });
        this.previousButton.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        this.rewindButton.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        this.playPauseButton.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        this.fastForwardButton.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        this.nextButton.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
    }

    @Override
    protected void updateButtonDrawables() {
        this.updateButtonDrawables(R.color.exomedia_default_controls_leanback_button_selector);
    }

    @Override
    protected void updateButtonDrawables(int tintList) {
        super.updateButtonDrawables(tintList);
        Drawable rewindDrawable = ResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_rewind_white, tintList);
        this.rewindButton.setImageDrawable(rewindDrawable);
        Drawable fastForwardDrawable = ResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_fast_forward_white, tintList);
        this.fastForwardButton.setImageDrawable(fastForwardDrawable);
    }

    @Override
    protected void animateVisibility(boolean toVisible) {
        if (this.isVisible == toVisible) {
            return;
        }
        if (!this.isLoading) {
            this.controlsParent.startAnimation((Animation)new BottomViewHideShowAnimation((View)this.controlsParent, toVisible, 300L));
        }
        this.isVisible = toVisible;
        this.onVisibilityChanged();
    }

    @Override
    protected void updateTextContainerVisibility() {
        if (!this.isVisible) {
            return;
        }
        boolean emptyText = this.isTextContainerEmpty();
        if (this.hideEmptyTextContainer && emptyText && this.textContainer.getVisibility() == 0) {
            this.textContainer.clearAnimation();
            this.textContainer.startAnimation((Animation)new BottomViewHideShowAnimation((View)this.textContainer, false, 300L));
        } else if (!(this.hideEmptyTextContainer && emptyText || this.textContainer.getVisibility() == 0)) {
            this.textContainer.clearAnimation();
            this.textContainer.startAnimation((Animation)new BottomViewHideShowAnimation((View)this.textContainer, true, 300L));
        }
    }

    @Override
    public void showLoading(boolean initialLoad) {
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.controlsContainer.setVisibility(8);
        this.rippleIndicator.setVisibility(8);
        this.loadingProgressBar.setVisibility(0);
        this.show();
    }

    @Override
    public void finishLoading() {
        if (!this.isLoading) {
            return;
        }
        this.isLoading = false;
        this.controlsContainer.setVisibility(0);
        this.rippleIndicator.setVisibility(0);
        this.loadingProgressBar.setVisibility(8);
        this.updatePlaybackState(this.videoView != null && this.videoView.isPlaying());
    }

    protected void onRewindClick() {
        if (this.buttonsListener == null || !this.buttonsListener.onRewindClicked()) {
            this.internalListener.onRewindClicked();
        }
    }

    protected void onFastForwardClick() {
        if (this.buttonsListener == null || !this.buttonsListener.onFastForwardClicked()) {
            this.internalListener.onFastForwardClicked();
        }
    }

    protected void performSeek(long seekToTime) {
        if (this.seekListener == null || !this.seekListener.onSeekEnded(seekToTime)) {
            this.show();
            this.internalListener.onSeekEnded(seekToTime);
        }
    }

    protected void showTemporary() {
        this.show();
        if (this.videoView != null && this.videoView.isPlaying()) {
            this.hideDelayed();
        }
    }

    protected void registerForInput() {
        RemoteKeyListener remoteKeyListener = new RemoteKeyListener();
        this.setOnKeyListener(remoteKeyListener);
        this.playPauseButton.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
        this.previousButton.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
        this.nextButton.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
        this.rewindButton.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
        this.fastForwardButton.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
    }

    protected void focusNext(View view) {
        int nextId = view.getNextFocusRightId();
        if (nextId == -1) {
            return;
        }
        View nextView = this.findViewById(nextId);
        if (nextView.getVisibility() != 0) {
            this.focusNext(nextView);
            return;
        }
        nextView.requestFocus();
        this.currentFocus = nextView;
        this.buttonFocusChangeListener.onFocusChange(nextView, true);
    }

    protected void focusPrevious(View view) {
        int previousId = view.getNextFocusLeftId();
        if (previousId == -1) {
            return;
        }
        View previousView = this.findViewById(previousId);
        if (previousView.getVisibility() != 0) {
            this.focusPrevious(previousView);
            return;
        }
        previousView.requestFocus();
        this.currentFocus = previousView;
        this.buttonFocusChangeListener.onFocusChange(previousView, true);
    }

    protected class LeanbackInternalListener
    extends VideoControls.InternalListener {
        protected LeanbackInternalListener() {
        }

        @Override
        public boolean onFastForwardClicked() {
            if (VideoControlsLeanback.this.videoView == null) {
                return false;
            }
            long newPosition = VideoControlsLeanback.this.videoView.getCurrentPosition() + 10000L;
            if (newPosition > (long)VideoControlsLeanback.this.progressBar.getMax()) {
                newPosition = VideoControlsLeanback.this.progressBar.getMax();
            }
            VideoControlsLeanback.this.performSeek(newPosition);
            return true;
        }

        @Override
        public boolean onRewindClicked() {
            if (VideoControlsLeanback.this.videoView == null) {
                return false;
            }
            long newPosition = VideoControlsLeanback.this.videoView.getCurrentPosition() - 10000L;
            if (newPosition < 0L) {
                newPosition = 0L;
            }
            VideoControlsLeanback.this.performSeek(newPosition);
            return true;
        }
    }

    protected class RippleTranslateAnimation
    extends TranslateAnimation
    implements Animation.AnimationListener {
        protected static final long DURATION = 250L;
        protected int xDelta;

        public RippleTranslateAnimation(int xDelta) {
            super(0.0f, (float)xDelta, 0.0f, 0.0f);
            this.xDelta = xDelta;
            this.setDuration(250L);
            this.setAnimationListener(this);
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            VideoControlsLeanback.this.rippleIndicator.setX(VideoControlsLeanback.this.rippleIndicator.getX() + (float)this.xDelta);
            VideoControlsLeanback.this.rippleIndicator.clearAnimation();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    protected class RemoteKeyListener
    implements View.OnKeyListener {
        protected RemoteKeyListener() {
        }

        public boolean onKey(View view, int keyCode, KeyEvent event) {
            if (event.getAction() != 0) {
                return false;
            }
            switch (keyCode) {
                case 4: {
                    if (VideoControlsLeanback.this.isVisible && VideoControlsLeanback.this.canViewHide && !VideoControlsLeanback.this.isLoading) {
                        VideoControlsLeanback.this.hide();
                        return true;
                    }
                    if (VideoControlsLeanback.this.controlsParent.getAnimation() == null) break;
                    return true;
                }
                case 19: {
                    VideoControlsLeanback.this.showTemporary();
                    return true;
                }
                case 20: {
                    VideoControlsLeanback.this.hide();
                    return true;
                }
                case 21: {
                    VideoControlsLeanback.this.showTemporary();
                    VideoControlsLeanback.this.focusPrevious(VideoControlsLeanback.this.currentFocus);
                    return true;
                }
                case 22: {
                    VideoControlsLeanback.this.showTemporary();
                    VideoControlsLeanback.this.focusNext(VideoControlsLeanback.this.currentFocus);
                    return true;
                }
                case 23: {
                    VideoControlsLeanback.this.showTemporary();
                    VideoControlsLeanback.this.currentFocus.callOnClick();
                    return true;
                }
                case 85: {
                    VideoControlsLeanback.this.onPlayPauseClick();
                    return true;
                }
                case 126: {
                    if (VideoControlsLeanback.this.videoView == null || VideoControlsLeanback.this.videoView.isPlaying()) break;
                    VideoControlsLeanback.this.videoView.start();
                    return true;
                }
                case 127: {
                    if (VideoControlsLeanback.this.videoView == null || !VideoControlsLeanback.this.videoView.isPlaying()) break;
                    VideoControlsLeanback.this.videoView.pause();
                    return true;
                }
                case 87: {
                    VideoControlsLeanback.this.onNextClick();
                    return true;
                }
                case 88: {
                    VideoControlsLeanback.this.onPreviousClick();
                    return true;
                }
                case 89: {
                    VideoControlsLeanback.this.onRewindClick();
                    return true;
                }
                case 90: {
                    VideoControlsLeanback.this.onFastForwardClick();
                    return true;
                }
            }
            return false;
        }
    }

    protected class ButtonFocusChangeListener
    implements View.OnFocusChangeListener {
        protected ButtonFocusChangeListener() {
        }

        public void onFocusChange(View view, boolean hasFocus) {
            if (!hasFocus) {
                return;
            }
            int xDelta = this.getHorizontalDelta(view);
            VideoControlsLeanback.this.rippleIndicator.startAnimation((Animation)new RippleTranslateAnimation(xDelta));
        }

        protected int getHorizontalDelta(View selectedView) {
            int[] position = new int[2];
            selectedView.getLocationOnScreen(position);
            int viewX = position[0];
            VideoControlsLeanback.this.rippleIndicator.getLocationOnScreen(position);
            int newRippleX = viewX - (VideoControlsLeanback.this.rippleIndicator.getWidth() - selectedView.getWidth()) / 2;
            return newRippleX - position[0];
        }
    }
}

