/*
 * Decompiled with CFR 0.152.
 */
package com.dev.sacot41.scviewpager;

import android.view.View;
import com.dev.sacot41.scviewpager.SCPageAnimation;
import java.util.ArrayList;
import java.util.HashMap;

public class SCViewAnimation {
    private View view;
    private HashMap<Integer, ArrayList<SCPageAnimation>> pageAnimationMap;

    public SCViewAnimation(View inView) {
        this.view = inView;
        this.pageAnimationMap = new HashMap();
    }

    public void startToPosition(Integer xPosition, Integer yPosition) {
        if (xPosition != null) {
            this.view.setX((float)xPosition.intValue());
        }
        if (yPosition != null) {
            this.view.setY((float)yPosition.intValue());
        }
        this.view.requestLayout();
    }

    public void addPageAnimation(SCPageAnimation inPageAnimation) {
        ArrayList<SCPageAnimation> animationList = this.pageAnimationMap.get(inPageAnimation.page);
        if (animationList == null) {
            animationList = new ArrayList();
        }
        animationList.add(inPageAnimation);
        this.pageAnimationMap.put(inPageAnimation.page, animationList);
    }

    public void applyAnimation(int page, float positionOffset) {
        ArrayList<SCPageAnimation> animationList = this.pageAnimationMap.get(page);
        if (animationList == null) {
            return;
        }
        for (SCPageAnimation animation : animationList) {
            animation.applyTransformation(this.view, positionOffset);
        }
    }
}

