/*
 * Decompiled with CFR 0.152.
 */
package com.hieupt.android.standalonescrollbar;

import android.view.View;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002J.\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b\u00a8\u0006\u0013"}, d2={"Lcom/hieupt/android/standalonescrollbar/MotionHelper;", "", "()V", "isInTouchTarget", "", "position", "", "viewStart", "", "viewEnd", "parentStart", "parentEnd", "minTouchTargetSize", "isInViewTouchTarget", "parentView", "Landroid/view/View;", "view", "x", "y", "android-standalone-scroll-bar_release"})
public final class MotionHelper {
    @NotNull
    public static final MotionHelper INSTANCE;

    public final boolean isInViewTouchTarget(@NotNull View parentView, @NotNull View view, float x, float y, int minTouchTargetSize2) {
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        int scrollX = parentView.getScrollX();
        int scrollY = parentView.getScrollY();
        return this.isInTouchTarget(x, view.getLeft() - scrollX, view.getRight() - scrollX, 0, parentView.getWidth(), minTouchTargetSize2) && this.isInTouchTarget(y, view.getTop() - scrollY, view.getBottom() - scrollY, 0, parentView.getHeight(), minTouchTargetSize2);
    }

    private final boolean isInTouchTarget(float position, int viewStart, int viewEnd, int parentStart, int parentEnd, int minTouchTargetSize2) {
        int touchTargetEnd;
        int viewSize = viewEnd - viewStart;
        if (viewSize >= minTouchTargetSize2) {
            return position >= (float)viewStart && position < (float)viewEnd;
        }
        int touchTargetStart = viewStart - (minTouchTargetSize2 - viewSize) / 2;
        if (touchTargetStart < parentStart) {
            touchTargetStart = parentStart;
        }
        if ((touchTargetEnd = touchTargetStart + minTouchTargetSize2) > parentEnd && (touchTargetStart = (touchTargetEnd = parentEnd) - minTouchTargetSize2) < parentStart) {
            touchTargetStart = parentStart;
        }
        return position >= (float)touchTargetStart && position < (float)touchTargetEnd;
    }

    private MotionHelper() {
    }

    static {
        MotionHelper motionHelper;
        INSTANCE = motionHelper = new MotionHelper();
    }
}

