/*
 * Decompiled with CFR 0.152.
 */
package com.deque.html.axecore.extensions;

import com.deque.html.axecore.results.Results;
import com.deque.html.axecore.selenium.AxeBuilder;
import com.deque.html.axecore.selenium.AxeBuilderOptions;
import java.io.IOException;
import java.util.ArrayList;
import javax.naming.OperationNotSupportedException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public final class WebDriverExtensions {
    private WebDriverExtensions() {
    }

    public static Results analyze(WebDriver webDriver) throws IOException, OperationNotSupportedException {
        if (webDriver == null) {
            throw new NullPointerException("the webDriver is null");
        }
        AxeBuilder axeBuilder = new AxeBuilder();
        return axeBuilder.analyze(webDriver);
    }

    public static Results analyze(WebDriver webDriver, AxeBuilderOptions axeBuilderOptions) throws OperationNotSupportedException, IOException {
        if (webDriver == null) {
            throw new NullPointerException("the webDriver is null");
        }
        AxeBuilder axeBuilder = new AxeBuilder(axeBuilderOptions);
        return axeBuilder.analyze(webDriver);
    }

    public static Results analyze(WebDriver webDriver, WebElement context) throws IOException, OperationNotSupportedException {
        if (webDriver == null) {
            throw new NullPointerException("the webDriver is null");
        }
        if (context == null) {
            throw new NullPointerException("the context is null");
        }
        AxeBuilder axeBuilder = new AxeBuilder();
        return axeBuilder.analyze(webDriver, context);
    }

    public static Results analyze(WebDriver webDriver, WebElement context, AxeBuilderOptions axeBuilderOptions) throws OperationNotSupportedException, IOException {
        if (webDriver == null) {
            throw new NullPointerException("the web Driver is null");
        }
        if (context == null) {
            throw new NullPointerException("the context is null");
        }
        AxeBuilder axeBuilder = new AxeBuilder(axeBuilderOptions);
        return axeBuilder.analyze(webDriver, context);
    }

    public static String openAboutBlank(WebDriver webDriver) {
        String currentWindow = webDriver.getWindowHandle();
        try {
            JavascriptExecutor driver = (JavascriptExecutor)webDriver;
            driver.executeScript("window.open('about:blank', '_blank')", new Object[0]);
            ArrayList handles = new ArrayList(webDriver.getWindowHandles());
            String abHandle = (String)handles.get(handles.size() - 1);
            webDriver.switchTo().window(abHandle);
            webDriver.get("about:blank");
        }
        catch (Exception e) {
            throw new RuntimeException("switchToWindow failed. Are you using updated browser drivers? Please check out https://github.com/dequelabs/axe-core-maven-html/blob/develop/error-handling.md", e);
        }
        return currentWindow;
    }

    public static void closeAboutBlank(WebDriver webDriver, String prevWindow) {
        webDriver.close();
        webDriver.switchTo().window(prevWindow);
    }
}

