/*
 * Decompiled with CFR 0.152.
 */
package com.deque.html.axecore.extensions;

import com.deque.html.axecore.providers.IAxeScriptProvider;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import javax.naming.OperationNotSupportedException;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public final class WebDriverInjectorExtensions {
    private WebDriverInjectorExtensions() {
    }

    public static Object executeScript(WebDriver webDriver, String command, Object ... args) {
        return ((JavascriptExecutor)webDriver).executeScript(command, args);
    }

    public static Object executeAsyncScript(WebDriver webDriver, String command, Object ... args) {
        return ((JavascriptExecutor)webDriver).executeAsyncScript(command, args);
    }

    public static void inject(WebDriver driver, IAxeScriptProvider scriptProvider, boolean disableIframeTesting) throws OperationNotSupportedException, IOException {
        WebDriverInjectorExtensions.inject(driver, scriptProvider.getScript(), disableIframeTesting, null, false);
    }

    public static void inject(WebDriver driver, String script, boolean disableIframeTesting) {
        WebDriverInjectorExtensions.inject(driver, script, disableIframeTesting, null, false);
    }

    public static void inject(WebDriver driver, String script, boolean disableIframeTesting, Consumer<WebDriver> injectCB, boolean doNotInjectAxe) {
        JavascriptExecutor js = (JavascriptExecutor)driver;
        driver.switchTo().defaultContent();
        if (!doNotInjectAxe) {
            js.executeScript(script, new Object[0]);
        }
        if (injectCB != null) {
            injectCB.accept(driver);
        }
        if (!disableIframeTesting) {
            WebDriverInjectorExtensions.injectIntoFrames(driver, script, injectCB, doNotInjectAxe);
        }
    }

    public static void injectAsync(WebDriver driver, String script, boolean disableIframeTesting) {
        JavascriptExecutor js = (JavascriptExecutor)driver;
        driver.switchTo().defaultContent();
        js.executeAsyncScript(script, new Object[0]);
        if (!disableIframeTesting) {
            WebDriverInjectorExtensions.injectIntoFramesAsync(driver, script);
        }
    }

    private static void injectIntoFrames(WebDriver driver, String script, Consumer<WebDriver> injectCB, boolean doNotInjectAxe) {
        JavascriptExecutor js = (JavascriptExecutor)driver;
        List frames = driver.findElements(By.xpath((String)".//*[local-name()='frame' or local-name()='iframe']"));
        for (WebElement frame : frames) {
            try {
                driver.switchTo().frame(frame);
                if (!doNotInjectAxe) {
                    js.executeScript(script, new Object[0]);
                }
                if (injectCB != null) {
                    injectCB.accept(driver);
                }
                WebDriverInjectorExtensions.injectIntoFrames(driver, script, injectCB, doNotInjectAxe);
                driver.switchTo().parentFrame();
            }
            catch (Exception e) {
                if (!(e instanceof JavascriptException)) continue;
                throw e;
            }
        }
    }

    private static void injectIntoFramesAsync(WebDriver driver, String script) {
        JavascriptExecutor js = (JavascriptExecutor)driver;
        List frames = driver.findElements(By.xpath((String)".//*[local-name()='frame' or local-name()='iframe']"));
        for (WebElement frame : frames) {
            try {
                driver.switchTo().frame(frame);
                js.executeAsyncScript(script, new Object[0]);
                WebDriverInjectorExtensions.injectIntoFramesAsync(driver, script);
                driver.switchTo().parentFrame();
            }
            catch (Exception e) {
                if (!(e instanceof JavascriptException)) continue;
                throw e;
            }
        }
    }
}

