/*
 * Decompiled with CFR 0.152.
 */
package com.deque.html.axecore.providers;

import com.deque.html.axecore.providers.EmbeddedResourceProvider;
import com.deque.html.axecore.providers.IAxeScriptProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.naming.OperationNotSupportedException;

public class FileAxeScriptProvider
implements IAxeScriptProvider {
    private String filePath;

    public FileAxeScriptProvider(String newFilePath) throws FileNotFoundException {
        if (newFilePath.isEmpty()) {
            throw new NullPointerException("File Path is empty or null");
        }
        if (!new File(newFilePath).exists()) {
            throw new FileNotFoundException();
        }
        this.filePath = newFilePath;
    }

    @Override
    public String getScript() throws OperationNotSupportedException, IOException {
        File file = new File(this.filePath);
        if (!file.exists()) {
            throw new OperationNotSupportedException("File: " + this.filePath + " does not exist");
        }
        return EmbeddedResourceProvider.readEmbeddedFile(this.filePath);
    }
}

