/*
 * Decompiled with CFR 0.152.
 */
package com.deque.html.axecore.selenium;

import com.deque.html.axecore.axeargs.AxeRuleOptions;
import com.deque.html.axecore.axeargs.AxeRunContext;
import com.deque.html.axecore.axeargs.AxeRunOnlyOptions;
import com.deque.html.axecore.axeargs.AxeRunOptions;
import com.deque.html.axecore.extensions.WebDriverExtensions;
import com.deque.html.axecore.extensions.WebDriverInjectorExtensions;
import com.deque.html.axecore.providers.EmbeddedResourceAxeProvider;
import com.deque.html.axecore.providers.IAxeScriptProvider;
import com.deque.html.axecore.results.FrameContext;
import com.deque.html.axecore.results.Results;
import com.deque.html.axecore.results.Rule;
import com.deque.html.axecore.selenium.AxeBuilderOptions;
import com.deque.html.axecore.selenium.AxeReporter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class AxeBuilder {
    private AxeRunContext runContext = new AxeRunContext();
    private AxeRunOptions runOptions = new AxeRunOptions();
    private String outputFilePath = null;
    private AxeBuilderOptions builderOptions = this.getDefaultAxeBuilderOptions();
    private boolean legacyMode = false;
    private boolean noSandbox = false;
    private boolean disableIframeTesting = false;
    private Consumer<WebDriver> injectAxeCallback;
    private boolean doNotInjectAxe = false;
    private int timeout = 30;
    private final ObjectMapper objectMapper;
    public final String axeRunScript = "var callback = arguments[arguments.length - 1];var context = typeof arguments[0] === 'string' ? JSON.parse(arguments[0]) : arguments[0];context = context || document;var options = JSON.parse(arguments[1]);axe.run(context, options).then(callback)";
    public final String unsafeAllOrigins = "<unsafe_all_origins>";
    public final String sameOrign = "<same_origin>";
    public final String iframeAllowScriptTemplate = "axe.configure({ allowedOrigins: ['%s'] });";
    public final String hasRunPartialScript = "return typeof window.axe.runPartial === 'function'";
    public final String sandboxBusterScript = "const callback = arguments[arguments.length - 1];const iframes = Array.from(  document.querySelectorAll('iframe[sandbox]'));const removeSandboxAttr = clone => attr => {  if (attr.name === 'sandbox') return;  clone.setAttribute(attr.name, attr.value);};const replaceSandboxedIframe = iframe => {  const clone = document.createElement('iframe');  const promise = new Promise(    iframeLoaded => (clone.onload = iframeLoaded)  );  Array.from(iframe.attributes).forEach(removeSandboxAttr(clone));  iframe.parentElement.replaceChild(clone, iframe);  return promise;};Promise.all(iframes.map(replaceSandboxedIframe)).then(callback);";
    private static String shadowSelectScript = "return axe.utils.shadowSelect(JSON.parse(arguments[0]))";
    private static String runPartialScript = "const context = typeof arguments[0] == 'string' ? JSON.parse(arguments[0]) : arguments[0];const options = JSON.parse(arguments[1]);const cb = arguments[arguments.length - 1];window.c = context; window.o = options;window.axe.runPartial(context, options).then(cb);";
    private static String frameContextScript = "const context = typeof arguments[0] == 'string' ? JSON.parse(arguments[0]) : arguments[0];return window.axe.utils.getFrameContexts(context);";
    private static String finishRunScript = "return axe.finishRun(arguments[0])";
    @Deprecated
    private String options = "{}";

    public AxeBuilderOptions getDefaultAxeBuilderOptions() {
        AxeBuilderOptions builderOptions = new AxeBuilderOptions();
        builderOptions.setScriptProvider(new EmbeddedResourceAxeProvider());
        return builderOptions;
    }

    public AxeBuilder setAxeScriptProvider(IAxeScriptProvider axeProvider) {
        this.builderOptions.setScriptProvider(axeProvider);
        return this;
    }

    public IAxeScriptProvider getAxeScriptProvider() {
        return this.builderOptions.getScriptProvider();
    }

    public AxeBuilder setTimeout(int newTimeout) {
        this.timeout = newTimeout;
        return this;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String newOptions) {
        this.options = newOptions;
    }

    public AxeBuilder() {
        this.builderOptions = this.getDefaultAxeBuilderOptions();
        this.objectMapper = new ObjectMapper();
    }

    public AxeBuilder(AxeBuilderOptions builderOptions) {
        AxeBuilder.validateNotNullParameter(builderOptions);
        this.builderOptions = builderOptions;
        this.objectMapper = new ObjectMapper();
    }

    public AxeBuilder(AxeBuilderOptions builderOptions, ObjectMapper objectMapper) {
        AxeBuilder.validateNotNullParameter(builderOptions);
        AxeBuilder.validateNotNullParameter(objectMapper);
        this.objectMapper = objectMapper;
    }

    public AxeBuilder withoutIframeSandboxes() {
        this.noSandbox = true;
        return this;
    }

    public AxeBuilder disableIframeTesting() {
        this.disableIframeTesting = true;
        return this;
    }

    public AxeBuilder withOptions(AxeRunOptions newRunOptions) {
        AxeBuilder.validateNotNullParameter(newRunOptions);
        this.throwIfDeprecatedOptionsSet();
        this.runOptions = newRunOptions;
        return this;
    }

    public AxeBuilder withTags(List<String> tags) {
        AxeBuilder.validateParameters(tags);
        this.throwIfDeprecatedOptionsSet();
        if (tags.isEmpty()) {
            return this;
        }
        AxeRunOnlyOptions runOnlyOptions = new AxeRunOnlyOptions();
        runOnlyOptions.setType("tag");
        runOnlyOptions.setValues(tags);
        this.runOptions.setRunOnly(runOnlyOptions);
        return this;
    }

    public AxeBuilder withOnlyRules(List<String> rules) {
        AxeBuilder.validateParameters(rules);
        this.throwIfDeprecatedOptionsSet();
        if (rules.isEmpty()) {
            return this;
        }
        AxeRunOnlyOptions onlyOptions = new AxeRunOnlyOptions();
        onlyOptions.setType("rule");
        onlyOptions.setValues(rules);
        this.runOptions.setRunOnly(onlyOptions);
        return this;
    }

    public AxeBuilder withRules(List<String> rules) {
        AxeBuilder.validateParameters(rules);
        this.throwIfDeprecatedOptionsSet();
        if (rules.isEmpty()) {
            return this;
        }
        HashMap<String, AxeRuleOptions> rulesMap = new HashMap<String, AxeRuleOptions>();
        for (String rule : rules) {
            AxeRuleOptions ruleOptions = new AxeRuleOptions();
            ruleOptions.setEnabled(true);
            rulesMap.put(rule, ruleOptions);
        }
        this.runOptions.setRules(rulesMap);
        return this;
    }

    public AxeBuilder disableRules(List<String> rules) {
        AxeBuilder.validateParameters(rules);
        this.throwIfDeprecatedOptionsSet();
        if (rules.isEmpty()) {
            return this;
        }
        HashMap<String, AxeRuleOptions> rulesMap = new HashMap<String, AxeRuleOptions>();
        for (String rule : rules) {
            AxeRuleOptions ruleOptions = new AxeRuleOptions();
            ruleOptions.setEnabled(false);
            rulesMap.put(rule, ruleOptions);
        }
        this.runOptions.setRules(rulesMap);
        return this;
    }

    public AxeBuilder include(List<String> selectors) {
        AxeBuilder.validateParameters(selectors);
        if (selectors.isEmpty()) {
            return this;
        }
        this.runContext.setInclude(selectors);
        return this;
    }

    public AxeBuilder exclude(List<String> selectors) {
        AxeBuilder.validateParameters(selectors);
        if (selectors.isEmpty()) {
            return this;
        }
        this.runContext.setExclude(selectors);
        return this;
    }

    public AxeBuilder withOutputFile(String path) {
        AxeBuilder.validateNotNullParameter(path);
        this.outputFilePath = path;
        return this;
    }

    @Deprecated
    public AxeBuilder setLegacyMode() {
        return this.setLegacyMode(true);
    }

    @Deprecated
    public AxeBuilder setLegacyMode(boolean state) {
        this.legacyMode = state;
        return this;
    }

    public void setInjectAxe(Consumer<WebDriver> cb) {
        this.injectAxeCallback = cb;
    }

    public void setInjectAxe(Consumer<WebDriver> cb, boolean stillInjectAxe) {
        this.injectAxeCallback = cb;
        this.doNotInjectAxe = !stillInjectAxe;
    }

    public Results analyze(WebDriver webDriver, WebElement ... context) {
        return this.analyzeRawContext(webDriver, context);
    }

    public Results analyze(WebDriver webDriver) {
        boolean runContextHasData = this.runContext.getInclude() != null || this.runContext.getExclude() != null;
        String rawContext = runContextHasData ? AxeReporter.serialize(this.runContext) : "{ 'exclude': [] }";
        return this.analyzeRawContext(webDriver, rawContext);
    }

    public Results analyze(WebDriver webDriver, boolean injectAxe) {
        boolean runContextHasData = this.runContext.getInclude() != null || this.runContext.getExclude() != null;
        String rawContext = runContextHasData ? AxeReporter.serialize(this.runContext) : "{ 'exclude': [] }";
        return this.analyzeRawContext(webDriver, rawContext);
    }

    private Results analyzeRawContext(WebDriver webDriver, Object rawContextArg) {
        AxeBuilder.validateNotNullParameter(webDriver);
        webDriver.manage().timeouts().setScriptTimeout((long)this.timeout, TimeUnit.SECONDS);
        if (this.noSandbox) {
            try {
                WebDriverInjectorExtensions.injectAsync(webDriver, "const callback = arguments[arguments.length - 1];const iframes = Array.from(  document.querySelectorAll('iframe[sandbox]'));const removeSandboxAttr = clone => attr => {  if (attr.name === 'sandbox') return;  clone.setAttribute(attr.name, attr.value);};const replaceSandboxedIframe = iframe => {  const clone = document.createElement('iframe');  const promise = new Promise(    iframeLoaded => (clone.onload = iframeLoaded)  );  Array.from(iframe.attributes).forEach(removeSandboxAttr(clone));  iframe.parentElement.replaceChild(clone, iframe);  return promise;};Promise.all(iframes.map(replaceSandboxedIframe)).then(callback);", this.disableIframeTesting);
            }
            catch (Exception e) {
                throw new RuntimeException("Error when removing sandbox from iframes", e);
            }
        }
        this.injectAxe(webDriver);
        boolean hasRunPartial = (Boolean)WebDriverInjectorExtensions.executeScript(webDriver, "return typeof window.axe.runPartial === 'function'", new Object[0]);
        if (hasRunPartial && !this.legacyMode) {
            return this.analyzePost43x(webDriver, rawContextArg);
        }
        return this.analyzePre43x(webDriver, rawContextArg);
    }

    private Results buildErrorResults(Exception execpt) {
        SimpleDateFormat df = new SimpleDateFormat("E MMM dd yyyy HH:mm:ss 'GMT'XX (zzzz)");
        String dateTime = df.format(new Date());
        Results results = new Results();
        results.setViolations(new ArrayList<Rule>());
        results.setPasses(new ArrayList<Rule>());
        results.setUrl("");
        results.setTimestamp(dateTime);
        results.setErrorMessage(execpt);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Object> runPartialRecursive(WebDriver webDriver, Object options, Object context, boolean isTopLevel) {
        if (!isTopLevel) {
            this.injectAxe(webDriver);
        }
        try {
            Object fcResponse = WebDriverInjectorExtensions.executeScript(webDriver, frameContextScript, context);
            ArrayList contexts = (ArrayList)this.objectMapper.convertValue(fcResponse, (TypeReference)new TypeReference<ArrayList<FrameContext>>(){});
            Object resResponse = WebDriverInjectorExtensions.executeAsyncScript(webDriver, runPartialScript, context, options);
            ArrayList<Object> partialResults = new ArrayList<Object>();
            partialResults.add(resResponse);
            if (this.disableIframeTesting) {
                ArrayList<Object> arrayList = partialResults;
                return arrayList;
            }
            for (FrameContext fc : contexts) {
                String frameContext = AxeReporter.serialize(fc.getFrameContext());
                String frameSelector = AxeReporter.serialize(fc.getFrameSelector());
                Object frame = WebDriverInjectorExtensions.executeScript(webDriver, shadowSelectScript, frameSelector);
                if (frame instanceof String) {
                    webDriver.switchTo().frame((String)frame);
                } else if (frame instanceof WebElement) {
                    WebElement elem = (WebElement)frame;
                    webDriver.switchTo().frame((WebElement)frame);
                } else if (frame instanceof Integer) {
                    webDriver.switchTo().frame(((Integer)frame).intValue());
                } else {
                    partialResults.add(null);
                    continue;
                }
                ArrayList<Object> morePartialResults = this.runPartialRecursive(webDriver, options, frameContext, false);
                partialResults.addAll(morePartialResults);
            }
            ArrayList<Object> arrayList = partialResults;
            return arrayList;
        }
        catch (RuntimeException e) {
            if (isTopLevel) {
                throw e;
            }
            ArrayList<Object> ret = new ArrayList<Object>();
            ret.add(null);
            ArrayList<Object> arrayList = ret;
            return arrayList;
        }
        finally {
            if (!isTopLevel) {
                webDriver.switchTo().parentFrame();
            }
        }
    }

    private Results analyzePost43x(WebDriver webDriver, Object rawContextArg) {
        Object resResponse;
        ArrayList<Object> partialResults;
        String rawOptionsArg = this.getOptions().equals("{}") ? AxeReporter.serialize(this.runOptions) : this.getOptions();
        try {
            partialResults = this.runPartialRecursive(webDriver, rawOptionsArg, rawContextArg, true);
        }
        catch (RuntimeException re) {
            if (re.getMessage().contains("Unable to inject axe script")) {
                throw re;
            }
            return this.buildErrorResults(re);
        }
        String prevWindow = WebDriverExtensions.openAboutBlank(webDriver);
        this.injectAxe(webDriver);
        try {
            resResponse = WebDriverInjectorExtensions.executeScript(webDriver, finishRunScript, partialResults);
        }
        catch (Exception e) {
            throw new RuntimeException("axe.finishRun failed. Please check out https://github.com/dequelabs/axe-core-maven-html/error-handling.md`", e);
        }
        WebDriverExtensions.closeAboutBlank(webDriver, prevWindow);
        Results res = (Results)this.objectMapper.convertValue(resResponse, Results.class);
        return res;
    }

    private Results analyzePre43x(WebDriver webDriver, Object rawContextArg) {
        String rawOptionsArg = this.getOptions().equals("{}") ? AxeReporter.serialize(this.runOptions) : this.getOptions();
        Object[] rawArgs = new Object[]{rawContextArg, rawOptionsArg};
        try {
            WebDriverInjectorExtensions.inject(webDriver, this.builderOptions.getScriptProvider().getScript(), this.disableIframeTesting, this.injectAxeCallback, this.doNotInjectAxe);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to inject axe script", e);
        }
        try {
            String allowedOrigins = this.legacyMode ? "<same_origin>" : "<unsafe_all_origins>";
            WebDriverInjectorExtensions.inject(webDriver, String.format("axe.configure({ allowedOrigins: ['%s'] });", allowedOrigins), this.disableIframeTesting);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when enabling iframe communication", e);
        }
        Object response = null;
        try {
            response = ((JavascriptExecutor)webDriver).executeAsyncScript("var callback = arguments[arguments.length - 1];var context = typeof arguments[0] === 'string' ? JSON.parse(arguments[0]) : arguments[0];context = context || document;var options = JSON.parse(arguments[1]);axe.run(context, options).then(callback)", rawArgs);
        }
        catch (JavascriptException je) {
            return this.buildErrorResults((Exception)((Object)je));
        }
        Results results = (Results)this.objectMapper.convertValue(response, Results.class);
        return results;
    }

    private void injectAxe(WebDriver webDriver) {
        if (!this.doNotInjectAxe) {
            try {
                WebDriverInjectorExtensions.executeScript(webDriver, this.builderOptions.getScriptProvider().getScript(), new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to inject axe script", e);
            }
        }
        if (this.injectAxeCallback != null) {
            this.injectAxeCallback.accept(webDriver);
        }
    }

    private static void validateParameters(List<String> parameterValue) {
        for (String string : parameterValue) {
            AxeBuilder.validateNotNullParameter(string);
            if (!string.isEmpty()) continue;
            throw new IllegalArgumentException("There is some items null or empty");
        }
    }

    private static <T> void validateNotNullParameter(T parameterValue) {
        if (parameterValue == null) {
            throw new NullPointerException();
        }
    }

    private void throwIfDeprecatedOptionsSet() {
        if (!this.getOptions().equals("{}")) {
            throw new InvalidArgumentException("Deprecated Options api shouldn't be used with the new apis - WithOptions/WithRules/WithTags or DisableRules");
        }
    }
}

