/*
 * Decompiled with CFR 0.152.
 */
package com.deque.html.axecore.selenium;

import com.deque.html.axecore.axeargs.AxeRuleOptions;
import com.deque.html.axecore.axeargs.AxeRunContext;
import com.deque.html.axecore.axeargs.AxeRunOnlyOptions;
import com.deque.html.axecore.axeargs.AxeRunOptions;
import com.deque.html.axecore.extensions.WebDriverInjectorExtensions;
import com.deque.html.axecore.providers.EmbeddedResourceAxeProvider;
import com.deque.html.axecore.providers.IAxeScriptProvider;
import com.deque.html.axecore.results.Results;
import com.deque.html.axecore.results.Rule;
import com.deque.html.axecore.selenium.AxeBuilderOptions;
import com.deque.html.axecore.selenium.AxeReporter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class AxeBuilder {
    private AxeRunContext runContext = new AxeRunContext();
    private AxeRunOptions runOptions = new AxeRunOptions();
    private String outputFilePath = null;
    private AxeBuilderOptions builderOptions = this.getDefaultAxeBuilderOptions();
    private boolean noSandbox = false;
    private boolean disableIframeTesting = false;
    private int timeout = 30;
    private final ObjectMapper objectMapper;
    public final String axeRunScript = "var callback = arguments[arguments.length - 1];var context = typeof arguments[0] === 'string' ? JSON.parse(arguments[0]) : arguments[0];context = context || document;var options = JSON.parse(arguments[1]);axe.run(context, options, function (err, results) {  {    if (err) {      throw new Error(err);    }    callback(results);  }});";
    public final String sandboxBusterScript = "const callback = arguments[arguments.length - 1];const iframes = Array.from(  document.querySelectorAll('iframe[sandbox]'));const removeSandboxAttr = clone => attr => {  if (attr.name === 'sandbox') return;  clone.setAttribute(attr.name, attr.value);};const replaceSandboxedIframe = iframe => {  const clone = document.createElement('iframe');  const promise = new Promise(    iframeLoaded => (clone.onload = iframeLoaded)  );  Array.from(iframe.attributes).forEach(removeSandboxAttr(clone));  iframe.parentElement.replaceChild(clone, iframe);  return promise;};Promise.all(iframes.map(replaceSandboxedIframe)).then(callback);";
    @Deprecated
    private String options = "{}";

    public AxeBuilderOptions getDefaultAxeBuilderOptions() {
        AxeBuilderOptions builderOptions = new AxeBuilderOptions();
        builderOptions.setScriptProvider(new EmbeddedResourceAxeProvider());
        return builderOptions;
    }

    public AxeBuilder setAxeScriptProvider(IAxeScriptProvider axeProvider) {
        this.builderOptions.setScriptProvider(axeProvider);
        return this;
    }

    public AxeBuilder setTimeout(int newTimeout) {
        this.timeout = newTimeout;
        return this;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String newOptions) {
        this.options = newOptions;
    }

    public AxeBuilder() {
        this.builderOptions = this.getDefaultAxeBuilderOptions();
        this.objectMapper = new ObjectMapper();
    }

    public AxeBuilder(AxeBuilderOptions builderOptions) {
        AxeBuilder.validateNotNullParameter(builderOptions);
        this.builderOptions = builderOptions;
        this.objectMapper = new ObjectMapper();
    }

    public AxeBuilder(AxeBuilderOptions builderOptions, ObjectMapper objectMapper) {
        AxeBuilder.validateNotNullParameter(builderOptions);
        AxeBuilder.validateNotNullParameter(objectMapper);
        this.objectMapper = objectMapper;
    }

    public AxeBuilder withoutIframeSandboxes() {
        this.noSandbox = true;
        return this;
    }

    public AxeBuilder disableIframeTesting() {
        this.disableIframeTesting = true;
        return this;
    }

    public AxeBuilder withOptions(AxeRunOptions newRunOptions) {
        AxeBuilder.validateNotNullParameter(newRunOptions);
        this.throwIfDeprecatedOptionsSet();
        this.runOptions = newRunOptions;
        return this;
    }

    public AxeBuilder withTags(List<String> tags) {
        AxeBuilder.validateParameters(tags);
        this.throwIfDeprecatedOptionsSet();
        if (tags.isEmpty()) {
            return this;
        }
        AxeRunOnlyOptions runOnlyOptions = new AxeRunOnlyOptions();
        runOnlyOptions.setType("tag");
        runOnlyOptions.setValues(tags);
        this.runOptions.setRunOnly(runOnlyOptions);
        return this;
    }

    public AxeBuilder withOnlyRules(List<String> rules) {
        AxeBuilder.validateParameters(rules);
        this.throwIfDeprecatedOptionsSet();
        if (rules.isEmpty()) {
            return this;
        }
        AxeRunOnlyOptions onlyOptions = new AxeRunOnlyOptions();
        onlyOptions.setType("rule");
        onlyOptions.setValues(rules);
        this.runOptions.setRunOnly(onlyOptions);
        return this;
    }

    public AxeBuilder withRules(List<String> rules) {
        AxeBuilder.validateParameters(rules);
        this.throwIfDeprecatedOptionsSet();
        if (rules.isEmpty()) {
            return this;
        }
        HashMap<String, AxeRuleOptions> rulesMap = new HashMap<String, AxeRuleOptions>();
        for (String rule : rules) {
            AxeRuleOptions ruleOptions = new AxeRuleOptions();
            ruleOptions.setEnabled(true);
            rulesMap.put(rule, ruleOptions);
        }
        this.runOptions.setRules(rulesMap);
        return this;
    }

    public AxeBuilder disableRules(List<String> rules) {
        AxeBuilder.validateParameters(rules);
        this.throwIfDeprecatedOptionsSet();
        if (rules.isEmpty()) {
            return this;
        }
        HashMap<String, AxeRuleOptions> rulesMap = new HashMap<String, AxeRuleOptions>();
        for (String rule : rules) {
            AxeRuleOptions ruleOptions = new AxeRuleOptions();
            ruleOptions.setEnabled(false);
            rulesMap.put(rule, ruleOptions);
        }
        this.runOptions.setRules(rulesMap);
        return this;
    }

    public AxeBuilder include(List<String> selectors) {
        AxeBuilder.validateParameters(selectors);
        if (selectors.isEmpty()) {
            return this;
        }
        this.runContext.setInclude(selectors);
        return this;
    }

    public AxeBuilder exclude(List<String> selectors) {
        AxeBuilder.validateParameters(selectors);
        if (selectors.isEmpty()) {
            return this;
        }
        this.runContext.setExclude(selectors);
        return this;
    }

    public AxeBuilder withOutputFile(String path) {
        AxeBuilder.validateNotNullParameter(path);
        this.outputFilePath = path;
        return this;
    }

    public Results analyze(WebDriver webDriver, WebElement ... context) {
        return this.analyzeRawContext(webDriver, context, true);
    }

    public Results analyze(WebDriver webDriver) {
        boolean runContextHasData = this.runContext.getInclude() != null || this.runContext.getExclude() != null;
        String rawContext = runContextHasData ? AxeReporter.serialize(this.runContext) : null;
        return this.analyzeRawContext(webDriver, rawContext, true);
    }

    public Results analyze(WebDriver webDriver, boolean injectAxe) {
        boolean runContextHasData = this.runContext.getInclude() != null || this.runContext.getExclude() != null;
        String rawContext = runContextHasData ? AxeReporter.serialize(this.runContext) : null;
        return this.analyzeRawContext(webDriver, rawContext, injectAxe);
    }

    private Results analyzeRawContext(WebDriver webDriver, Object rawContextArg, boolean injectAxe) {
        AxeBuilder.validateNotNullParameter(webDriver);
        String rawOptionsArg = this.getOptions().equals("{}") ? AxeReporter.serialize(this.runOptions) : this.getOptions();
        Object[] rawArgs = new Object[]{rawContextArg, rawOptionsArg};
        if (this.noSandbox) {
            try {
                WebDriverInjectorExtensions.injectAsync(webDriver, "const callback = arguments[arguments.length - 1];const iframes = Array.from(  document.querySelectorAll('iframe[sandbox]'));const removeSandboxAttr = clone => attr => {  if (attr.name === 'sandbox') return;  clone.setAttribute(attr.name, attr.value);};const replaceSandboxedIframe = iframe => {  const clone = document.createElement('iframe');  const promise = new Promise(    iframeLoaded => (clone.onload = iframeLoaded)  );  Array.from(iframe.attributes).forEach(removeSandboxAttr(clone));  iframe.parentElement.replaceChild(clone, iframe);  return promise;};Promise.all(iframes.map(replaceSandboxedIframe)).then(callback);", this.disableIframeTesting);
            }
            catch (Exception e) {
                throw new RuntimeException("Error when removing sandbox from iframes", e);
            }
        }
        if (injectAxe) {
            try {
                WebDriverInjectorExtensions.inject(webDriver, this.builderOptions.getScriptProvider(), this.disableIframeTesting);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to inject axe script", e);
            }
        }
        webDriver.manage().timeouts().setScriptTimeout((long)this.timeout, TimeUnit.SECONDS);
        Object response = null;
        try {
            response = ((JavascriptExecutor)webDriver).executeAsyncScript("var callback = arguments[arguments.length - 1];var context = typeof arguments[0] === 'string' ? JSON.parse(arguments[0]) : arguments[0];context = context || document;var options = JSON.parse(arguments[1]);axe.run(context, options, function (err, results) {  {    if (err) {      throw new Error(err);    }    callback(results);  }});", rawArgs);
        }
        catch (JavascriptException je) {
            SimpleDateFormat df = new SimpleDateFormat("E MMM dd yyyy HH:mm:ss 'GMT'XX (zzzz)");
            String dateTime = df.format(new Date());
            Results results = new Results();
            results.setViolations(new ArrayList<Rule>());
            results.setPasses(new ArrayList<Rule>());
            results.setUrl("");
            results.setTimestamp(dateTime);
            results.setErrorMessage((Exception)((Object)je));
            return results;
        }
        Results results = (Results)this.objectMapper.convertValue(response, Results.class);
        return results;
    }

    private static void validateParameters(List<String> parameterValue) {
        for (String string : parameterValue) {
            AxeBuilder.validateNotNullParameter(string);
            if (!string.isEmpty()) continue;
            throw new IllegalArgumentException("There is some items null or empty");
        }
    }

    private static <T> void validateNotNullParameter(T parameterValue) {
        if (parameterValue == null) {
            throw new NullPointerException();
        }
    }

    private void throwIfDeprecatedOptionsSet() {
        if (!this.getOptions().equals("{}")) {
            throw new InvalidArgumentException("Deprecated Options api shouldn't be used with the new apis - WithOptions/WithRules/WithTags or DisableRules");
        }
    }
}

