/*
 * Decompiled with CFR 0.152.
 */
package com.deque.html.axecore.selenium;

import com.deque.html.axecore.axeargs.AxeRunOptions;
import com.deque.html.axecore.results.Node;
import com.deque.html.axecore.results.Results;
import com.deque.html.axecore.results.Rule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.openqa.selenium.WebDriver;

public final class AxeReporter {
    private static String axeResultString;

    private AxeReporter() {
    }

    public static void setAxeResultString(String newAxeResult) {
        axeResultString = newAxeResult;
    }

    public static String getAxeResultString() {
        return axeResultString;
    }

    public static void writeResultsToTextFile(String outputFilePath, Object output) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilePath + ".txt"), StandardCharsets.UTF_8));){
            writer.write(output.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeResultsToJsonFile(String outputFilePath, Results output) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilePath + ".json"), StandardCharsets.UTF_8));){
            writer.write(AxeReporter.serialize(output));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static <T> String serialize(T obj) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException jpe) {
            throw new IllegalArgumentException("Cannot serialize object");
        }
    }

    static AxeRunOptions deserialize(String obj) {
        ObjectMapper mapper = new ObjectMapper();
        return (AxeRunOptions)mapper.convertValue((Object)obj, AxeRunOptions.class);
    }

    public static boolean getReadableAxeResults(String typeOfScan, WebDriver webDriver, List<Rule> scannedResults) {
        StringBuilder message = new StringBuilder();
        int axeRules = scannedResults.size();
        message.append("ACCESSIBILITY CHECK");
        message.append(System.lineSeparator());
        message.append(typeOfScan.toUpperCase()).append(" check for: ").append(webDriver.getCurrentUrl());
        message.append(System.lineSeparator());
        message.append("Found ").append(axeRules).append(" items");
        message.append(System.lineSeparator());
        if (axeRules == 0) {
            AxeReporter.setAxeResultString(message.toString().trim());
            return false;
        }
        message.append(System.getProperty("line.separator"));
        int loops = 1;
        for (Rule element : scannedResults) {
            message.append(loops++).append(": ").append(element.getHelp());
            message.append(System.lineSeparator());
            message.append("Description: ").append(element.getDescription());
            message.append(System.lineSeparator());
            message.append("Help URL: ").append(element.getHelp());
            message.append(System.lineSeparator());
            message.append("Impact: ").append(element.getImpact());
            message.append(System.lineSeparator());
            message.append("Tags: ").append(String.join((CharSequence)", ", element.getTags()));
            message.append(System.lineSeparator());
            if (element.getNodes() != null && element.getNodes().isEmpty()) {
                for (Node node : element.getNodes()) {
                    message.append("\\t\\tHTML element: ").append(node.getHtml());
                    message.append("\\t\\tSelector: ").append(node.getTarget());
                }
            }
            message.append(System.lineSeparator());
            message.append(System.lineSeparator());
        }
        AxeReporter.setAxeResultString(message.toString().trim());
        return true;
    }
}

