/*
 * Decompiled with CFR 0.152.
 */
package com.deque.html.axecore.extensions;

import com.deque.html.axecore.providers.IAxeScriptProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.OperationNotSupportedException;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public final class WebDriverInjectorExtensions {
    private WebDriverInjectorExtensions() {
    }

    public static Object executeAsyncScript(WebDriver webDriver, String command, Object ... args) {
        return ((JavascriptExecutor)webDriver).executeAsyncScript(command, args);
    }

    public static void inject(WebDriver driver, IAxeScriptProvider scriptProvider) throws OperationNotSupportedException, IOException {
        if (scriptProvider == null) {
            throw new NullPointerException("the Script provider is null");
        }
        String script = scriptProvider.getScript();
        WebDriverInjectorExtensions.inject(driver, script);
    }

    public static void inject(WebDriver driver, String script) {
        ArrayList<WebElement> parents = new ArrayList<WebElement>();
        JavascriptExecutor js = (JavascriptExecutor)driver;
        WebDriverInjectorExtensions.injectIntoFrames(driver, script, parents);
        driver.switchTo().defaultContent();
        js.executeScript(script, new Object[0]);
    }

    public static void injectAsync(WebDriver driver, String script) {
        ArrayList<WebElement> parents = new ArrayList<WebElement>();
        JavascriptExecutor js = (JavascriptExecutor)driver;
        driver.switchTo().defaultContent();
        js.executeAsyncScript(script, new Object[0]);
        WebDriverInjectorExtensions.injectIntoFramesAsync(driver, script, parents);
        driver.switchTo().defaultContent();
    }

    private static void injectIntoFrames(WebDriver driver, String script, List<WebElement> parents) {
        JavascriptExecutor js = (JavascriptExecutor)driver;
        List frames = driver.findElements(By.tagName((String)"iframe"));
        for (WebElement frame : frames) {
            driver.switchTo().defaultContent();
            if (parents != null) {
                for (WebElement parent : parents) {
                    driver.switchTo().frame(parent);
                }
            }
            driver.switchTo().frame(frame);
            js.executeScript(script, new Object[0]);
            ArrayList<WebElement> localParents = new ArrayList<WebElement>();
            if (parents == null) {
                localParents.add(null);
                throw new NullPointerException();
            }
            localParents.addAll(parents);
            localParents.add(frame);
            WebDriverInjectorExtensions.injectIntoFrames(driver, script, localParents);
        }
    }

    private static void injectIntoFramesAsync(WebDriver driver, String script, List<WebElement> parents) {
        JavascriptExecutor js = (JavascriptExecutor)driver;
        List frames = driver.findElements(By.tagName((String)"iframe"));
        for (WebElement frame : frames) {
            driver.switchTo().defaultContent();
            if (parents != null) {
                for (WebElement parent : parents) {
                    driver.switchTo().frame(parent);
                }
            }
            driver.switchTo().frame(frame);
            js.executeAsyncScript(script, new Object[0]);
            ArrayList<WebElement> localParents = new ArrayList<WebElement>();
            if (parents == null) {
                localParents.add(null);
                throw new NullPointerException();
            }
            localParents.addAll(parents);
            localParents.add(frame);
            WebDriverInjectorExtensions.injectIntoFrames(driver, script, localParents);
        }
    }
}

