/*
 * Decompiled with CFR 0.152.
 */
package com.deque.html.axecore.playwright;

import com.deque.html.axecore.args.AxeRuleOptions;
import com.deque.html.axecore.args.AxeRunContext;
import com.deque.html.axecore.args.AxeRunOnlyOptions;
import com.deque.html.axecore.args.AxeRunOptions;
import com.deque.html.axecore.args.FromFrames;
import com.deque.html.axecore.args.FromShadowDom;
import com.deque.html.axecore.results.AxeResults;
import com.deque.html.axecore.results.FrameContext;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.Page;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.io.IOUtils;

public class AxeBuilder {
    private final AxeRunContext context = new AxeRunContext();
    private AxeRunOptions options = new AxeRunOptions();
    private boolean legacyMode = false;
    private boolean hasRunPartial = false;
    private final ObjectMapper objectMapper;
    private final Page page;

    public AxeBuilder(Page page) {
        this.page = page;
        this.objectMapper = new ObjectMapper();
    }

    public AxeBuilder include(List<String> selector) {
        this.context.setInclude(selector);
        return this;
    }

    public AxeBuilder include(String selector) {
        this.context.setInclude((Object)selector);
        return this;
    }

    public AxeBuilder include(Object selector) {
        this.context.setInclude(selector);
        return this;
    }

    public AxeBuilder include(Object ... selector) {
        this.context.setInclude((Object)selector);
        return this;
    }

    public AxeBuilder include(FromFrames fromFrames) {
        this.context.setInclude((Object)fromFrames);
        return this;
    }

    public AxeBuilder include(FromShadowDom fromShadowDom) {
        this.context.setInclude((Object)fromShadowDom);
        return this;
    }

    public AxeBuilder exclude(List<String> selector) {
        this.context.setExclude(selector);
        return this;
    }

    public AxeBuilder exclude(String selector) {
        this.context.setExclude((Object)selector);
        return this;
    }

    public AxeBuilder exclude(Object selector) {
        this.context.setExclude(selector);
        return this;
    }

    public AxeBuilder exclude(Object ... selector) {
        this.context.setExclude((Object)selector);
        return this;
    }

    public AxeBuilder exclude(FromFrames fromFrames) {
        this.context.setExclude((Object)fromFrames);
        return this;
    }

    public AxeBuilder exclude(FromShadowDom fromShadowDom) {
        this.context.setExclude((Object)fromShadowDom);
        return this;
    }

    public AxeBuilder options(AxeRunOptions axeRunOptions) {
        this.options = axeRunOptions;
        return this;
    }

    public AxeBuilder withRules(List<String> rules) {
        if (rules.isEmpty()) {
            throw new RuntimeException("withRules list cannot be empty. Please see: https://github.com/dequelabs/axe-core/blob/develop/doc/rule-descriptions.md#rule-descriptions");
        }
        AxeRunOnlyOptions runOnlyOptions = new AxeRunOnlyOptions();
        runOnlyOptions.setType("rule");
        runOnlyOptions.setValues(rules);
        this.options.setRunOnly(runOnlyOptions);
        return this;
    }

    public AxeBuilder withTags(List<String> tags) {
        if (tags.isEmpty()) {
            throw new RuntimeException("withTags list cannot be empty. Please see: https://github.com/dequelabs/axe-core/blob/develop/doc/API.md#axe-core-tags");
        }
        AxeRunOnlyOptions runOnlyOptions = new AxeRunOnlyOptions();
        runOnlyOptions.setType("tag");
        runOnlyOptions.setValues(tags);
        this.options.setRunOnly(runOnlyOptions);
        return this;
    }

    public AxeBuilder disableRules(List<String> rules) {
        if (rules.isEmpty()) {
            throw new RuntimeException("disableRules list cannot be empty. Please see: https://github.com/dequelabs/axe-core/blob/develop/doc/rule-descriptions.md#rule-descriptions");
        }
        HashMap disableRulesMap = new HashMap();
        rules.forEach(rule -> {
            AxeRuleOptions axeRuleOptions = new AxeRuleOptions();
            axeRuleOptions.setEnabled(Boolean.valueOf(false));
            disableRulesMap.put(rule, axeRuleOptions);
        });
        this.options.setRules(disableRulesMap);
        return this;
    }

    public AxeResults analyze() {
        Object results;
        ArrayList<String> partialResults;
        String axeContext = this.serialize(this.context);
        String axeOptions = this.serialize(this.options);
        try {
            this.page.evaluate("() => {" + AxeBuilder.getAxeScript() + "}");
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Problematic axe-source, unable to inject. ", runtimeException);
        }
        this.hasRunPartial = this.hasRunPartial(this.page);
        if (!this.hasRunPartial || this.legacyMode) {
            Object results2 = this.run(axeContext, axeOptions);
            return (AxeResults)this.objectMapper.convertValue(results2, AxeResults.class);
        }
        try {
            partialResults = this.runPartialRecursive(this.page.mainFrame(), axeContext, true);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getMessage().contains("Unable to inject axe-source.")) {
                throw runtimeException;
            }
            return this.axeResultsErrors(runtimeException);
        }
        try {
            results = this.finishRun(partialResults);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Axe finishRun failed. Please see: https://github.com/dequelabs/axe-core-maven-html/blob/develop/playwright/error-handling.md", runtimeException);
        }
        return (AxeResults)this.objectMapper.convertValue(results, AxeResults.class);
    }

    public AxeBuilder setLegacyMode(boolean legacyMode) {
        this.legacyMode = legacyMode;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> runPartialRecursive(Frame frame, String context, boolean isTopLevel) {
        try {
            if (!isTopLevel) {
                this.injectAxeSource(frame);
            }
            Object frameContextResult = this.getFrameContexts(frame, context);
            ArrayList frameContexts = (ArrayList)this.objectMapper.convertValue(frameContextResult, (TypeReference)new TypeReference<ArrayList<FrameContext>>(){});
            String result = this.runPartial(frame, context, this.serialize(this.options));
            ArrayList<String> partialResults = new ArrayList<String>();
            partialResults.add(result);
            frameContexts.forEach(frameContext -> {
                String iframeContext = this.serialize(frameContext.getFrameContext());
                String iframeSelector = this.serialize(frameContext.getFrameSelector());
                Object iframe = this.getIframeHandle(frame, iframeSelector);
                if (iframe instanceof ElementHandle) {
                    Frame childFrame = ((ElementHandle)iframe).contentFrame();
                    ArrayList<String> childFrameResults = this.runPartialRecursive(childFrame, iframeContext, false);
                    partialResults.addAll(childFrameResults);
                } else {
                    partialResults.add(null);
                }
            });
            ArrayList<String> arrayList = partialResults;
            return arrayList;
        }
        catch (RuntimeException runtimeException) {
            if (isTopLevel) {
                throw runtimeException;
            }
            ArrayList<String> empty = new ArrayList<String>();
            empty.add(null);
            ArrayList<String> arrayList = empty;
            return arrayList;
        }
        finally {
            this.page.mainFrame();
        }
    }

    private Object run(String axeContext, String axeOptions) {
        if (!this.legacyMode) {
            this.page.frames().forEach(this::injectAxeSource);
        }
        return this.page.evaluate("([axeContext, axeOptions]) => {const context = JSON.parse(axeContext);const options = JSON.parse(axeOptions);return axe.run(context, options).then(res => JSON.parse(JSON.stringify(res)));}", Arrays.asList(axeContext, axeOptions));
    }

    private Object getFrameContexts(Frame frame, String context) {
        return frame.evaluate("(axeContext) => { const context = JSON.parse(axeContext);return axe.utils.getFrameContexts(context)}", (Object)context);
    }

    private Object getIframeHandle(Frame frame, String iframeSelector) {
        return frame.evaluateHandle("(iframeSelector) => {const selector = JSON.parse(iframeSelector);return axe.utils.shadowSelect(selector);}", (Object)iframeSelector);
    }

    private String runPartial(Frame frame, String context, String options) {
        return (String)frame.evaluate("([axeContext, axeOptions]) => {const context = JSON.parse(axeContext);const options = JSON.parse(axeOptions);return axe.runPartial(context, options).then(res => JSON.stringify(res));}", Arrays.asList(context, options));
    }

    private Object finishRun(ArrayList<String> partialResults) {
        Object results;
        Browser browser = this.page.context().browser();
        Page blankPage = browser.newPage();
        blankPage.evaluate(AxeBuilder.getAxeScript() + this.getAxeConfigure(this.hasRunPartial));
        this.storePartialResults(blankPage, partialResults);
        try {
            results = blankPage.evaluate("() => {const partialResults = JSON.parse(window.partialResults || '[]');return axe.finishRun(partialResults);}");
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Please make sure popups are not disabled. Please see: Please see: https://github.com/dequelabs/axe-core-maven-html/blob/develop/playwright/error-handling.md", runtimeException);
        }
        finally {
            blankPage.close();
        }
        return results;
    }

    private void storePartialResults(Page blankPage, ArrayList<String> partialResults) {
        StringJoiner sj = new StringJoiner(",", "[", "]");
        for (String pr : partialResults) {
            sj.add(pr);
        }
        String partialResString = sj.toString();
        int sizeLimit = 20000000;
        while (!partialResString.isEmpty()) {
            int chunkSize = sizeLimit;
            if (chunkSize > partialResString.length()) {
                chunkSize = partialResString.length();
            }
            String chunk = partialResString.substring(0, chunkSize);
            partialResString = partialResString.substring(chunkSize);
            blankPage.evaluate("(chunk) => {window.partialResults ??= '';window.partialResults += chunk;}", (Object)chunk);
        }
    }

    private boolean hasRunPartial(Page page) {
        return (Boolean)page.evaluate("typeof window.axe.runPartial === 'function'");
    }

    private String getAxeConfigure(boolean hasRunPartial) {
        String origins = !this.legacyMode && !hasRunPartial ? "'<unsafe_all_origins>'" : "'<same_origin>'";
        return String.format(";axe.configure({allowedOrigins: [%s], branding: { application: 'PlaywrightJava'}});", origins);
    }

    private void injectAxeSource(Frame frame) {
        try {
            frame.evaluate(AxeBuilder.getAxeScript() + this.getAxeConfigure(this.hasRunPartial));
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Unable to inject axe-source. ", runtimeException);
        }
    }

    public static String getAxeScript() {
        URL axeUrl = AxeBuilder.class.getResource("/axe.min.js");
        String axeSource = "";
        if (axeUrl != null) {
            try {
                axeSource = IOUtils.toString((InputStream)axeUrl.openStream(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to fetch node_modules/axe.min.js from resources. ", ioException);
            }
        }
        return axeSource;
    }

    private <T> String serialize(T obj) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalArgumentException("Unable to serialize object. ", jsonProcessingException);
        }
    }

    private AxeResults axeResultsErrors(Exception exception) {
        SimpleDateFormat df = new SimpleDateFormat("E MMM dd yyyy HH:mm:ss 'GMT'XX (zzzz)");
        String dateTime = df.format(new Date());
        AxeResults axeResults = new AxeResults();
        axeResults.setViolations(new ArrayList());
        axeResults.setPasses(new ArrayList());
        axeResults.setUrl("");
        axeResults.setTimestamp(dateTime);
        axeResults.setErrorMessage(exception);
        return axeResults;
    }
}

