/*
 * Decompiled with CFR 0.152.
 */
package com.demonwav.hypo.core;

import com.demonwav.hypo.core.DefaultClassDataDecorator;
import com.demonwav.hypo.model.ClassDataDecorator;
import com.demonwav.hypo.model.ClassDataProvider;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class HypoConfig {
    private final int parallelism;
    @NotNull
    private final Function<ClassDataProvider, ClassDataDecorator> decorator;

    HypoConfig(int parallelism, @NotNull Function<ClassDataProvider, ClassDataDecorator> decorator) {
        this.parallelism = parallelism;
        this.decorator = decorator;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    @NotNull
    public Function<ClassDataProvider, ClassDataDecorator> getDecorator() {
        return this.decorator;
    }

    @Contract(value="-> new ", pure=true)
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int parallelism = -1;
        @NotNull
        private Function<ClassDataProvider, ClassDataDecorator> decorator = DefaultClassDataDecorator::new;

        Builder() {
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder withParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder withDecorator(@NotNull Function<ClassDataProvider, ClassDataDecorator> decorator) {
            this.decorator = decorator;
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="-> new", pure=true)
        @NotNull
        public HypoConfig build() {
            return new HypoConfig(this.parallelism, this.decorator);
        }
    }
}

