/*
 * Decompiled with CFR 0.152.
 */
package com.sritraka.customservice;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.BatchResult;
import com.dell.doradus.common.DBObject;
import com.dell.doradus.common.DBObjectBatch;
import com.dell.doradus.common.HttpCode;
import com.dell.doradus.common.RESTResponse;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.search.SearchResult;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.service.Service;
import com.dell.doradus.service.StorageService;
import com.dell.doradus.service.rest.RESTCommand;
import com.dell.doradus.service.rest.RESTService;
import com.dell.doradus.service.rest.UNodeInCallback;
import com.dell.doradus.service.schema.SchemaService;
import com.dell.doradus.service.spider.SpiderService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class UpdateWhereService
extends Service {
    private static final UpdateWhereService INSTANCE = new UpdateWhereService();

    private UpdateWhereService() {
    }

    public static UpdateWhereService instance() {
        return INSTANCE;
    }

    @Override
    protected void initService() {
        List<RESTCommand> cmdList = Arrays.asList(new RESTCommand("PUT /{application}/{table}/_update?{params} com.sritraka.customservice.UpdateWhereService$UpdateWhereCmd"));
        RESTService.instance().registerApplicationCommands(cmdList, SpiderService.instance());
    }

    @Override
    protected void startService() {
    }

    @Override
    protected void stopService() {
    }

    public static class UpdateWhereCmd
    extends UNodeInCallback {
        @Override
        public RESTResponse invokeUNodeIn(UNode inNode) {
            ApplicationDefinition appDef = this.m_request.getAppDef();
            TableDefinition tableDef = this.m_request.getTableDef(appDef);
            String appName = appDef.getAppName();
            String tableName = tableDef.getTableName();
            StorageService storageService = SchemaService.instance().getStorageService(appDef);
            Utils.require((boolean)storageService.getClass().getSimpleName().equals("SpiderService"), (String)("Application must be a SpiderService application: " + appName));
            String params = this.m_request.getVariable("params");
            Map paramMap = Utils.parseURIQuery((String)params);
            Utils.require((boolean)paramMap.containsKey("q"), (String)"Missing URI parameter: q");
            Utils.require((paramMap.size() == 1 ? 1 : 0) != 0, (String)"Only the 'q' parameter is allowed");
            params = String.valueOf(params) + "&f=_ID&s=0";
            Utils.require((inNode != null ? 1 : 0) != 0, (String)"This command requires an input entity");
            DBObject modelObj = new DBObject();
            modelObj.parse(inNode);
            SearchResultList searchSet = SpiderService.instance().objectQueryURI(tableDef, params);
            DBObjectBatch dbObjBatch = new DBObjectBatch();
            for (SearchResult searchResult : searchSet.results) {
                dbObjBatch.addObject(modelObj.makeCopy(searchResult.id()));
            }
            BatchResult batchResult = SpiderService.instance().addBatch(appDef, tableName, dbObjBatch);
            String body = batchResult.toDoc().toString(this.m_request.getOutputContentType());
            return new RESTResponse(HttpCode.OK, body, this.m_request.getOutputContentType());
        }
    }
}

