/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.utilities;

import com.dell.doradus.utilities.Timer;

class TimerGroupItem {
    String m_name;
    Timer m_timer;
    int m_count;
    int m_value;
    boolean m_hasValue;
    int m_lastCount;
    int m_lastValue;
    long m_lastTime;

    TimerGroupItem(String name) {
        this.m_name = name;
        this.m_timer = new Timer();
    }

    public void start(long time) {
        ++this.m_count;
        this.m_timer.start(time);
    }

    public long stop(long time, int value) {
        this.m_value += value;
        this.m_hasValue = true;
        return this.m_timer.stop(time);
    }

    public long stop(long time) {
        return this.m_timer.stop(time);
    }

    boolean changed() {
        return this.m_hasValue && this.m_lastCount != this.m_count;
    }

    public String toString(boolean finalLog) {
        long time = this.m_timer.getElapsedTime();
        int count = this.m_count;
        int value = this.m_value;
        String text = !finalLog ? (this.m_hasValue ? String.format("%s: %s/%s (%d/%d) %d/%d", this.m_name, Timer.toString(time), Timer.toString(time - this.m_lastTime), count, count - this.m_lastCount, value, value - this.m_lastValue) : String.format("%s: %s/%s (%d/%d)", this.m_name, Timer.toString(time), Timer.toString(time - this.m_lastTime), count, count - this.m_lastCount)) : (this.m_hasValue ? String.format("%s: %s (%d) %d", this.m_name, Timer.toString(time), count, value) : String.format("%s: %s (%d)", this.m_name, Timer.toString(time), count));
        this.m_lastTime = time;
        this.m_lastCount = count;
        this.m_lastValue = value;
        return text;
    }
}

