/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.utilities;

import com.dell.doradus.utilities.Counter;
import com.dell.doradus.utilities.Timer;
import com.dell.doradus.utilities.TimerGroupItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerGroup {
    private boolean m_condition;
    private Logger m_logger;
    long m_startTime;
    long m_nextLog;
    long m_logIntervalNano;
    private TimerGroupItem m_total = new TimerGroupItem("TOTAL");
    HashMap<String, TimerGroupItem> m_timers = new HashMap();
    HashMap<String, Counter> m_counters = new HashMap();

    public TimerGroup(Logger logger, long logIntervalNano) {
        this.m_logger = logger;
        this.m_condition = this.m_logger.isDebugEnabled();
        this.m_logIntervalNano = logIntervalNano;
        this.m_startTime = System.nanoTime();
        this.m_nextLog = this.m_logIntervalNano == 0L ? Long.MAX_VALUE : this.m_startTime + this.m_logIntervalNano;
    }

    public TimerGroup(Logger logger) {
        this(logger, 0L);
    }

    public TimerGroup(String loggerName, long logIntervalNano) {
        this(LoggerFactory.getLogger((String)loggerName), logIntervalNano);
    }

    public TimerGroup(String loggerName) {
        this(LoggerFactory.getLogger((String)loggerName));
    }

    public void start(String name) {
        if (this.m_condition) {
            long time = System.nanoTime();
            this.start(time, name);
            this.checkLog(time);
        }
    }

    public void start(String name, String details) {
        if (this.m_condition) {
            long time = System.nanoTime();
            this.start(time, this.getDetailsName(name, details));
            this.checkLog(time);
        }
    }

    public long stop(String name) {
        if (this.m_condition) {
            long time = System.nanoTime();
            long elapsedTime = this.stop(time, name);
            this.checkLog(time);
            return elapsedTime;
        }
        return 0L;
    }

    public long stop(String name, int value) {
        if (this.m_condition) {
            long time = System.nanoTime();
            long elapsedTime = this.stop(time, name, value);
            this.checkLog(time);
            return elapsedTime;
        }
        return 0L;
    }

    public long stop(String name, String details) {
        if (this.m_condition) {
            long time = System.nanoTime();
            long elapsedTime = this.stop(time, this.getDetailsName(name, details));
            this.checkLog(time);
            return elapsedTime;
        }
        return 0L;
    }

    public long stop(String name, String details, int value) {
        if (this.m_condition) {
            long time = System.nanoTime();
            long elapsedTime = this.stop(time, this.getDetailsName(name, details), value);
            this.checkLog(time);
            return elapsedTime;
        }
        return 0L;
    }

    public void add(String name, int value) {
        if (this.m_condition) {
            Counter counter = this.m_counters.get(name = this.getName(name));
            if (counter == null) {
                counter = new Counter();
                this.m_counters.put(name, counter);
            }
            counter.add(value);
            this.checkLog(System.nanoTime());
        }
    }

    public void log(String format, Object ... args) {
        this.log(true, format, args);
    }

    public void log() {
        this.log(true, null, new Object[0]);
    }

    private void start(long time, String name) {
        TimerGroupItem timer = this.m_timers.get(name = this.getName(name));
        if (timer == null) {
            timer = new TimerGroupItem(name);
            this.m_timers.put(name, timer);
        }
        timer.start(time);
        this.m_total.start(time);
    }

    private String getDetailsName(String name, String details) {
        return String.valueOf(name) + " / " + details;
    }

    private String getName(String name) {
        return "(" + Thread.currentThread().getName() + ") " + name;
    }

    private long stop(long time, String name) {
        this.m_total.stop(time);
        TimerGroupItem timer = this.m_timers.get(this.getName(name));
        long elapsedTime = 0L;
        if (timer != null) {
            elapsedTime = timer.stop(time);
        }
        this.checkLog(time);
        return elapsedTime;
    }

    private long stop(long time, String name, int value) {
        this.m_total.stop(time);
        TimerGroupItem timer = this.m_timers.get(this.getName(name));
        long elapsedTime = 0L;
        if (timer != null) {
            elapsedTime = timer.stop(time, value);
        }
        this.checkLog(time);
        return elapsedTime;
    }

    private void log(boolean finalLog, String format, Object ... args) {
        if (this.m_condition) {
            if (format != null) {
                this.m_logger.debug(String.format(format, args));
            }
            ArrayList<String> timerNames = new ArrayList<String>(this.m_timers.keySet());
            Collections.sort(timerNames);
            for (String name : timerNames) {
                TimerGroupItem timer = this.m_timers.get(name);
                if (!finalLog && !timer.changed()) continue;
                this.m_logger.debug(timer.toString(finalLog));
            }
            this.m_logger.debug(this.m_total.toString(finalLog));
            ArrayList<String> counterNames = new ArrayList<String>(this.m_counters.keySet());
            Collections.sort(counterNames);
            for (String name : counterNames) {
                Counter counter = this.m_counters.get(name);
                if (!finalLog && !counter.changed()) continue;
                String text = String.format("%s: (%s)", name, counter.toString(finalLog));
                this.m_logger.debug(text);
            }
        }
    }

    private void checkLog(long time) {
        if (this.m_nextLog <= time) {
            this.log(false, "Intermediate timing ... %s (%s)", Timer.toString(time - this.m_startTime), Timer.toString(time - this.m_nextLog));
            this.m_nextLog = time + this.m_logIntervalNano;
        }
    }
}

