/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.utilities;

public class Timer {
    private long m_elapsedTime;
    private long m_startTime = System.nanoTime();
    private int m_nesting;

    public void start(long time) {
        if (this.m_nesting == 0) {
            this.m_startTime = time;
        }
        ++this.m_nesting;
    }

    public void start() {
        this.start(System.nanoTime());
    }

    public long stop(long time) {
        --this.m_nesting;
        if (this.m_nesting < 0) {
            this.m_nesting = 0;
        }
        if (this.m_nesting == 0) {
            long elapsedTime = time - this.m_startTime;
            this.m_elapsedTime += elapsedTime;
            return elapsedTime;
        }
        return 0L;
    }

    public long stop() {
        return this.stop(System.nanoTime());
    }

    public static String toString(long elapsedTime) {
        elapsedTime = (elapsedTime + 500000L) / 1000000L;
        return String.format("%d.%03d sec", elapsedTime / 1000L, elapsedTime % 1000L);
    }

    public String toString() {
        return Timer.toString(this.getElapsedTime());
    }

    public long getElapsedTime() {
        if (this.m_nesting > 0 || this.m_elapsedTime == 0L) {
            return this.m_elapsedTime + System.nanoTime() - this.m_startTime;
        }
        return this.m_elapsedTime;
    }
}

