/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.utilities;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class MemoryAppender
extends AppenderSkeleton {
    private static Object m_sync = new Object();
    private static List<LoggingEvent> m_current = new ArrayList<LoggingEvent>(20000);
    private static List<LoggingEvent> m_backup = new ArrayList<LoggingEvent>(20000);
    private static Layout m_layout;
    private int m_capacity = 20000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int capacity) {
        this.m_capacity = capacity;
        Object object = m_sync;
        synchronized (object) {
            m_current = new ArrayList<LoggingEvent>(this.m_capacity);
            m_backup = new ArrayList<LoggingEvent>(this.m_capacity);
        }
    }

    public int getCapacity() {
        return this.m_capacity;
    }

    public void activateOptions() {
        m_layout = this.layout;
        super.activateOptions();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public boolean requiresLayout() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        Object object = m_sync;
        synchronized (object) {
            if (m_current.size() > this.m_capacity) {
                List<LoggingEvent> temp = m_current;
                m_current = m_backup;
                m_backup = temp;
                m_current.clear();
            }
            m_current.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLog(String level) {
        Level lvl = level == null ? Level.DEBUG : Level.toLevel((String)level);
        StringBuilder sb = new StringBuilder();
        Object object = m_sync;
        synchronized (object) {
            String log;
            for (LoggingEvent event : m_backup) {
                if (event.getLevel().toInt() < lvl.toInt()) continue;
                log = m_layout.format(event);
                sb.append(log);
            }
            sb.append("\n");
            for (LoggingEvent event : m_current) {
                if (event.getLevel().toInt() < lvl.toInt()) continue;
                log = m_layout.format(event);
                sb.append(log);
            }
            return sb.toString();
        }
    }
}

