/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.utilities;

import com.dell.doradus.olap.io.BSTR;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class FOutputStream {
    private static final int BUFFER_SIZE = 131072;
    private FileOutputStream m_output;
    private byte[] m_buffer = new byte[131072];
    private long m_buffersCount;
    private int m_positionInBuffer;
    private BSTR m_cur = new BSTR();

    public FOutputStream(String fileName) {
        try {
            File file = new File(fileName);
            this.m_output = new FileOutputStream(file);
            this.m_buffersCount = 0L;
            this.m_positionInBuffer = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long position() {
        return this.m_buffersCount * (long)this.m_buffer.length + (long)this.m_positionInBuffer;
    }

    public void close() {
        if (this.m_positionInBuffer != 0) {
            this.writeBuffer();
        }
        try {
            this.m_output.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeBuffer() {
        try {
            this.m_output.write(this.m_buffer, 0, this.m_positionInBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ++this.m_buffersCount;
        this.m_positionInBuffer = 0;
    }

    public void writeByte(byte value) {
        this.m_buffer[this.m_positionInBuffer++] = value;
        if (this.m_positionInBuffer == this.m_buffer.length) {
            this.writeBuffer();
        }
    }

    public void write(byte[] buffer, int offset, int count) {
        while (count > 0) {
            int toCopy = Math.min(this.m_buffer.length - this.m_positionInBuffer, count);
            System.arraycopy(buffer, offset, this.m_buffer, this.m_positionInBuffer, toCopy);
            this.m_positionInBuffer += toCopy;
            count -= toCopy;
            offset += toCopy;
            if (this.m_positionInBuffer != this.m_buffer.length) continue;
            this.writeBuffer();
        }
    }

    public void writeVInt(int value) {
        int u = value >>> 7;
        while (u != 0) {
            this.writeByte((byte)(value & 0x7F | 0x80));
            value = u;
            u >>>= 7;
        }
        this.writeByte((byte)value);
    }

    public void writeVLong(long value) {
        long u = value >>> 7;
        while (u != 0L) {
            this.writeByte((byte)(value & 0x7FL | 0x80L));
            value = u;
            u >>>= 7;
        }
        this.writeByte((byte)value);
    }

    public void writeInt(int value) {
        int u = value;
        this.writeByte((byte)u);
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
    }

    public void writeLong(long value) {
        long u = value;
        this.writeByte((byte)u);
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        u >>>= 8;
    }

    public void write(BSTR bstr) {
        this.writeVInt(bstr.length);
        this.write(bstr.buffer, 0, bstr.length);
    }

    public void writeVString(BSTR bstr) {
        int pfx = 0;
        int len = Math.min(this.m_cur.length, bstr.length);
        while (pfx < len && this.m_cur.buffer[pfx] == bstr.buffer[pfx]) {
            ++pfx;
        }
        this.writeVInt(pfx);
        this.writeVInt(bstr.length - pfx);
        this.write(bstr.buffer, pfx, bstr.length - pfx);
        this.m_cur.assertLength(bstr.length);
        System.arraycopy(bstr.buffer, pfx, this.m_cur.buffer, pfx, bstr.length - pfx);
        this.m_cur.length = bstr.length;
    }

    public void writeString(String str) {
        BSTR bstr = new BSTR(str);
        this.write(bstr);
    }
}

