/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.utilities;

import com.dell.doradus.olap.io.BSTR;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FInputStream {
    private static final int BUFFER_SIZE = 131072;
    private FileInputStream m_input;
    private long m_length;
    private byte[] m_buffer = new byte[131072];
    private long m_buffersCount;
    private long m_bufferNumber;
    private int m_bufferLength;
    private int m_positionInBuffer;

    public FInputStream(String fileName) {
        try {
            File file = new File(fileName);
            this.m_input = new FileInputStream(file);
            this.m_length = file.length();
            this.m_buffersCount = (this.m_length + 131072L - 1L) / 131072L;
            this.m_bufferNumber = -1L;
            this.m_bufferLength = 0;
            this.m_positionInBuffer = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.m_input.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long length() {
        return this.m_length;
    }

    public long position() {
        return this.m_bufferNumber < 0L ? 0L : this.m_bufferNumber * 131072L + (long)this.m_positionInBuffer;
    }

    public boolean end() {
        return this.m_positionInBuffer == this.m_bufferLength && this.m_bufferNumber == this.m_buffersCount - 1L || this.m_positionInBuffer == 0 && this.m_bufferNumber == this.m_buffersCount;
    }

    public void seek(long position) {
        if (position == this.m_length && this.m_length == this.m_buffersCount * 131072L) {
            this.m_positionInBuffer = 0;
            this.m_bufferLength = 0;
            this.m_bufferNumber = this.m_buffersCount;
        } else {
            long bufferNumber = position / 131072L;
            this.readBuffer(bufferNumber);
            this.m_positionInBuffer = (int)(position % 131072L);
            if (this.m_positionInBuffer > this.m_bufferLength) {
                throw new RuntimeException("End of stream");
            }
        }
    }

    private void readBuffer(long bufferNumber) {
        if (this.m_bufferNumber == bufferNumber) {
            return;
        }
        if (bufferNumber < 0L || bufferNumber >= this.m_buffersCount) {
            throw new RuntimeException("End of stream");
        }
        this.m_bufferNumber = bufferNumber;
        try {
            this.m_bufferLength = this.m_input.read(this.m_buffer, 0, this.m_buffer.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.m_positionInBuffer = 0;
    }

    public int read(byte[] buffer, int offset, int count) {
        int cnt = count;
        while (count > 0) {
            if (this.m_positionInBuffer == this.m_bufferLength) {
                this.readBuffer(this.m_bufferNumber + 1L);
            }
            int toRead = Math.min(this.m_bufferLength - this.m_positionInBuffer, count);
            System.arraycopy(this.m_buffer, this.m_positionInBuffer, buffer, offset, toRead);
            count -= toRead;
            this.m_positionInBuffer += toRead;
            offset += toRead;
        }
        return cnt;
    }

    public int readByte() {
        if (this.m_positionInBuffer == this.m_bufferLength) {
            this.readBuffer(this.m_bufferNumber + 1L);
        }
        return this.m_buffer[this.m_positionInBuffer++] & 0xFF;
    }

    public int readVInt() {
        int b = this.readByte();
        int u = b & 0x7F;
        int shift = 7;
        while (b > 127) {
            b = this.readByte();
            u += (b & 0x7F) << shift;
            shift += 7;
        }
        return u;
    }

    public long readVLong() {
        long b = this.readByte();
        long u = b & 0x7FL;
        int shift = 7;
        while (b > 127L) {
            b = this.readByte();
            u += (b & 0x7FL) << shift;
            shift += 7;
        }
        return u;
    }

    public int readInt() {
        int u = this.readByte() | this.readByte() << 8 | this.readByte() << 16 | this.readByte() << 24;
        return u;
    }

    public long readLong() {
        long u = (long)this.readByte() | (long)this.readByte() << 8 | (long)this.readByte() << 16 | (long)this.readByte() << 24 | (long)this.readByte() << 32 | (long)this.readByte() << 40 | (long)this.readByte() << 48 | (long)this.readByte() << 56;
        return u;
    }

    public void read(BSTR bstr) {
        bstr.length = this.readVInt();
        bstr.assertLength(bstr.length);
        this.read(bstr.buffer, 0, bstr.length);
    }

    public String readString() {
        int i = this.readVInt();
        byte[] b = new byte[i];
        this.read(b, 0, i);
        BSTR bstr = new BSTR(b);
        return bstr.toString();
    }

    public void readVString(BSTR bstr) {
        if (bstr.length < 0) {
            bstr.length = 0;
        }
        int pfx = this.readVInt();
        int len = this.readVInt();
        bstr.length = pfx + len;
        bstr.assertLength(bstr.length);
        this.read(bstr.buffer, pfx, len);
    }
}

