/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.utilities;

import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.search.util.HeapSort;
import com.dell.doradus.utilities.BigSetReader;
import com.dell.doradus.utilities.FOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BigSetWriter {
    private int m_cacheSize;
    private String m_filePrefix;
    private int m_nextNo = 1;
    private List<BSTR> m_list;

    public BigSetWriter(String fileName, int cacheSize) {
        this.m_cacheSize = cacheSize;
        if (new File(fileName).exists()) {
            new File(fileName).delete();
        }
        int num = 1;
        while (new File(String.valueOf(fileName) + "_" + num).exists()) {
            new File(String.valueOf(fileName) + "_" + num).delete();
            ++num;
        }
        this.m_filePrefix = fileName;
        this.m_list = new ArrayList<BSTR>(this.m_cacheSize);
    }

    public void add(byte[] value) {
        this.add(new BSTR(value));
    }

    public void add(String value) {
        this.add(new BSTR(value));
    }

    public void add(BSTR value) {
        if (this.m_list.size() >= this.m_cacheSize) {
            this.flushPartial();
        }
        this.m_list.add(value);
    }

    private void flushPartial() {
        FOutputStream output = new FOutputStream(String.valueOf(this.m_filePrefix) + "_" + this.m_nextNo);
        Collections.sort(this.m_list);
        for (BSTR val : this.m_list) {
            output.writeVString(val);
        }
        output.close();
        ++this.m_nextNo;
        this.m_list.clear();
    }

    public void close() {
        if (this.m_list.size() > 0) {
            this.flushPartial();
        }
        HeapSort<BSTR> heapSort = new HeapSort<BSTR>();
        int i = 1;
        while (i < this.m_nextNo) {
            heapSort.add(new BigSetReader(String.valueOf(this.m_filePrefix) + "_" + i));
            ++i;
        }
        BSTR last = new BSTR();
        last.length = -1;
        FOutputStream output = new FOutputStream(this.m_filePrefix);
        for (BSTR val : heapSort) {
            if (last.equals(val)) continue;
            output.writeVString(val);
            last.set(val);
        }
        output.close();
        int i2 = 1;
        while (i2 < this.m_nextNo) {
            new File(String.valueOf(this.m_filePrefix) + "_" + i2).delete();
            ++i2;
        }
    }
}

