/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.utilities;

import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.search.util.HeapSort;
import com.dell.doradus.utilities.FInputStream;
import com.dell.doradus.utilities.FOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BigSet
implements Iterable<BSTR> {
    private Status m_status = Status.NONE;
    private final int m_cacheSize;
    private final String m_fileName;
    private int m_nextNo = 1;
    private List<BSTR> m_list;

    public BigSet(String fileName, int cacheSize) {
        this.m_fileName = fileName;
        this.m_cacheSize = cacheSize;
    }

    @Override
    public Iterator<BSTR> iterator() {
        this.openRead();
        return new BigSetIterator();
    }

    public void add(byte[] value) {
        this.add(new BSTR(value));
    }

    public void add(String value) {
        this.add(new BSTR(value));
    }

    public void add(BSTR value) {
        this.openWrite();
        if (this.m_list.size() >= this.m_cacheSize) {
            this.flushPartial();
        }
        this.m_list.add(value);
    }

    public void close() {
        if (this.m_list.size() > 0) {
            this.flushPartial();
        }
    }

    public void delete() {
        int i = 1;
        while (i < this.m_nextNo) {
            new File(String.valueOf(this.m_fileName) + "_" + i).delete();
            ++i;
        }
        this.m_nextNo = 1;
    }

    private void flushPartial() {
        FOutputStream output = new FOutputStream(String.valueOf(this.m_fileName) + "_" + this.m_nextNo);
        Collections.sort(this.m_list);
        for (BSTR val : this.m_list) {
            output.writeVString(val);
        }
        output.close();
        ++this.m_nextNo;
        this.m_list.clear();
    }

    private void openWrite() {
        if (this.m_status != Status.WRITE) {
            if (this.m_status == Status.READ) {
                this.delete();
            }
            this.m_list = new ArrayList<BSTR>(this.m_cacheSize);
            this.m_status = Status.WRITE;
        }
    }

    private void openRead() {
        if (this.m_status == Status.WRITE) {
            this.close();
        }
        this.m_status = Status.READ;
    }

    public static class BSTRFileIterable
    implements Iterable<BSTR> {
        final String m_fileName;

        public BSTRFileIterable(String fileName) {
            this.m_fileName = fileName;
        }

        @Override
        public Iterator<BSTR> iterator() {
            return new BSTRFileIterator(this.m_fileName);
        }

        public static class BSTRFileIterator
        implements Iterator<BSTR> {
            private FInputStream m_input;
            private BSTR m_bstr = new BSTR();

            public BSTRFileIterator(String fileName) {
                this.m_input = new FInputStream(fileName);
            }

            public void close() {
                this.m_input.close();
            }

            @Override
            public boolean hasNext() {
                if (this.m_input == null) {
                    return false;
                }
                if (this.m_input.end()) {
                    this.m_input.close();
                    this.m_input = null;
                    return false;
                }
                return true;
            }

            @Override
            public BSTR next() {
                this.m_input.readVString(this.m_bstr);
                return new BSTR(this.m_bstr);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        }
    }

    private class BigSetIterator
    implements Iterator<BSTR> {
        BSTR m_last = null;
        Iterator<BSTR> m_iterator;

        public BigSetIterator() {
            HeapSort<BSTR> heapSort = new HeapSort<BSTR>();
            int i = 1;
            while (i < BigSet.this.m_nextNo) {
                heapSort.add(new BSTRFileIterable(String.valueOf(BigSet.this.m_fileName) + "_" + i));
                ++i;
            }
            for (BSTR next : heapSort) {
                if (next.equals(this.m_last)) continue;
                this.m_last = next;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_last != null;
        }

        @Override
        public BSTR next() {
            BSTR result = this.m_last;
            while (this.m_iterator.hasNext()) {
                BSTR next = this.m_iterator.next();
                if (next.equals(result)) continue;
                this.m_last = next;
                return result;
            }
            this.m_last = null;
            return result;
        }

        @Override
        public void remove() {
            throw new RuntimeException("remove not supported");
        }
    }

    private static enum Status {
        READ,
        WRITE,
        NONE;

    }
}

