/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.tenant;

import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class UserDefinition {
    private String m_userID;
    private String m_password;
    private final Set<Permission> m_permissions = new HashSet<Permission>();

    public UserDefinition() {
    }

    public UserDefinition(String userID) {
        this.m_userID = userID;
    }

    public String getID() {
        return this.m_userID;
    }

    public String getPassword() {
        return this.m_password;
    }

    public Set<Permission> getPermissions() {
        return Collections.unmodifiableSet(this.m_permissions);
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void addPermission(Permission permission) {
        this.m_permissions.add(permission);
    }

    public void setPermissions(Set<Permission> permissions) {
        this.m_permissions.clear();
        this.m_permissions.addAll(permissions);
    }

    public UserDefinition makeCopy(String newUserID) {
        UserDefinition newUserDef = new UserDefinition(newUserID);
        newUserDef.setPassword(this.m_password);
        newUserDef.setPermissions(this.m_permissions);
        return newUserDef;
    }

    public void parse(UNode userNode) {
        this.m_userID = userNode.getName();
        this.m_password = null;
        this.m_permissions.clear();
        block10: for (String childName : userNode.getMemberNames()) {
            UNode childNode = userNode.getMember(childName);
            switch (childNode.getName()) {
                case "password": {
                    Utils.require((boolean)childNode.isValue(), (String)("'password' must be a simple value: " + childNode));
                    this.m_password = childNode.getValue();
                    break;
                }
                case "permissions": {
                    String[] permissions;
                    Utils.require((boolean)childNode.isValue(), (String)("'permissions' must be a list of values: " + childNode));
                    String[] stringArray = permissions = childNode.getValue().split(",");
                    int n = permissions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String permission = stringArray[n2];
                        String permToken = permission.toUpperCase().trim();
                        try {
                            this.m_permissions.add(Permission.valueOf(permToken));
                        }
                        catch (IllegalArgumentException e) {
                            Utils.require((boolean)false, (String)"Unrecognized permission: %s; allowed values are: %s", (Object[])new Object[]{permToken, Arrays.asList(Permission.values()).toString()});
                        }
                        ++n2;
                    }
                    continue block10;
                }
                default: {
                    Utils.require((boolean)false, (String)("Unknown 'user' property: " + childNode));
                }
            }
        }
    }

    public UNode toDoc() {
        UNode userNode = UNode.createMapNode((String)this.m_userID, (String)"user");
        if (!Utils.isEmpty((String)this.m_password)) {
            userNode.addValueNode("password", this.m_password, true);
        }
        String permissions = "ALL";
        if (this.m_permissions.size() > 0) {
            permissions = Utils.concatenate(this.m_permissions, (String)",");
        }
        userNode.addValueNode("permissions", permissions);
        return userNode;
    }

    public static enum Permission {
        ALL,
        APPEND,
        UPDATE,
        READ;

    }
}

