/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.tenant;

import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.Service;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DuplicateException;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.db.UnauthorizedException;
import com.dell.doradus.service.rest.NotFoundException;
import com.dell.doradus.service.rest.RESTCommand;
import com.dell.doradus.service.rest.RESTService;
import com.dell.doradus.service.tenant.TenantDefinition;
import com.dell.doradus.service.tenant.UserDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class TenantService
extends Service {
    private static final TenantService INSTANCE = new TenantService();
    private static final String TENANT_ROW_KEY = "_tenant";
    private static final String TENANT_DEF_COL_NAME = "Definition";
    private final Map<String, TenantDefinition> m_tenantMap = new HashMap<String, TenantDefinition>();
    private static final List<RESTCommand> REST_RULES = Arrays.asList(new RESTCommand("GET    /_tenants           com.dell.doradus.service.tenant.ListTenantsCmd", true), new RESTCommand("GET    /_tenants/{tenant}  com.dell.doradus.service.tenant.ListTenantCmd", true), new RESTCommand("POST   /_tenants           com.dell.doradus.service.tenant.DefineTenantCmd", true), new RESTCommand("PUT    /_tenants/{tenant}  com.dell.doradus.service.tenant.ModifyTenantCmd", true), new RESTCommand("DELETE /_tenants/{tenant}  com.dell.doradus.service.tenant.DeleteTenantCmd", true));

    private TenantService() {
    }

    public static TenantService instance() {
        return INSTANCE;
    }

    @Override
    protected void initService() {
        if (ServerConfig.getInstance().multitenant_mode && !ServerConfig.getInstance().use_cql) {
            throw new RuntimeException("Multitenant_mode currently requires use_cql=true");
        }
        RESTService.instance().registerGlobalCommands(REST_RULES);
    }

    @Override
    protected void startService() {
        DBService.instance().waitForFullService();
        this.refreshTenantMap();
    }

    @Override
    protected void stopService() {
    }

    public Collection<Tenant> getTenants() {
        this.checkServiceState();
        ArrayList<Tenant> result = new ArrayList<Tenant>();
        for (String tenantName : this.m_tenantMap.keySet()) {
            result.add(new Tenant(tenantName));
        }
        return result;
    }

    public TenantDefinition getTenantDefinition(String tenantName) {
        this.checkServiceState();
        Utils.require((boolean)ServerConfig.getInstance().multitenant_mode, (String)"This command is not valid in single-tenant mode");
        return this.getTenantDefFromCache(tenantName);
    }

    public void createDefaultTenant() {
        this.checkServiceState();
        DBService dbService = DBService.instance();
        Tenant tenant = new Tenant(ServerConfig.getInstance().keyspace);
        dbService.createTenant(tenant, null);
        dbService.createStoreIfAbsent(tenant, "Applications", false);
        dbService.createStoreIfAbsent(tenant, "Tasks", false);
    }

    public TenantDefinition defineTenant(TenantDefinition tenantDef) {
        this.checkServiceState();
        Utils.require((boolean)ServerConfig.getInstance().multitenant_mode, (String)"This command is not valid in single-tenant mode");
        String tenantName = tenantDef.getName();
        if (this.getTenantDefFromCache(tenantName) != null) {
            throw new DuplicateException("Tenant already exists: " + tenantName);
        }
        Utils.require((!tenantName.equals(ServerConfig.getInstance().keyspace) ? 1 : 0) != 0, (String)("Cannot create a tenant with the default keyspace name: " + tenantName));
        this.defineNewTenant(tenantDef);
        TenantDefinition updatedTenantDef = this.getTenantDefFromCache(tenantName);
        if (updatedTenantDef == null) {
            throw new RuntimeException("Tenant definition could not be retrieved after creation: " + tenantName);
        }
        return updatedTenantDef;
    }

    public TenantDefinition modifyTenant(String tenantName, TenantDefinition newTenantDef) {
        this.checkServiceState();
        Utils.require((boolean)ServerConfig.getInstance().multitenant_mode, (String)"This command is not valid in single-tenant mode");
        TenantDefinition oldTenantDef = this.getTenantDefFromCache(tenantName);
        Utils.require((oldTenantDef != null ? 1 : 0) != 0, (String)"Tenant '%s' does not exist", (Object[])new Object[]{tenantName});
        this.modifyTenantProperties(oldTenantDef, newTenantDef);
        this.validateTenantUpdate(oldTenantDef, newTenantDef);
        this.modifyTenantDefinition(oldTenantDef, newTenantDef);
        TenantDefinition updatedTenantDef = this.getTenantDefFromCache(tenantName);
        if (updatedTenantDef == null) {
            throw new RuntimeException("Tenant definition could not be retrieved after creation: " + tenantName);
        }
        return updatedTenantDef;
    }

    private void modifyTenantProperties(TenantDefinition oldTenantDef, TenantDefinition newTenantDef) {
        if (newTenantDef.getProperties().get("_CreatedOn") == null && oldTenantDef.getProperties().get("_CreatedOn") != null) {
            newTenantDef.setProperty("_CreatedOn", oldTenantDef.getProperties().get("_CreatedOn"));
        }
    }

    public void deleteTenant(String tenantName) {
        this.checkServiceState();
        Utils.require((boolean)ServerConfig.getInstance().multitenant_mode, (String)"This command is not valid in single-tenant mode");
        TenantDefinition tenantDef = this.getTenantDefFromCache(tenantName);
        if (tenantDef == null) {
            return;
        }
        Tenant tenant = new Tenant(tenantName);
        DBService.instance().dropTenant(tenant);
        this.deleteTenantFromCache(tenantName);
        this.deleteAllUsers(tenantDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TenantDefinition searchForTenant(TenantFilter filter) {
        this.checkServiceState();
        Map<String, TenantDefinition> map = this.m_tenantMap;
        synchronized (map) {
            for (int attempt = 1; attempt <= 2; ++attempt) {
                for (TenantDefinition tenantDef : this.m_tenantMap.values()) {
                    if (!filter.selectTenant(tenantDef)) continue;
                    return tenantDef;
                }
                this.refreshTenantMap();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tenantExists(Tenant tenant) {
        this.checkServiceState();
        Map<String, TenantDefinition> map = this.m_tenantMap;
        synchronized (map) {
            if (this.m_tenantMap.keySet().contains(tenant.getKeyspace())) {
                return true;
            }
            this.refreshTenantMap();
            return this.m_tenantMap.keySet().contains(tenant.getKeyspace());
        }
    }

    public boolean isDefaultTenant(Tenant tenant) {
        return tenant.getKeyspace().equals(ServerConfig.getInstance().keyspace);
    }

    public void validateTenantAuthorization(Tenant tenant, String userid, String password, RESTCommand cmd) throws UnauthorizedException, NotFoundException {
        if (ServerConfig.getInstance().multitenant_mode) {
            if (!this.tenantExists(tenant)) {
                throw new NotFoundException("Unknown tenant: " + tenant);
            }
            if (cmd.isPrivileged()) {
                if (!this.isValidSystemCredentials(userid, password)) {
                    throw new UnauthorizedException("Unrecognized system user id/password");
                }
            } else if (this.isDefaultTenant(tenant)) {
                if (ServerConfig.getInstance().disable_default_keyspace) {
                    throw new UnauthorizedException("Access to the default tenant is disabled");
                }
            } else {
                this.checkServiceState();
                if (!this.isValidTenantUserAccess(tenant.getKeyspace(), userid, password, cmd.getMethod())) {
                    throw new UnauthorizedException("Invalid tenant credentials or insufficient permission");
                }
            }
        } else if (!this.isDefaultTenant(tenant)) {
            throw new UnauthorizedException("This command is not valid in single-tenant mode");
        }
    }

    public Tenant getDefaultTenant() {
        return new Tenant(ServerConfig.getInstance().keyspace);
    }

    private void defineNewTenant(TenantDefinition tenantDef) {
        DBService dbService = DBService.instance();
        Tenant tenant = new Tenant(tenantDef.getName());
        dbService.createTenant(tenant, tenantDef.getOptions());
        this.addTenantUsers(tenantDef);
        this.addTenantProperties(tenantDef);
        dbService.createStoreIfAbsent(tenant, "Applications", false);
        dbService.createStoreIfAbsent(tenant, "Tasks", false);
        this.storeTenantDefinition(tenantDef);
    }

    private void addTenantProperties(TenantDefinition tenantDef) {
        tenantDef.setProperty("_CreatedOn", Utils.formatDate((long)new Date().getTime()));
    }

    private void addTenantUsers(TenantDefinition tenantDef) {
        if (tenantDef.userCount() == 0) {
            this.addDefaultUser(tenantDef);
        }
        String tenantName = tenantDef.getName();
        Tenant tenant = new Tenant(tenantName);
        ArrayList<UserDefinition> dbUserList = new ArrayList<UserDefinition>();
        for (UserDefinition userDef : tenantDef.getUsers().values()) {
            Utils.require((!Utils.isEmpty((String)userDef.getPassword()) ? 1 : 0) != 0, (String)("Password is required; user ID=" + userDef.getID()));
            String newUserID = tenantName + "_" + userDef.getID();
            UserDefinition dbUserDef = userDef.makeCopy(newUserID);
            dbUserList.add(dbUserDef);
        }
        DBService.instance().addUsers(tenant, dbUserList);
    }

    private void addDefaultUser(TenantDefinition tenantDef) {
        UserDefinition userDef = new UserDefinition("U" + this.generateRandomID());
        userDef.setPassword(this.generateRandomID());
        tenantDef.addUser(userDef);
    }

    private String generateRandomID() {
        return Long.toString(Math.abs(new Random().nextLong()), 36);
    }

    private void storeTenantDefinition(TenantDefinition tenantDef) {
        Tenant tenant = new Tenant(tenantDef.getName());
        String tenantDefJSON = tenantDef.toDoc().toJSON();
        DBTransaction dbTran = DBService.instance().startTransaction(tenant);
        dbTran.addColumn("Applications", TENANT_ROW_KEY, TENANT_DEF_COL_NAME, tenantDefJSON);
        DBService.instance().commit(dbTran);
        this.updateCache(tenantDef);
    }

    private boolean isValidSystemCredentials(String userid, String password) {
        return userid.equals(ServerConfig.getInstance().dbuser) && password.equals(ServerConfig.getInstance().dbpassword);
    }

    private boolean isValidTenantUserAccess(String tenantName, String userid, String password, String method) {
        UserDefinition userDef;
        if (this.isValidSystemCredentials(userid, password)) {
            return true;
        }
        TenantDefinition tenantDef = this.getTenantDefFromCache(tenantName);
        if (tenantDef != null && (userDef = tenantDef.getUser(userid)) != null && userDef.getPassword().equals(password)) {
            return this.isValidUserAccess(userDef, method);
        }
        return false;
    }

    private boolean isValidUserAccess(UserDefinition userDef, String method) {
        Set<UserDefinition.Permission> permList = userDef.getPermissions();
        if (permList.size() == 0 || permList.contains((Object)UserDefinition.Permission.ALL)) {
            return true;
        }
        switch (method.toUpperCase()) {
            case "GET": {
                return permList.contains((Object)UserDefinition.Permission.READ);
            }
            case "POST": {
                return permList.contains((Object)UserDefinition.Permission.APPEND) || permList.contains((Object)UserDefinition.Permission.UPDATE);
            }
            case "DELETE": 
            case "PUT": {
                return permList.contains((Object)UserDefinition.Permission.UPDATE);
            }
        }
        throw new RuntimeException("Unexpected 'method': " + method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache(TenantDefinition tenantDef) {
        Map<String, TenantDefinition> map = this.m_tenantMap;
        synchronized (map) {
            this.m_tenantMap.put(tenantDef.getName(), tenantDef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TenantDefinition getTenantDefFromCache(String tenantName) {
        TenantDefinition tenantDef = null;
        Map<String, TenantDefinition> map = this.m_tenantMap;
        synchronized (map) {
            tenantDef = this.m_tenantMap.get(tenantName);
            if (tenantDef == null) {
                this.refreshTenantMap();
                tenantDef = this.m_tenantMap.get(tenantName);
            }
        }
        return tenantDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTenantMap() {
        Map<String, TenantDefinition> map = this.m_tenantMap;
        synchronized (map) {
            this.m_tenantMap.clear();
            for (Tenant tenant : DBService.instance().getTenants()) {
                TenantDefinition tenantDef = null;
                if (tenant.getKeyspace().equals(ServerConfig.getInstance().keyspace)) {
                    tenantDef = new TenantDefinition();
                    tenantDef.setName(tenant.getKeyspace());
                } else {
                    tenantDef = this.loadTenantDefinition(tenant);
                }
                if (tenantDef == null) continue;
                this.m_tenantMap.put(tenantDef.getName(), tenantDef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTenantFromCache(String tenantName) {
        Map<String, TenantDefinition> map = this.m_tenantMap;
        synchronized (map) {
            this.m_tenantMap.remove(tenantName);
        }
    }

    private TenantDefinition loadTenantDefinition(Tenant tenant) {
        this.m_logger.debug("Loading definition for tenant: {}", (Object)tenant.getKeyspace());
        DColumn tenantDefCol = DBService.instance().getColumn(tenant, "Applications", TENANT_ROW_KEY, TENANT_DEF_COL_NAME);
        if (tenantDefCol == null) {
            return null;
        }
        String tenantDefJSON = tenantDefCol.getValue();
        TenantDefinition tenantDef = new TenantDefinition();
        try {
            tenantDef.parse(UNode.parseJSON((String)tenantDefJSON));
        }
        catch (Exception e) {
            this.m_logger.warn("Skipping malformed tenant definition; tenant=" + tenant.getKeyspace(), (Throwable)e);
            return null;
        }
        return tenantDef;
    }

    private void validateTenantUpdate(TenantDefinition oldTenantDef, TenantDefinition newTenantDef) {
        Utils.require((boolean)oldTenantDef.getName().equals(newTenantDef.getName()), (String)"Tenant name cannot be changed: %s", (Object[])new Object[]{newTenantDef.getName()});
        Utils.require((boolean)oldTenantDef.getProperties().get("_CreatedOn").equals(newTenantDef.getProperties().get("_CreatedOn")), (String)"Tenant _CreatedOn property cannot be changed: %s", (Object[])new Object[]{newTenantDef.getProperties().get("_CreatedOn")});
    }

    private void modifyTenantDefinition(TenantDefinition oldTenantDef, TenantDefinition newTenantDef) {
        this.modifyTenantOptions(oldTenantDef, newTenantDef);
        this.modifyTenantUsers(oldTenantDef, newTenantDef);
        this.storeTenantDefinition(newTenantDef);
    }

    private void modifyTenantOptions(TenantDefinition oldTenantDef, TenantDefinition newTenantDef) {
        Map<String, String> newOptions;
        Tenant tenant = new Tenant(oldTenantDef.getName());
        Map<String, String> oldOptions = oldTenantDef.getOptions();
        if (!TenantService.sameProperties(oldOptions, newOptions = newTenantDef.getOptions())) {
            DBService.instance().modifyTenant(tenant, newOptions);
        }
    }

    private void modifyTenantUsers(TenantDefinition oldTenantDef, TenantDefinition newTenantDef) {
        this.deleteObsoleteUsers(oldTenantDef, newTenantDef);
        this.addNewUsers(oldTenantDef, newTenantDef);
        this.modifyUpdatedUsers(oldTenantDef, newTenantDef);
    }

    private void deleteObsoleteUsers(TenantDefinition oldTenantDef, TenantDefinition newTenantDef) {
        String tenantName = oldTenantDef.getName();
        Tenant tenant = new Tenant(tenantName);
        ArrayList<UserDefinition> deletedUsers = new ArrayList<UserDefinition>();
        for (UserDefinition userDef : oldTenantDef.getUsers().values()) {
            if (newTenantDef.getUser(userDef.getID()) != null) continue;
            String userID = tenantName + "_" + userDef.getID();
            UserDefinition dbUserDef = userDef.makeCopy(userID);
            deletedUsers.add(dbUserDef);
        }
        if (deletedUsers.size() > 0) {
            DBService.instance().deleteUsers(tenant, deletedUsers);
        }
    }

    private void addNewUsers(TenantDefinition oldTenantDef, TenantDefinition newTenantDef) {
        String tenantName = oldTenantDef.getName();
        Tenant tenant = new Tenant(tenantName);
        ArrayList<UserDefinition> newUsers = new ArrayList<UserDefinition>();
        for (UserDefinition userDef : newTenantDef.getUsers().values()) {
            if (oldTenantDef.getUser(userDef.getID()) != null) continue;
            Utils.require((!Utils.isEmpty((String)userDef.getPassword()) ? 1 : 0) != 0, (String)("Password is required for new users; user ID=" + userDef.getID()));
            String userID = tenantName + "_" + userDef.getID();
            UserDefinition dbUserDef = userDef.makeCopy(userID);
            newUsers.add(dbUserDef);
        }
        if (newUsers.size() > 0) {
            DBService.instance().addUsers(tenant, newUsers);
        }
    }

    private void modifyUpdatedUsers(TenantDefinition oldTenantDef, TenantDefinition newTenantDef) {
        String tenantName = oldTenantDef.getName();
        Tenant tenant = new Tenant(tenantName);
        ArrayList<UserDefinition> modifiedUsers = new ArrayList<UserDefinition>();
        for (UserDefinition userDef : newTenantDef.getUsers().values()) {
            UserDefinition oldUserDef = oldTenantDef.getUser(userDef.getID());
            if (oldUserDef == null) continue;
            if (Utils.isEmpty((String)userDef.getPassword())) {
                userDef.setPassword(oldUserDef.getPassword());
                continue;
            }
            if (userDef.getPassword().equals(oldUserDef.getPassword())) continue;
            String userID = tenantName + "_" + userDef.getID();
            UserDefinition dbUserDef = userDef.makeCopy(userID);
            modifiedUsers.add(dbUserDef);
        }
        if (modifiedUsers.size() > 0) {
            DBService.instance().modifyUsers(tenant, modifiedUsers);
        }
    }

    private void deleteAllUsers(TenantDefinition tenantDef) {
        String tenantName = tenantDef.getName();
        Tenant tenant = new Tenant(tenantName);
        ArrayList<UserDefinition> deletedUsers = new ArrayList<UserDefinition>();
        for (UserDefinition userDef : tenantDef.getUsers().values()) {
            String userID = tenantName + "_" + userDef.getID();
            UserDefinition dbUserDef = userDef.makeCopy(userID);
            deletedUsers.add(dbUserDef);
        }
        if (deletedUsers.size() > 0) {
            DBService.instance().deleteUsers(tenant, deletedUsers);
        }
    }

    private static boolean sameProperties(Map<String, String> map1, Map<String, String> map2) {
        for (String key : map1.keySet()) {
            if (map2.containsKey(key) && map1.get(key).equals(map2.get(key))) continue;
            return false;
        }
        for (String key : map2.keySet()) {
            if (map1.containsKey(key) && map2.get(key).equals(map1.get(key))) continue;
            return false;
        }
        return true;
    }

    public static interface TenantFilter {
        public boolean selectTenant(TenantDefinition var1);
    }
}

