/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.tenant;

import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.tenant.UserDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TenantDefinition {
    private String m_name;
    private final Map<String, UserDefinition> m_users = new HashMap<String, UserDefinition>();
    private final Map<String, String> m_options = new HashMap<String, String>();
    private final Map<String, String> m_properties = new HashMap<String, String>();

    public Tenant getTenant() {
        if (Utils.isEmpty((String)this.m_name)) {
            throw new RuntimeException("No tenant name defined");
        }
        return new Tenant(this.m_name);
    }

    public String getName() {
        return this.m_name;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.m_options);
    }

    public UserDefinition getUser(String userid) {
        return this.m_users.get(userid);
    }

    public Map<String, UserDefinition> getUsers() {
        return Collections.unmodifiableMap(this.m_users);
    }

    public int userCount() {
        return this.m_users.size();
    }

    public String getProperty(String propName) {
        return this.m_properties.get(propName);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.m_properties);
    }

    public UNode toDoc() {
        UNode tenantNode = UNode.createMapNode((String)this.m_name, (String)"tenant");
        if (this.m_options.size() > 0) {
            UNode optsNode = tenantNode.addMapNode("options");
            for (Map.Entry<String, String> entry : this.m_options.entrySet()) {
                optsNode.addValueNode(entry.getKey(), entry.getValue(), "option");
            }
        }
        if (this.m_properties.size() > 0) {
            UNode propsNode = tenantNode.addMapNode("properties");
            for (Map.Entry entry : this.m_properties.entrySet()) {
                propsNode.addValueNode((String)entry.getKey(), (String)entry.getValue(), "property");
            }
        }
        if (this.m_users.size() > 0) {
            UNode usersNode = tenantNode.addMapNode("users");
            for (UserDefinition userDefinition : this.m_users.values()) {
                usersNode.addChildNode(userDefinition.toDoc());
            }
        }
        return tenantNode;
    }

    public String toString() {
        return "Tenant: " + this.m_name;
    }

    public void setName(String tenantName) {
        this.m_name = tenantName;
    }

    public void addUser(UserDefinition userDef) {
        String userID = userDef.getID();
        Utils.require((!Utils.isEmpty((String)userID) ? 1 : 0) != 0, (String)"User ID must be set");
        Utils.require((!this.m_users.containsKey(userID) ? 1 : 0) != 0, (String)("Duplicate user ID: " + userID));
        this.m_users.put(userID, userDef);
    }

    public void setProperty(String name, String value) {
        this.m_properties.put(name, value);
    }

    public void parse(UNode tenantNode) {
        assert (tenantNode != null);
        this.m_name = tenantNode.getName();
        block10: for (String childName : tenantNode.getMemberNames()) {
            UNode childNode = tenantNode.getMember(childName);
            switch (childNode.getName()) {
                case "options": {
                    for (UNode optNode : childNode.getMemberList()) {
                        Utils.require((boolean)optNode.isValue(), (String)("'option' must be a value: " + optNode));
                        this.m_options.put(optNode.getName(), optNode.getValue());
                    }
                    continue block10;
                }
                case "users": {
                    for (UNode userNode : childNode.getMemberList()) {
                        UserDefinition userDef = new UserDefinition();
                        userDef.parse(userNode);
                        this.m_users.put(userDef.getID(), userDef);
                    }
                    continue block10;
                }
                case "properties": {
                    for (UNode propNode : childNode.getMemberList()) {
                        Utils.require((boolean)propNode.isValue(), (String)("'property' must be a value: " + propNode));
                        this.m_properties.put(propNode.getName(), propNode.getValue());
                    }
                    continue block10;
                }
                default: {
                    Utils.require((boolean)false, (String)("Unknown tenant property: " + childNode));
                }
            }
        }
    }
}

