/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.tenant;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.UNode;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.rest.UNodeOutCallback;
import com.dell.doradus.service.schema.SchemaService;
import com.dell.doradus.service.tenant.TenantService;

public class ListTenantsCmd
extends UNodeOutCallback {
    @Override
    public UNode invokeUNodeOut() {
        UNode rootNode = UNode.createMapNode((String)"tenants");
        for (Tenant tenant : TenantService.instance().getTenants()) {
            UNode tenantNode = rootNode.addMapNode(this.stripQuotes(tenant.getKeyspace()), "tenant");
            UNode appNode = tenantNode.addArrayNode("applications");
            for (ApplicationDefinition appDef : SchemaService.instance().getAllApplications(tenant)) {
                appNode.addValueNode("value", appDef.getAppName());
            }
        }
        return rootNode;
    }

    private String stripQuotes(String keyspace) {
        if (keyspace.charAt(0) == '\"' && keyspace.charAt(keyspace.length() - 1) == '\"') {
            return keyspace.substring(1, keyspace.length() - 1);
        }
        return keyspace;
    }
}

