/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.taskmanager;

import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class TaskRecord {
    public static final String PROP_EXECUTOR = "Executor";
    public static final String PROP_FINISH_TIME = "FinishTime";
    public static final String PROP_START_TIME = "StartTime";
    public static final String PROP_STATUS = "Status";
    private final String m_taskID;
    private String m_executor;
    private String m_finishTime;
    private String m_startTime;
    private TaskStatus m_status;

    public TaskRecord(String taskID) {
        this.m_taskID = taskID;
        this.m_status = TaskStatus.NEVER_EXECUTED;
    }

    public String getTaskID() {
        return this.m_taskID;
    }

    public Calendar getFinishTime() {
        GregorianCalendar calendar = new GregorianCalendar(Utils.UTC_TIMEZONE);
        if (Utils.isEmpty((String)this.m_finishTime)) {
            calendar.setTimeInMillis(0L);
        } else {
            calendar.setTimeInMillis(Long.parseLong(this.m_finishTime));
        }
        return calendar;
    }

    public Calendar getStartTime() {
        GregorianCalendar calendar = new GregorianCalendar(Utils.UTC_TIMEZONE);
        if (Utils.isEmpty((String)this.m_startTime)) {
            calendar.setTimeInMillis(0L);
        } else {
            calendar.setTimeInMillis(Long.parseLong(this.m_startTime));
        }
        return calendar;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> propMap = new HashMap<String, String>();
        if (!Utils.isEmpty((String)this.m_executor)) {
            propMap.put(PROP_EXECUTOR, this.m_executor);
        }
        if (!Utils.isEmpty((String)this.m_finishTime)) {
            propMap.put(PROP_FINISH_TIME, this.m_finishTime);
        }
        if (!Utils.isEmpty((String)this.m_startTime)) {
            propMap.put(PROP_START_TIME, this.m_startTime);
        }
        if (this.m_status != null) {
            propMap.put(PROP_STATUS, this.m_status.toString());
        }
        return propMap;
    }

    public TaskStatus getStatus() {
        return this.m_status;
    }

    public void setProperty(String name, String value) {
        switch (name) {
            case "Executor": {
                this.m_executor = value;
                break;
            }
            case "FinishTime": {
                this.m_finishTime = value;
                break;
            }
            case "StartTime": {
                this.m_startTime = value;
                break;
            }
            case "Status": {
                this.m_status = TaskStatus.findStatus(value);
            }
        }
    }

    public void setStatus(TaskStatus status) {
        this.m_status = status;
    }

    public UNode toDoc() {
        UNode rootNode = UNode.createMapNode((String)this.m_taskID, (String)"task");
        if (!Utils.isEmpty((String)this.m_executor)) {
            rootNode.addValueNode(PROP_EXECUTOR, this.m_executor);
        }
        if (!Utils.isEmpty((String)this.m_finishTime)) {
            rootNode.addValueNode(PROP_FINISH_TIME, this.formatTimestamp(this.m_finishTime));
        }
        if (!Utils.isEmpty((String)this.m_startTime)) {
            rootNode.addValueNode(PROP_START_TIME, this.formatTimestamp(this.m_startTime));
        }
        if (this.m_status != null) {
            rootNode.addValueNode(PROP_STATUS, this.m_status.toString());
        }
        return rootNode;
    }

    private String formatTimestamp(String value) {
        try {
            long longValue = Long.parseLong(value);
            return Utils.formatDate((long)longValue);
        }
        catch (NumberFormatException e) {
            return "Invalid timestamp: " + value;
        }
    }

    public static enum TaskStatus {
        NEVER_EXECUTED(""),
        IN_PROGRESS("In progress"),
        FAILED("Failed"),
        COMPLETED("Completed");

        private final String m_displayString;

        private TaskStatus(String displayString) {
            this.m_displayString = displayString;
        }

        public String toString() {
            return this.m_displayString;
        }

        public static TaskStatus findStatus(String displayString) {
            if (Utils.isEmpty((String)displayString)) {
                return NEVER_EXECUTED;
            }
            TaskStatus[] taskStatusArray = TaskStatus.values();
            int n = taskStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                TaskStatus status = taskStatusArray[n2];
                if (status.toString().equalsIgnoreCase(displayString)) {
                    return status;
                }
                ++n2;
            }
            return null;
        }
    }
}

