/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.taskmanager;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.service.Service;
import com.dell.doradus.service.StorageService;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.rest.RESTCommand;
import com.dell.doradus.service.rest.RESTService;
import com.dell.doradus.service.schema.SchemaService;
import com.dell.doradus.service.taskmanager.Task;
import com.dell.doradus.service.taskmanager.TaskExecutor;
import com.dell.doradus.service.taskmanager.TaskRecord;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskManagerService
extends Service {
    public static final String TASKS_STORE_NAME = "Tasks";
    private static final int SLEEP_TIME_MILLIS = 60000;
    private static final int CLAIM_WAIT_MILLIS = 1000;
    private static final int MAX_TASKS = 2;
    private static final TaskManagerService INSTANCE = new TaskManagerService();
    private Thread m_taskManager;
    private boolean m_bShutdown;
    private String m_localHost;
    private String m_hostClaimID = UUID.randomUUID().toString();
    private final ExecutorService m_executor = Executors.newFixedThreadPool(2);
    private final AtomicInteger m_currentTasks = new AtomicInteger();
    private static final List<RESTCommand> REST_RULES = Arrays.asList(new RESTCommand("GET /_tasks com.dell.doradus.service.taskmanager.ListTasksCmd"));

    private TaskManagerService() {
    }

    public static TaskManagerService instance() {
        return INSTANCE;
    }

    @Override
    protected void initService() {
        RESTService.instance().registerGlobalCommands(REST_RULES);
    }

    @Override
    protected void startService() {
        DBService.instance().waitForFullService();
        this.m_taskManager = new Thread("Task Manager"){

            @Override
            public void run() {
                TaskManagerService.this.manageTasks();
            }
        };
        this.m_taskManager.start();
    }

    @Override
    protected void stopService() {
        if (this.getState().isRunning()) {
            this.m_bShutdown = true;
            if (this.m_taskManager != null) {
                this.m_taskManager.interrupt();
                try {
                    this.m_taskManager.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void incrementActiveTasks() {
        this.m_currentTasks.incrementAndGet();
    }

    public void decrementActiveTasks() {
        this.m_currentTasks.decrementAndGet();
    }

    public Collection<TaskRecord> getTaskRecords(Tenant tenant) {
        this.checkServiceState();
        Iterator<DRow> rowIter = DBService.instance().getAllRowsAllColumns(tenant, TASKS_STORE_NAME);
        ArrayList<TaskRecord> taskRecords = new ArrayList<TaskRecord>();
        while (rowIter.hasNext()) {
            DRow row = rowIter.next();
            String taskID = row.getKey();
            if (taskID.startsWith("_claim/")) continue;
            Iterator<DColumn> colIter = row.getColumns();
            TaskRecord taskRecord = this.buildTaskRecord(taskID, colIter);
            taskRecords.add(taskRecord);
        }
        return taskRecords;
    }

    private void manageTasks() {
        this.setHostAddress();
        while (!this.m_bShutdown) {
            this.checkAllTasks();
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.m_executor.shutdown();
    }

    private void checkAllTasks() {
        for (Tenant tenant : DBService.instance().getTenants()) {
            this.checkTenantTasks(tenant);
            if (!this.m_bShutdown) continue;
            break;
        }
    }

    private void checkTenantTasks(Tenant tenant) {
        this.m_logger.debug("Checking tenant '{}' for needy tasks", (Object)tenant);
        for (ApplicationDefinition appDef : SchemaService.instance().getAllApplications(tenant)) {
            for (Task task : this.getAppTasks(appDef)) {
                this.checkTaskForExecution(appDef, task);
            }
        }
    }

    private void checkTaskForExecution(ApplicationDefinition appDef, Task task) {
        Tenant tenant = Tenant.getTenant(appDef);
        this.m_logger.debug("Checking task '{}' in tenant '{}'", (Object)task.getTaskID(), (Object)tenant);
        Iterator<DColumn> colIter = DBService.instance().getAllColumns(tenant, TASKS_STORE_NAME, task.getTaskID());
        TaskRecord taskRecord = null;
        taskRecord = colIter == null ? this.storeTaskRecord(tenant, task) : this.buildTaskRecord(task.getTaskID(), colIter);
        if (this.taskShouldExecute(task, taskRecord) && this.canHandleMoreTasks()) {
            this.attemptToExecuteTask(appDef, task, taskRecord);
        }
    }

    private boolean taskShouldExecute(Task task, TaskRecord taskRecord) {
        long nowMillis;
        long taskPeriodMillis;
        String taskID = taskRecord.getTaskID();
        if (taskRecord.getStatus() == TaskRecord.TaskStatus.NEVER_EXECUTED) {
            this.m_logger.debug("Task '{}' has never executed", (Object)taskID);
            return true;
        }
        if (taskRecord.getStatus() == TaskRecord.TaskStatus.IN_PROGRESS) {
            this.m_logger.debug("Task '{}' is already being executed", (Object)taskID);
            return false;
        }
        long startTimeMillis = taskRecord.getStartTime().getTimeInMillis();
        boolean bShouldStart = startTimeMillis + (taskPeriodMillis = (long)(task.getTaskFreq().getValueInMinutes() * 60 * 1000)) <= (nowMillis = System.currentTimeMillis());
        this.m_logger.debug("Considering task {}: Last started at {}; periodicity in millis: {}; current time: {}; next start: {}; should start: {}", new Object[]{task.getTaskID(), Utils.formatDateUTC((long)startTimeMillis, (int)14), taskPeriodMillis, Utils.formatDateUTC((long)nowMillis, (int)14), Utils.formatDateUTC((long)(startTimeMillis + taskPeriodMillis), (int)14), bShouldStart});
        return bShouldStart;
    }

    private boolean canHandleMoreTasks() {
        return this.m_currentTasks.get() < 2;
    }

    private void attemptToExecuteTask(ApplicationDefinition appDef, Task task, TaskRecord taskRecord) {
        Tenant tenant = Tenant.getTenant(appDef);
        String taskID = taskRecord.getTaskID();
        String claimID = "_claim/" + taskID;
        long claimStamp = System.currentTimeMillis();
        this.writeTaskClaim(tenant, claimID, claimStamp);
        if (this.taskClaimedByUs(tenant, claimID)) {
            this.startTask(appDef, task, taskRecord);
        }
    }

    private void startTask(ApplicationDefinition appDef, Task task, TaskRecord taskRecord) {
        try {
            Class<? extends TaskExecutor> jobClass = task.getExecutorClass();
            Constructor<? extends TaskExecutor> noArgConstructor = jobClass.getConstructor(null);
            TaskExecutor executor = noArgConstructor.newInstance(null);
            executor.setParams(this.m_localHost, appDef, taskRecord);
            this.m_executor.execute(executor);
        }
        catch (Exception e) {
            this.m_logger.error("Failed to start task '" + task.getTaskID() + "'", (Throwable)e);
        }
    }

    private boolean taskClaimedByUs(Tenant tenant, String claimID) {
        this.waitForClaim();
        Iterator<DColumn> colIter = DBService.instance().getAllColumns(tenant, TASKS_STORE_NAME, claimID);
        if (colIter == null) {
            this.m_logger.warn("Claim record disappeared: {}", (Object)claimID);
            return false;
        }
        String claimingHost = this.m_hostClaimID;
        long earliestClaim = Long.MAX_VALUE;
        while (colIter.hasNext()) {
            DColumn col = colIter.next();
            try {
                long claimStamp = Long.parseLong(col.getValue());
                String claimHost = col.getName();
                if (claimStamp < earliestClaim) {
                    claimingHost = claimHost;
                    earliestClaim = claimStamp;
                    continue;
                }
                if (claimStamp != earliestClaim || claimHost.compareTo(claimingHost) >= 0) continue;
                claimingHost = claimHost;
            }
            catch (NumberFormatException e) {}
        }
        return claimingHost.equals(this.m_hostClaimID) && !this.m_bShutdown;
    }

    private void waitForClaim() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void writeTaskClaim(Tenant tenant, String claimID, long claimStamp) {
        DBTransaction dbTran = DBService.instance().startTransaction(tenant);
        dbTran.addColumn(TASKS_STORE_NAME, claimID, this.m_hostClaimID, claimStamp);
        DBService.instance().commit(dbTran);
    }

    private TaskRecord buildTaskRecord(String taskID, Iterator<DColumn> colIter) {
        TaskRecord taskRecord = new TaskRecord(taskID);
        while (colIter.hasNext()) {
            DColumn col = colIter.next();
            taskRecord.setProperty(col.getName(), col.getValue());
        }
        return taskRecord;
    }

    private TaskRecord storeTaskRecord(Tenant tenant, Task task) {
        DBTransaction dbTran = DBService.instance().startTransaction(tenant);
        TaskRecord taskRecord = new TaskRecord(task.getTaskID());
        Map<String, String> propMap = taskRecord.getProperties();
        assert (propMap.size() > 0) : "Need at least one property to store a row!";
        for (String propName : propMap.keySet()) {
            dbTran.addColumn(TASKS_STORE_NAME, task.getTaskID(), propName, propMap.get(propName));
        }
        DBService.instance().commit(dbTran);
        return taskRecord;
    }

    private List<Task> getAppTasks(ApplicationDefinition appDef) {
        ArrayList<Task> appTasks = new ArrayList<Task>();
        try {
            StorageService service = SchemaService.instance().getStorageService(appDef);
            Collection<Task> appTaskColl = service.getAppTasks(appDef);
            if (appTaskColl != null) {
                appTasks.addAll(service.getAppTasks(appDef));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return appTasks;
    }

    private void setHostAddress() {
        try {
            this.m_localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            this.m_localHost = "0.0.0.0";
        }
    }
}

