/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.taskmanager;

import com.dell.doradus.common.Utils;
import java.util.ArrayList;

public class TaskId {
    private String m_appName;
    private String m_tableName;
    private String m_taskType;
    private String m_param;

    private TaskId() {
    }

    public String getAppName() {
        return this.m_appName;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public String getTaskType() {
        return this.m_taskType;
    }

    public String getParam() {
        return this.m_param;
    }

    public static TaskId fromScheduleId(String scheduleId) {
        TaskId task = new TaskId();
        String[] nameParts = scheduleId.split("/");
        task.m_appName = nameParts[1];
        task.m_tableName = "*".equals(nameParts[2]) ? null : nameParts[2];
        task.m_taskType = nameParts[0];
        if (nameParts.length > 3) {
            task.m_param = nameParts[3];
        }
        return task;
    }

    public static TaskId fromTaskTableId(String taskTableId) {
        TaskId task = new TaskId();
        String[] nameParts = taskTableId.split("/");
        task.m_appName = nameParts[0];
        task.m_tableName = "*".equals(nameParts[1]) ? null : nameParts[1];
        task.m_taskType = nameParts[2];
        if (nameParts.length > 3) {
            task.m_param = nameParts[3];
        }
        return task;
    }

    public String getScheduleId() {
        String tableName = this.m_tableName == null ? "*" : this.m_tableName;
        ArrayList<String> nameParts = new ArrayList<String>();
        nameParts.add(this.m_taskType);
        nameParts.add(this.m_appName);
        nameParts.add(tableName);
        if (this.m_param != null) {
            nameParts.add(this.m_param);
        }
        return Utils.concatenate(nameParts, (String)"/");
    }

    public String getTaskTableId() {
        String tableName = this.m_tableName == null ? "*" : this.m_tableName;
        ArrayList<String> nameParts = new ArrayList<String>();
        nameParts.add(this.m_appName);
        nameParts.add(tableName);
        nameParts.add(this.m_taskType);
        if (this.m_param != null) {
            nameParts.add(this.m_param);
        }
        return Utils.concatenate(nameParts, (String)"/");
    }

    public boolean equals(Object o) {
        boolean equals;
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof TaskId)) {
            return false;
        }
        TaskId obj = (TaskId)o;
        boolean bl = equals = this.m_appName.equals(obj.m_appName) && this.m_taskType.equals(obj.m_taskType);
        equals = this.m_tableName == null ? (equals &= obj.m_tableName == null) : (equals &= this.m_tableName.equals(obj.m_tableName));
        equals = this.m_param == null ? (equals &= obj.m_param == null) : (equals &= this.m_param.equals(obj.m_param));
        return equals;
    }

    public int hashCode() {
        int hash = this.m_appName.hashCode() ^ this.m_taskType.hashCode();
        if (this.m_tableName != null) {
            hash ^= this.m_tableName.hashCode();
        }
        if (this.m_param != null) {
            hash ^= this.m_param.hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.getTaskTableId();
    }
}

