/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.taskmanager;

import com.dell.doradus.common.Utils;

public class TaskFrequency {
    private final Frequency m_units;
    private final int m_value;

    public TaskFrequency(String freqString) throws IllegalArgumentException {
        String[] parts = freqString.trim().split(" +");
        Utils.require((parts.length == 2 ? 1 : 0) != 0, (String)("Invalid frequency format: " + freqString));
        try {
            this.m_value = Integer.parseInt(parts[0]);
            this.m_units = Frequency.find(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid frequency format: " + freqString);
        }
        Utils.require((this.m_value != 0 ? 1 : 0) != 0, (String)"Frequency value cannot be 0");
    }

    public Frequency getUnits() {
        return this.m_units;
    }

    public int getValue() {
        return this.m_value;
    }

    public int getValueInMinutes() {
        switch (this.m_units) {
            case MINUTES: {
                return this.m_value;
            }
            case HOURS: {
                return this.m_value * 60;
            }
            case DAYS: {
                return this.m_value * 60 * 24;
            }
        }
        throw new RuntimeException("Unhandled case: " + (Object)((Object)this.m_units));
    }

    public String toString() {
        return String.valueOf(Integer.toString(this.m_value)) + " " + this.m_units.toString();
    }

    public static enum Frequency {
        MINUTES,
        HOURS,
        DAYS;


        public static Frequency find(String mnemonic) {
            String value = mnemonic.toUpperCase();
            if (!value.endsWith("S")) {
                value = String.valueOf(value) + "S";
            }
            return Frequency.valueOf(value);
        }
    }
}

