/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.taskmanager;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.taskmanager.TaskManagerService;
import com.dell.doradus.service.taskmanager.TaskRecord;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskExecutor
implements Runnable {
    protected final Logger m_logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    protected String m_hostID;
    protected Tenant m_tenant;
    protected ApplicationDefinition m_appDef;
    protected TaskRecord m_taskRecord;

    void setParams(String hostID, ApplicationDefinition appDef, TaskRecord taskRecord) {
        this.m_hostID = hostID;
        this.m_tenant = Tenant.getTenant(appDef);
        this.m_appDef = appDef;
        this.m_taskRecord = taskRecord;
    }

    public abstract void execute();

    @Override
    public final void run() {
        String taskID = this.m_taskRecord.getTaskID();
        this.m_logger.debug("Starting task '{}' in tenant '{}'", (Object)taskID, (Object)this.m_tenant);
        try {
            try {
                TaskManagerService.instance().incrementActiveTasks();
                this.setTaskStart();
                this.execute();
                this.setTaskFinish();
            }
            catch (Throwable e) {
                this.m_logger.error("Task '" + taskID + "' failed", e);
                this.setTaskFailed();
                TaskManagerService.instance().decrementActiveTasks();
            }
        }
        finally {
            TaskManagerService.instance().decrementActiveTasks();
        }
    }

    public ApplicationDefinition getAppDef() {
        return this.m_appDef;
    }

    private void setTaskStart() {
        this.m_taskRecord.setProperty("Executor", this.m_hostID);
        this.m_taskRecord.setProperty("StartTime", Long.toString(System.currentTimeMillis()));
        this.m_taskRecord.setStatus(TaskRecord.TaskStatus.IN_PROGRESS);
        this.updateTaskStatus(false);
    }

    private void setTaskFinish() {
        this.m_taskRecord.setProperty("Executor", this.m_hostID);
        this.m_taskRecord.setProperty("FinishTime", Long.toString(System.currentTimeMillis()));
        this.m_taskRecord.setStatus(TaskRecord.TaskStatus.COMPLETED);
        this.updateTaskStatus(true);
    }

    private void setTaskFailed() {
        this.m_taskRecord.setProperty("Executor", this.m_hostID);
        this.m_taskRecord.setProperty("FinishTime", Long.toString(System.currentTimeMillis()));
        this.m_taskRecord.setStatus(TaskRecord.TaskStatus.FAILED);
        this.updateTaskStatus(true);
    }

    private void updateTaskStatus(boolean bDeleteClaimRecord) {
        String taskID = this.m_taskRecord.getTaskID();
        DBTransaction dbTran = DBService.instance().startTransaction(this.m_tenant);
        Map<String, String> propMap = this.m_taskRecord.getProperties();
        for (String name : propMap.keySet()) {
            dbTran.addColumn("Tasks", taskID, name, propMap.get(name));
        }
        if (bDeleteClaimRecord) {
            dbTran.deleteRow("Tasks", "_claim/" + taskID);
        }
        DBService.instance().commit(dbTran);
    }
}

