/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.taskmanager;

import com.dell.doradus.common.Utils;
import com.dell.doradus.service.taskmanager.TaskExecutor;
import com.dell.doradus.service.taskmanager.TaskFrequency;

public class Task {
    private final String m_appName;
    private final String m_tableName;
    private final String m_taskName;
    private final TaskFrequency m_taskFreq;
    private final Class<? extends TaskExecutor> m_executorClass;

    public Task(String appName, String tableName, String taskName, String taskFreq, Class<? extends TaskExecutor> executorClass) {
        this.m_appName = appName;
        this.m_tableName = Utils.isEmpty((String)tableName) ? "*" : tableName;
        this.m_taskName = taskName;
        this.m_taskFreq = new TaskFrequency(taskFreq);
        this.m_executorClass = executorClass;
    }

    public String getAppName() {
        return this.m_appName;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public String getTaskName() {
        return this.m_taskName;
    }

    public TaskFrequency getTaskFreq() {
        return this.m_taskFreq;
    }

    public String getTaskID() {
        return String.valueOf(this.m_appName) + "/" + this.m_tableName + "/" + this.m_taskName;
    }

    public Class<? extends TaskExecutor> getExecutorClass() {
        return this.m_executorClass;
    }

    public String toString() {
        return this.getTaskID();
    }
}

