/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.DBObject;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.spider.SpiderService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiderTransaction {
    public static final String ALL_OBJECTS_ROW_KEY = "_";
    public static final String SHARDS_ROW_KEY = "_shards";
    public static final String FIELD_REGISTRY_ROW_KEY = "_fields";
    public static final String TERMS_REGISTRY_ROW_PREFIX = "_terms";
    private static Logger m_logger = LoggerFactory.getLogger((String)SpiderTransaction.class.getSimpleName());
    private final Map<String, Map<String, Map<String, byte[]>>> m_columnAdds = new HashMap<String, Map<String, Map<String, byte[]>>>();
    private final Map<String, Map<String, List<String>>> m_columnDeletes = new HashMap<String, Map<String, List<String>>>();
    private final Map<String, List<String>> m_rowDeletes = new HashMap<String, List<String>>();

    public void mergeSubTransaction(SpiderTransaction subTran) {
        Map<String, Object> rowMap;
        for (String storeName : subTran.m_columnAdds.keySet()) {
            rowMap = subTran.m_columnAdds.get(storeName);
            for (String rowKey : rowMap.keySet()) {
                Map colMap = (Map)rowMap.get(rowKey);
                for (String colName : colMap.keySet()) {
                    this.addColumn(storeName, rowKey, colName, (byte[])colMap.get(colName));
                }
            }
        }
        for (String storeName : subTran.m_columnDeletes.keySet()) {
            rowMap = subTran.m_columnDeletes.get(storeName);
            for (String rowKey : rowMap.keySet()) {
                this.deleteColumns(storeName, rowKey, (Collection)rowMap.get(rowKey));
            }
        }
        for (String storeName : subTran.m_rowDeletes.keySet()) {
            for (String rowKey : subTran.m_rowDeletes.get(storeName)) {
                this.deleteRow(storeName, rowKey);
            }
        }
    }

    public void applyUpdates(DBTransaction dbTran) {
        Map<String, Object> rowMap;
        for (String storeName : this.m_columnAdds.keySet()) {
            rowMap = this.m_columnAdds.get(storeName);
            for (String rowKey : rowMap.keySet()) {
                Map colMap = (Map)rowMap.get(rowKey);
                for (String colName : colMap.keySet()) {
                    byte[] colValue = (byte[])colMap.get(colName);
                    if (colValue == null) {
                        dbTran.addColumn(storeName, rowKey, colName);
                        continue;
                    }
                    dbTran.addColumn(storeName, rowKey, colName, colValue);
                }
            }
        }
        for (String storeName : this.m_columnDeletes.keySet()) {
            rowMap = this.m_columnDeletes.get(storeName);
            for (String rowKey : rowMap.keySet()) {
                dbTran.deleteColumns(storeName, rowKey, (Collection)rowMap.get(rowKey));
            }
        }
        for (String storeName : this.m_rowDeletes.keySet()) {
            for (String rowKey : this.m_rowDeletes.get(storeName)) {
                dbTran.deleteRow(storeName, rowKey);
            }
        }
    }

    public void clear() {
        this.m_columnAdds.clear();
        this.m_columnDeletes.clear();
        this.m_rowDeletes.clear();
    }

    public int getUpdateCount() {
        return this.m_columnAdds.size() + this.m_columnDeletes.size() + this.m_rowDeletes.size();
    }

    public void addAllObjectsColumn(TableDefinition tableDef, String objID, int shardNo) {
        String rowKey = ALL_OBJECTS_ROW_KEY;
        if (shardNo > 0) {
            rowKey = shardNo + "/" + ALL_OBJECTS_ROW_KEY;
        }
        this.addColumn(SpiderService.termsStoreName(tableDef), rowKey, objID);
    }

    public void addIDValueColumn(TableDefinition tableDef, String objID) {
        this.addColumn(SpiderService.objectsStoreName(tableDef), objID, "_ID", Utils.toBytes((String)objID));
    }

    public void addFieldReferences(TableDefinition tableDef, Collection<String> fieldNames) {
        for (String fieldName : fieldNames) {
            this.addColumn(SpiderService.termsStoreName(tableDef), FIELD_REGISTRY_ROW_KEY, fieldName);
        }
    }

    public void addLinkValue(String ownerObjID, FieldDefinition linkDef, String targetObjID) {
        this.addColumn(SpiderService.objectsStoreName(linkDef.getTableDef()), ownerObjID, SpiderService.linkColumnName(linkDef, targetObjID));
    }

    public void addScalarValueColumn(TableDefinition tableDef, String objID, String fieldName, String fieldValue) {
        this.addColumn(SpiderService.objectsStoreName(tableDef), objID, fieldName, SpiderService.scalarValueToBinary(tableDef, fieldName, fieldValue));
    }

    public void addShardedLinkValue(String ownerObjID, FieldDefinition linkDef, String targetObjID, int targetShardNo) {
        assert (linkDef.isSharded());
        assert (targetShardNo > 0);
        this.addColumn(SpiderService.termsStoreName(linkDef.getTableDef()), SpiderService.shardedLinkTermRowKey(linkDef, ownerObjID, targetShardNo), targetObjID);
    }

    public void addShardStart(TableDefinition tableDef, int shardNumber, Date startDate) {
        assert (tableDef.isSharded() && shardNumber > 0);
        this.addColumn(SpiderService.termsStoreName(tableDef), SHARDS_ROW_KEY, Integer.toString(shardNumber), Utils.toBytes((String)Long.toString(startDate.getTime())));
    }

    public void addTermIndexColumn(TableDefinition tableDef, DBObject dbObj, String fieldName, String term) {
        this.addColumn(SpiderService.termsStoreName(tableDef), SpiderService.termIndexRowKey(tableDef, dbObj, fieldName, term), dbObj.getObjectID());
    }

    public void addTermReferences(TableDefinition tableDef, int shardNumber, Map<String, Set<String>> fieldTermsRefMap) {
        StringBuilder rowKey = new StringBuilder();
        for (String fieldName : fieldTermsRefMap.keySet()) {
            for (String term : fieldTermsRefMap.get(fieldName)) {
                rowKey.setLength(0);
                if (shardNumber > 0) {
                    rowKey.append(shardNumber);
                    rowKey.append("/");
                }
                rowKey.append(TERMS_REGISTRY_ROW_PREFIX);
                rowKey.append("/");
                rowKey.append(fieldName);
                this.addColumn(SpiderService.termsStoreName(tableDef), rowKey.toString(), term);
            }
        }
    }

    public void deleteAllObjectsColumn(TableDefinition tableDef, String objID, int shardNo) {
        String rowKey = ALL_OBJECTS_ROW_KEY;
        if (shardNo > 0) {
            rowKey = shardNo + "/" + ALL_OBJECTS_ROW_KEY;
        }
        this.deleteColumn(SpiderService.termsStoreName(tableDef), rowKey, objID);
    }

    public void deleteObjectRow(TableDefinition tableDef, String objID) {
        this.deleteRow(SpiderService.objectsStoreName(tableDef), objID);
    }

    public void deleteScalarValueColumn(TableDefinition tableDef, String objID, String fieldName) {
        this.deleteColumn(SpiderService.objectsStoreName(tableDef), objID, fieldName);
    }

    public void deleteTermIndexColumn(TableDefinition tableDef, DBObject dbObj, String fieldName, String term) {
        this.deleteColumn(SpiderService.termsStoreName(tableDef), SpiderService.termIndexRowKey(tableDef, dbObj, fieldName, term), dbObj.getObjectID());
    }

    public void deleteLinkValue(String ownerObjID, FieldDefinition linkDef, String targetObjID) {
        this.deleteColumn(SpiderService.objectsStoreName(linkDef.getTableDef()), ownerObjID, SpiderService.linkColumnName(linkDef, targetObjID));
    }

    public void deleteShardedLinkRow(FieldDefinition linkDef, String owningObjID, int shardNumber) {
        assert (linkDef.isSharded());
        assert (shardNumber > 0);
        this.deleteRow(SpiderService.termsStoreName(linkDef.getTableDef()), SpiderService.shardedLinkTermRowKey(linkDef, owningObjID, shardNumber));
    }

    public void deleteShardedLinkValue(String objID, FieldDefinition linkDef, String targetObjID, int shardNo) {
        assert (linkDef.isSharded());
        assert (shardNo > 0);
        this.deleteColumn(SpiderService.termsStoreName(linkDef.getTableDef()), SpiderService.shardedLinkTermRowKey(linkDef, objID, shardNo), targetObjID);
    }

    private void addColumn(String storeName, String rowKey, String colName) {
        this.addColumn(storeName, rowKey, colName, null);
    }

    private void addColumn(String storeName, String rowKey, String colName, byte[] colValue) {
        byte[] oldValue;
        Map<String, byte[]> colMap;
        Map<String, Map<String, byte[]>> rowMap = this.m_columnAdds.get(storeName);
        if (rowMap == null) {
            rowMap = new HashMap<String, Map<String, byte[]>>();
            this.m_columnAdds.put(storeName, rowMap);
        }
        if ((colMap = rowMap.get(rowKey)) == null) {
            colMap = new HashMap<String, byte[]>();
            rowMap.put(rowKey, colMap);
        }
        if ((oldValue = colMap.put(colName, colValue)) != null && !Arrays.equals(oldValue, colValue)) {
            m_logger.debug("Warning: duplicate column mutation with different value: store={}, row={}, col={}, old={}, new={}", new Object[]{storeName, rowKey, colName, oldValue, colValue});
        }
    }

    private void deleteColumn(String storeName, String rowKey, String colName) {
        List<String> colNames;
        Map<String, List<String>> rowMap = this.m_columnDeletes.get(storeName);
        if (rowMap == null) {
            rowMap = new HashMap<String, List<String>>();
            this.m_columnDeletes.put(storeName, rowMap);
        }
        if ((colNames = rowMap.get(rowKey)) == null) {
            colNames = new ArrayList<String>();
            rowMap.put(rowKey, colNames);
        }
        colNames.add(colName);
    }

    private void deleteColumns(String storeName, String rowKey, Collection<String> colNames) {
        List<String> colList;
        Map<String, List<String>> rowMap = this.m_columnDeletes.get(storeName);
        if (rowMap == null) {
            rowMap = new HashMap<String, List<String>>();
            this.m_columnDeletes.put(storeName, rowMap);
        }
        if ((colList = rowMap.get(rowKey)) == null) {
            colList = new ArrayList<String>();
            rowMap.put(rowKey, colList);
        }
        colNames.addAll(colNames);
    }

    private void deleteRow(String storeName, String rowKey) {
        List<String> rowKeys = this.m_rowDeletes.get(storeName);
        if (rowKeys == null) {
            rowKeys = new ArrayList<String>();
            this.m_rowDeletes.put(storeName, rowKeys);
        }
        rowKeys.add(rowKey);
    }
}

